/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import org.restlet.data.MediaType;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectRepresentation<T extends Serializable>
extends OutputRepresentation {
    public static final boolean VARIANT_OBJECT_XML_SUPPORTED = Boolean.getBoolean("org.restlet.representation.ObjectRepresentation.VARIANT_OBJECT_XML_SUPPORTED");
    public static final boolean VARIANT_OBJECT_BINARY_SUPPORTED = Boolean.getBoolean("org.restlet.representation.ObjectRepresentation.VARIANT_OBJECT_BINARY_SUPPORTED");
    private volatile T object;

    public ObjectRepresentation(Representation serializedRepresentation) throws IOException, ClassNotFoundException, IllegalArgumentException {
        this(serializedRepresentation, (ClassLoader)null);
    }

    public ObjectRepresentation(Representation serializedRepresentation, final ClassLoader classLoader) throws IOException, ClassNotFoundException, IllegalArgumentException {
        super(MediaType.APPLICATION_JAVA_OBJECT);
        if (serializedRepresentation.getMediaType().equals(MediaType.APPLICATION_JAVA_OBJECT)) {
            if (!VARIANT_OBJECT_BINARY_SUPPORTED) {
                throw new IllegalArgumentException("SECURITY WARNING: The usage of ObjectInputStream when deserializing binary presentations from unstrusted sources can lead to malicious attacks. As pointed here (https://github.com/restlet/restlet-framework-java/issues/778), the ObjectInputStream class is able to force the JVM to execute unwanted Java code. Thus, the support of such format has been disactivated by default. You can activate this support by turning on the following system property: org.restlet.representation.ObjectRepresentation.VARIANT_OBJECT_BINARY_SUPPORTED.");
            }
            this.setMediaType(MediaType.APPLICATION_JAVA_OBJECT);
            InputStream is = serializedRepresentation.getStream();
            ObjectInputStream ois = null;
            ois = classLoader != null ? new ObjectInputStream(is){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    return Class.forName(desc.getName(), false, classLoader);
                }
            } : new ObjectInputStream(is);
            this.object = (Serializable)ois.readObject();
            if (is.read() != -1) {
                throw new IOException("The input stream has not been fully read.");
            }
            ois.close();
        } else if (VARIANT_OBJECT_XML_SUPPORTED && serializedRepresentation.getMediaType().equals(MediaType.APPLICATION_JAVA_OBJECT_XML)) {
            if (!VARIANT_OBJECT_XML_SUPPORTED) {
                throw new IllegalArgumentException("SECURITY WARNING: The usage of XMLDecoder when deserializing XML presentations from unstrusted sources can lead to malicious attacks. As pointed here (http://blog.diniscruz.com/2013/08/using-xmldecoder-to-execute-server-side.html), the XMLDecoder class is able to force the JVM to execute unwanted Java code described inside the XML file. Thus, the support of such format has been disactivated by default. You can activate this support by turning on the following system property: org.restlet.representation.ObjectRepresentation.VARIANT_OBJECT_XML_SUPPORTED.");
            }
            this.setMediaType(MediaType.APPLICATION_JAVA_OBJECT_XML);
            InputStream is = serializedRepresentation.getStream();
            XMLDecoder decoder = new XMLDecoder(is);
            this.object = (Serializable)decoder.readObject();
            if (is.read() != -1) {
                throw new IOException("The input stream has not been fully read.");
            }
            decoder.close();
        }
        throw new IllegalArgumentException("The serialized representation must have this media type: " + MediaType.APPLICATION_JAVA_OBJECT.toString() + " or this one: " + MediaType.APPLICATION_JAVA_OBJECT_XML.toString());
    }

    public ObjectRepresentation(T object) {
        super(MediaType.APPLICATION_JAVA_OBJECT);
        this.object = object;
    }

    public ObjectRepresentation(T object, MediaType mediaType) {
        super(mediaType == null ? MediaType.APPLICATION_JAVA_OBJECT : mediaType);
        this.object = object;
    }

    public T getObject() throws IOException {
        return this.object;
    }

    @Override
    public void release() {
        this.setObject(null);
        super.release();
    }

    public void setObject(T object) {
        this.object = object;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (MediaType.APPLICATION_JAVA_OBJECT.isCompatible(this.getMediaType())) {
            ObjectOutputStream oos = new ObjectOutputStream(outputStream);
            oos.writeObject(this.getObject());
            oos.flush();
        } else if (MediaType.APPLICATION_JAVA_OBJECT_XML.isCompatible(this.getMediaType())) {
            XMLEncoder encoder = new XMLEncoder(outputStream);
            encoder.writeObject(this.getObject());
            encoder.close();
        }
    }
}

