/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plugin.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.IDictionaryService;
import org.adempiere.util.ServerContext;
import org.compiere.Adempiere;
import org.compiere.model.Query;
import org.compiere.model.ServerStateChangeEvent;
import org.compiere.model.ServerStateChangeListener;
import org.compiere.model.X_AD_Package_Imp;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class AdempiereActivator
implements BundleActivator,
ServiceTrackerCustomizer<IDictionaryService, IDictionaryService> {
    protected static final CLogger logger = CLogger.getCLogger((String)AdempiereActivator.class.getName());
    private BundleContext context;
    private ServiceTracker<IDictionaryService, IDictionaryService> serviceTracker;
    private IDictionaryService service;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(this.getName()) + " " + this.getVersion() + " starting...");
        }
        this.serviceTracker = new ServiceTracker(context, IDictionaryService.class.getName(), (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        this.start();
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(this.getName()) + " " + this.getVersion() + " ready.");
        }
    }

    public String getName() {
        return this.context.getBundle().getSymbolicName();
    }

    public String getVersion() {
        return (String)this.context.getBundle().getHeaders().get("Bundle-Version");
    }

    public String getDescription() {
        return this.getName();
    }

    private void installPackage() {
        String trxName = Trx.createTrxName();
        try {
            String version = this.getVersion();
            if (version != null) {
                int count = 0;
                int index = -1;
                int i = 0;
                while (i < version.length()) {
                    if (version.charAt(i) == '.') {
                        ++count;
                    }
                    if (count == 3) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index == -1) {
                    index = version.length();
                }
                version = version.substring(0, index);
            }
            String where = "Name=? AND PK_Version LIKE ?";
            Query q = new Query(Env.getCtx(), "AD_Package_Imp", where.toString(), null);
            q.setParameters(new Object[]{this.getName(), String.valueOf(version) + "%"});
            X_AD_Package_Imp pkg = (X_AD_Package_Imp)q.first();
            if (pkg == null) {
                System.out.println("Installing " + this.getName() + " " + version + " ...");
                this.packIn(trxName);
                this.install();
                System.out.println(String.valueOf(this.getName()) + " " + version + " installed.");
            } else if (logger.isLoggable(Level.INFO)) {
                logger.info(String.valueOf(this.getName()) + " " + version + " was installed: " + pkg.getCreated());
            }
            Trx.get((String)trxName, (boolean)false).commit();
        }
        finally {
            if (Trx.get((String)trxName, (boolean)false) != null) {
                Trx.get((String)trxName, (boolean)false).close();
            }
        }
    }

    protected void packIn(String trxName) {
        block14: {
            URL packout = this.context.getBundle().getEntry("/META-INF/2Pack.zip");
            if (packout != null && this.service != null) {
                FileOutputStream zipstream = null;
                try {
                    try {
                        int read;
                        InputStream stream = this.context.getBundle().getEntry("/META-INF/2Pack.zip").openStream();
                        File zipfile = File.createTempFile(this.getName(), ".zip");
                        zipstream = new FileOutputStream(zipfile);
                        byte[] buffer = new byte[1024];
                        while ((read = stream.read(buffer)) != -1) {
                            zipstream.write(buffer, 0, read);
                        }
                        this.service.merge(this.context, zipfile);
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Pack in failed.", e);
                        if (zipstream == null) break block14;
                        try {
                            zipstream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    if (zipstream != null) {
                        try {
                            zipstream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    protected BundleContext getContext() {
        return this.context;
    }

    protected void setContext(BundleContext context) {
        this.context = context;
    }

    public void stop(BundleContext context) throws Exception {
        this.stop();
        this.serviceTracker.close();
        this.context = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(context.getBundle().getSymbolicName()) + " " + (String)context.getBundle().getHeaders().get("Bundle-Version") + " stopped.");
        }
    }

    protected void install() {
    }

    protected void start() {
    }

    protected void stop() {
    }

    public IDictionaryService addingService(ServiceReference<IDictionaryService> reference) {
        this.service = (IDictionaryService)this.context.getService(reference);
        if (Adempiere.getThreadPoolExecutor() != null) {
            Adempiere.getThreadPoolExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(AdempiereActivator.class.getClassLoader());
                        AdempiereActivator.this.setupPackInContext();
                        AdempiereActivator.this.installPackage();
                    }
                    finally {
                        ServerContext.dispose();
                        AdempiereActivator.this.service = null;
                        Thread.currentThread().setContextClassLoader(cl);
                    }
                }
            });
        } else {
            Adempiere.addServerStateChangeListener((ServerStateChangeListener)new ServerStateChangeListener(){

                public void stateChange(ServerStateChangeEvent event) {
                    if (event.getEventType() == 0 && AdempiereActivator.this.service != null) {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(AdempiereActivator.class.getClassLoader());
                            AdempiereActivator.this.setupPackInContext();
                            AdempiereActivator.this.installPackage();
                        }
                        finally {
                            ServerContext.dispose();
                            AdempiereActivator.this.service = null;
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                    }
                }
            });
        }
        return null;
    }

    public void modifiedService(ServiceReference<IDictionaryService> reference, IDictionaryService service) {
    }

    public void removedService(ServiceReference<IDictionaryService> reference, IDictionaryService service) {
    }

    protected void setupPackInContext() {
        Properties serverContext = new Properties();
        ServerContext.setCurrentInstance((Properties)serverContext);
    }
}

