/*
 * Decompiled with CFR 0.152.
 */
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.standard.DocumentName;
import javax.swing.JApplet;

public class PrintLabelApplet
extends JApplet {
    private static final long serialVersionUID = -3107445661561669767L;
    private ArrayList<String> filepaths = new ArrayList();
    private int listSize = 0;

    public void init() {
        String s = this.getParameter("size");
        try {
            this.listSize = Integer.parseInt(s);
        }
        catch (Exception e) {
            System.out.println("Invalid listSize param=" + s);
            this.listSize = 0;
        }
        for (int i = 0; i < this.listSize; ++i) {
            this.filepaths.add(this.getParameter("file_" + i));
        }
        super.init();
    }

    public void start() {
        System.out.println(this.getClass().getName() + " start()");
        PrinterJob pjob = null;
        PrintService service = null;
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        try {
            int count = 0;
            do {
                URL url = new URL(this.getCodeBase(), "labeldata.jsp?filepath=" + this.filepaths.get(count) + "&count=" + (count + 1));
                System.out.println("Protocol=" + url.getProtocol());
                System.out.println("Host=" + url.getHost());
                System.out.println("Port=" + url.getPort());
                System.out.println("Default Port=" + url.getDefaultPort());
                System.out.println("Path" + url.getPath());
                System.out.println("URL=" + url.toString());
                URLConnection conn = url.openConnection();
                int contentLength = conn.getContentLength();
                System.out.println("ContentLength=" + contentLength);
                InputStream is = conn.getInputStream();
                System.out.println("InputStream=" + is.available());
                byte[] data = null;
                BufferedInputStream bis = new BufferedInputStream(is);
                System.out.println("BufferedInputStream=" + bis.available());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while (bis.available() > 0) {
                    baos.write(bis.read());
                }
                is.close();
                bis.close();
                data = baos.toByteArray();
                baos.close();
                System.out.println("ByteArrayOutputStream=" + data.length);
                if (data.length <= 0) break;
                ++count;
                if (pjob == null) {
                    pjob = PrinterJob.getPrinterJob();
                    if (!pjob.printDialog()) break;
                    service = pjob.getPrintService();
                }
                DocPrintJob job = service.createPrintJob();
                HashDocAttributeSet as = new HashDocAttributeSet();
                as.add(new DocumentName("shipping label", null));
                SimpleDoc doc = new SimpleDoc(data, flavor, as);
                job.print(doc, null);
            } while (count < this.listSize);
            this.showStatus(count + " label printed.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus("Failed to print label - " + e.getLocalizedMessage());
        }
    }

    public void destroy() {
        System.out.println(this.getClass().getName() + " destroy()");
    }

    public void stop() {
        System.out.println(this.getClass().getName() + " stop()");
    }
}

