/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.compiere.install.util.AppsAction;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public final class ConfirmPanel
extends JPanel {
    private static final long serialVersionUID = 6041019802043360966L;
    public static final String A_OK = "Ok";
    public static final String A_CANCEL = "Cancel";
    public static final String A_REFRESH = "Refresh";
    public static final String A_RESET = "Reset";
    public static final String A_CUSTOMIZE = "Customize";
    public static final String A_HISTORY = "History";
    public static final String A_ZOOM = "Zoom";
    public static final String A_PROCESS = "Process";
    public static final String A_PRINT = "Print";
    public static final String A_EXPORT = "Export";
    public static final String A_HELP = "Help";
    public static final String A_DELETE = "Delete";
    public static final String A_PATTRIBUTE = "PAttribute";
    public static final String A_NEW = "New";
    public static Insets s_insets = new Insets(0, 10, 0, 10);
    private JPanel m_addlButtons = null;
    private JButton bOK;
    private JButton bCancel;
    private JButton bRefresh;
    private JButton bReset;
    private JButton bCustomize;
    private JButton bHistory;
    private JButton bZoom;

    public static final JButton createOKButton(String text) {
        AppsAction aa = new AppsAction(A_OK, KeyStroke.getKeyStroke(115, 0), text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        button.setDefaultCapable(true);
        return button;
    }

    public static final JButton createOKButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createOKButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_OK));
        }
        return ConfirmPanel.createOKButton("");
    }

    public static final JButton createCancelButton(String text) {
        AppsAction aa = new AppsAction(A_CANCEL, KeyStroke.getKeyStroke(27, 0), text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final JButton createCancelButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createCancelButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_CANCEL));
        }
        return ConfirmPanel.createCancelButton("");
    }

    public static final JButton createRefreshButton(String text) {
        AppsAction aa = new AppsAction(A_REFRESH, KeyStroke.getKeyStroke(116, 0), text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final JButton createRefreshButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createRefreshButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_REFRESH));
        }
        return ConfirmPanel.createRefreshButton("");
    }

    public static final JButton createResetButton(String text) {
        AppsAction aa = new AppsAction(A_RESET, null, text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final JButton createResetButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createResetButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_RESET));
        }
        return ConfirmPanel.createResetButton(null);
    }

    public static final JButton createCustomizeButton(String text) {
        AppsAction aa = new AppsAction(A_CUSTOMIZE, null, text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final JButton createCustomizeButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createCustomizeButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_CUSTOMIZE));
        }
        return ConfirmPanel.createCustomizeButton(null);
    }

    public static final JButton createHistoryButton(String text) {
        AppsAction aa = new AppsAction(A_HISTORY, KeyStroke.getKeyStroke(120, 0), text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final JButton createHistoryButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createHistoryButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_HISTORY));
        }
        return ConfirmPanel.createHistoryButton(null);
    }

    public static final JButton createZoomButton(String text) {
        AppsAction aa = new AppsAction(A_ZOOM, null, text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final JButton createZoomButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createZoomButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_ZOOM));
        }
        return ConfirmPanel.createZoomButton(null);
    }

    public static final JButton createProcessButton(String text) {
        AppsAction aa = new AppsAction(A_PROCESS, KeyStroke.getKeyStroke(115, 1), text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final JButton createProcessButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createProcessButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_PROCESS));
        }
        return ConfirmPanel.createProcessButton(null);
    }

    public static final JButton createPrintButton(String text) {
        AppsAction aa = new AppsAction(A_PRINT, KeyStroke.getKeyStroke(123, 0), text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final JButton createPrintButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createPrintButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_PRINT));
        }
        return ConfirmPanel.createPrintButton(null);
    }

    public static final JButton createHelpButton(String text) {
        AppsAction aa = new AppsAction(A_HELP, KeyStroke.getKeyStroke(112, 0), text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final JButton createHelpButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createHelpButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_HELP));
        }
        return ConfirmPanel.createHelpButton(null);
    }

    public static final JButton createExportButton(String text) {
        AppsAction aa = new AppsAction(A_EXPORT, null, text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final JButton createExportButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createExportButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_EXPORT));
        }
        return ConfirmPanel.createExportButton(null);
    }

    public static final JButton createDeleteButton(String text) {
        AppsAction aa = new AppsAction(A_DELETE, KeyStroke.getKeyStroke(114, 0), text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final JButton createDeleteButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createDeleteButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_DELETE));
        }
        return ConfirmPanel.createDeleteButton(null);
    }

    public static final JButton createPAttributeButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createPAttributeButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_PATTRIBUTE));
        }
        return ConfirmPanel.createPAttributeButton(null);
    }

    public static final JButton createPAttributeButton(String text) {
        AppsAction aa = new AppsAction(A_PATTRIBUTE, null, text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final JButton createNewButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createNewButton(Msg.getMsg((Properties)Env.getCtx(), (String)A_NEW));
        }
        return ConfirmPanel.createNewButton(null);
    }

    public static final JButton createNewButton(String text) {
        AppsAction aa = new AppsAction(A_NEW, KeyStroke.getKeyStroke(113, 0), text);
        JButton button = (JButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public ConfirmPanel() {
        this(false, false, false, false, false, false, true);
    }

    public ConfirmPanel(boolean withCancelButton) {
        this(withCancelButton, false, false, false, false, false, true);
    }

    public ConfirmPanel(boolean withCancelButton, boolean withRefreshButton, boolean withResetButton, boolean withCustomizeButton, boolean withHistoryButton, boolean withZoomButton, boolean withText) {
        BorderLayout mainLayout = new BorderLayout();
        this.setLayout(mainLayout);
        this.setName("confirmPanel");
        JPanel okCancel = new JPanel(new FlowLayout(2));
        okCancel.setOpaque(false);
        this.bOK = ConfirmPanel.createOKButton(withText);
        okCancel.add(this.bOK);
        this.bCancel = ConfirmPanel.createCancelButton(withText);
        okCancel.add(this.bCancel);
        this.setCancelVisible(withCancelButton);
        this.add((Component)okCancel, "East");
        if (withRefreshButton) {
            this.bRefresh = ConfirmPanel.createRefreshButton(withText);
            this.addComponent(this.bRefresh);
        }
        if (withResetButton) {
            this.bReset = ConfirmPanel.createResetButton(withText);
            this.addComponent(this.bReset);
        }
        if (withCustomizeButton) {
            this.bCustomize = ConfirmPanel.createCustomizeButton(withText);
            this.addComponent(this.bCustomize);
        }
        if (withHistoryButton) {
            this.bHistory = ConfirmPanel.createHistoryButton(withText);
            this.addComponent(this.bHistory);
        }
        if (withZoomButton) {
            this.bZoom = ConfirmPanel.createZoomButton(withText);
            this.addComponent(this.bZoom);
        }
    }

    public void addComponent(Component button) {
        if (this.m_addlButtons == null) {
            this.m_addlButtons = new JPanel(new FlowLayout(0));
            this.add((Component)this.m_addlButtons, "West");
        }
        this.m_addlButtons.add(button);
    }

    public JButton addButton(String action, String toolTipText, Icon icon) {
        AppsAction aa = new AppsAction(action, null, toolTipText);
        JButton b = (JButton)aa.getButton();
        this.addComponent(b);
        return b;
    }

    public JButton addButton(JButton button) {
        this.addComponent(button);
        return button;
    }

    public JButton getOKButton() {
        return this.bOK;
    }

    public JButton getCancelButton() {
        return this.bCancel;
    }

    public void setOKVisible(boolean value) {
        this.bOK.setVisible(value);
        this.bOK.setEnabled(value);
    }

    public boolean isOKVisible() {
        return this.bOK.isVisible();
    }

    public void setCancelVisible(boolean value) {
        this.bCancel.setVisible(value);
        this.bCancel.setEnabled(value);
    }

    public boolean isCancelVisible() {
        return this.bCancel.isVisible();
    }

    public JButton getResetButton() {
        return this.bReset;
    }

    public JButton getCustomizeButton() {
        return this.bCustomize;
    }

    public JButton getHistoryButton() {
        return this.bHistory;
    }

    public JButton getZoomButton() {
        return this.bZoom;
    }

    public JButton getRefreshButton() {
        return this.bRefresh;
    }

    public void addActionListener(ActionListener al) {
        ((AppsAction)this.bOK.getAction()).setDelegate(al);
        ((AppsAction)this.bCancel.getAction()).setDelegate(al);
        if (this.bRefresh != null) {
            ((AppsAction)this.bRefresh.getAction()).setDelegate(al);
        }
        if (this.bReset != null) {
            ((AppsAction)this.bReset.getAction()).setDelegate(al);
        }
        if (this.bCustomize != null) {
            ((AppsAction)this.bCustomize.getAction()).setDelegate(al);
        }
        if (this.bHistory != null) {
            ((AppsAction)this.bHistory.getAction()).setDelegate(al);
        }
        if (this.bZoom != null) {
            ((AppsAction)this.bZoom.getAction()).setDelegate(al);
        }
        JRootPane rootpane = null;
        if (al instanceof JDialog) {
            rootpane = ((JDialog)((Object)al)).getRootPane();
        } else if (al instanceof JFrame) {
            rootpane = ((JFrame)((Object)al)).getRootPane();
        }
        if (rootpane != null) {
            rootpane.setDefaultButton(this.bOK);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.bOK.setEnabled(enabled);
        this.bCancel.setEnabled(enabled);
        if (this.bRefresh != null) {
            this.bRefresh.setEnabled(enabled);
        }
        if (this.bCustomize != null) {
            this.bCustomize.setEnabled(enabled);
        }
        if (this.bHistory != null) {
            this.bHistory.setEnabled(enabled);
        }
        if (this.bZoom != null) {
            this.bZoom.setEnabled(enabled);
        }
    }
}

