/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaymentBatch;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.ValueNamePair;

public class PayPrint {
    public int m_WindowNo = 0;
    public int m_C_BankAccount_ID = -1;
    public String m_PaymentExportClass = null;
    public int m_C_PaySelection_ID = 0;
    public MPaySelectionCheck[] m_checks = null;
    public MPaymentBatch m_batch = null;
    public static CLogger log = CLogger.getCLogger(PayPrint.class);
    public String bank;
    public String currency;
    public BigDecimal balance;
    public String noPayments;
    public Integer documentNo;

    public ArrayList<KeyNamePair> getPaySelectionData() {
        ArrayList<KeyNamePair> data;
        block6: {
            data = new ArrayList<KeyNamePair>();
            log.config("");
            int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
            String sql = "SELECT C_PaySelection_ID, Name || ' - ' || TotalAmt FROM C_PaySelection WHERE AD_Client_ID=? AND Processed='Y' AND IsActive='Y'ORDER BY PayDate DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        data.add(pp);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public void loadPaySelectInfo(int C_PaySelection_ID) {
        block7: {
            this.m_C_BankAccount_ID = -1;
            String sql = "SELECT ps.C_BankAccount_ID, b.Name || ' ' || ba.AccountNo, c.ISO_Code, CurrentBalance, ba.PaymentExportClass FROM C_PaySelection ps INNER JOIN C_BankAccount ba ON (ps.C_BankAccount_ID=ba.C_BankAccount_ID) INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) INNER JOIN C_Currency c ON (ba.C_Currency_ID=c.C_Currency_ID) WHERE ps.C_PaySelection_ID=? AND ps.Processed='Y' AND ba.IsActive='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_PaySelection_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_C_BankAccount_ID = rs.getInt(1);
                        this.bank = rs.getString(2);
                        this.currency = rs.getString(3);
                        this.balance = rs.getBigDecimal(4);
                        this.m_PaymentExportClass = rs.getString(5);
                    } else {
                        this.m_C_BankAccount_ID = -1;
                        this.bank = "";
                        this.currency = "";
                        this.balance = Env.ZERO;
                        this.m_PaymentExportClass = null;
                        log.log(Level.SEVERE, "No active BankAccount for C_PaySelection_ID=" + C_PaySelection_ID);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public ArrayList<ValueNamePair> loadPaymentRule(int C_PaySelection_ID) {
        String sql;
        ArrayList<ValueNamePair> data;
        block7: {
            data = new ArrayList<ValueNamePair>();
            int AD_Reference_ID = 195;
            Language language = Language.getLanguage((String)Env.getAD_Language((Properties)Env.getCtx()));
            MLookupInfo info = MLookupFactory.getLookup_List((Language)language, (int)AD_Reference_ID);
            sql = String.valueOf(info.Query.substring(0, info.Query.indexOf(" ORDER BY"))) + " AND " + info.KeyColumn + " IN (SELECT PaymentRule FROM C_PaySelectionCheck WHERE C_PaySelection_ID=?) " + info.Query.substring(info.Query.indexOf(" ORDER BY"));
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_PaySelection_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ValueNamePair pp = new ValueNamePair(rs.getString(2), rs.getString(3));
                        data.add(pp);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (data.size() == 0 && log.isLoggable(Level.CONFIG)) {
            log.config("PaySel=" + C_PaySelection_ID + ", BAcct=" + this.m_C_BankAccount_ID + " - " + sql);
        }
        return data;
    }

    public String loadPaymentRuleInfo(int C_PaySelection_ID, String PaymentRule) {
        String msg;
        block13: {
            ResultSet rs;
            CPreparedStatement pstmt;
            String sql;
            block12: {
                msg = null;
                sql = "SELECT COUNT(*) FROM C_PaySelectionCheck WHERE C_PaySelection_ID=?";
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        pstmt.setInt(1, C_PaySelection_ID);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.noPayments = String.valueOf(rs.getInt(1));
                        }
                    }
                    catch (SQLException e) {
                        log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            sql = "SELECT CurrentNext FROM C_BankAccountDoc WHERE C_BankAccount_ID=? AND PaymentRule=? AND IsActive='Y'";
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_C_BankAccount_ID);
                    pstmt.setString(2, PaymentRule);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.documentNo = new Integer(rs.getInt(1));
                        break block13;
                    }
                    log.log(Level.SEVERE, "VPayPrint.loadPaymentRuleInfo - No active BankAccountDoc for C_BankAccount_ID=" + this.m_C_BankAccount_ID + " AND PaymentRule=" + PaymentRule);
                    msg = "VPayPrintNoDoc";
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            finally {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        return msg;
    }
}

