/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.io.File;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PackoutDocument;
import org.adempiere.pipo2.PackoutItem;
import org.adempiere.pipo2.handler.DistFileElementHandler;
import org.compiere.util.CLogger;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FileElementHandler
implements ElementHandler {
    private CLogger log = CLogger.getCLogger(FileElementHandler.class);

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        PackoutDocument header = packout.getPackoutDocument();
        PackoutItem detail = packout.getCurrentPackoutItem();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.log(Level.INFO, "In PackOut.java handling Code or Other 2pack module creation");
        }
        String fileDirectory = String.valueOf(packout.getPackoutDirectory()) + header.getPackageName() + detail.getProperty("TargetDirectory");
        if (this.log.isLoggable(Level.INFO)) {
            this.log.log(Level.INFO, "targetDirectory" + fileDirectory);
        }
        String targetDirectory = null;
        char fileseperator1 = '/';
        char fileseperator2 = '\\';
        targetDirectory = File.separator.equals("/") ? fileDirectory.replace(fileseperator2, fileseperator1) : fileDirectory.replace(fileseperator1, fileseperator2);
        String sourceDirectory = null;
        fileDirectory = (String)detail.getProperty("SourceDirectory");
        sourceDirectory = File.separator.equals("/") ? fileDirectory.replace(fileseperator2, fileseperator1) : fileDirectory.replace(fileseperator2, fileseperator1);
        packout.copyFile(String.valueOf(sourceDirectory) + detail.getProperty("FileName"), String.valueOf(targetDirectory) + detail.getProperty("FileName"));
        AttributesImpl atts = new AttributesImpl();
        if (detail.getProperty("DestinationDirectory") != null) {
            fileDirectory = (String)detail.getProperty("DestinationDirectory");
            String destinationDirectory = null;
            destinationDirectory = File.separator.equals("/") ? fileDirectory.replace(fileseperator2, fileseperator1) : fileDirectory.replace(fileseperator2, fileseperator1);
            try {
                new DistFileElementHandler(destinationDirectory).doPackout(packout, null, detail, packoutHandler, null, null, 0);
            }
            catch (Exception e) {
                throw new AdempiereException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (detail.getProperty("FileName") != null) {
            PackOut.addTextElement((TransformerHandler)docHandler, (String)"file", (String)("File: " + detail.getProperty("FileName")), (AttributesImpl)atts);
        }
        PackOut.addTextElement((TransformerHandler)docHandler, (String)"filedirectory", (String)("Directory: " + detail.getProperty("TargetDirectory")), (AttributesImpl)atts);
        PackOut.addTextElement((TransformerHandler)docHandler, (String)"filenotes", (String)("Notes: " + detail.getProperty("Description")), (AttributesImpl)atts);
    }

    public void startElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }
}

