/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.DBException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.ReferenceUtils;
import org.adempiere.pipo2.handler.CommonTranslationHandler;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Menu;
import org.compiere.model.X_AD_Package_Imp_Backup;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MenuElementHandler
extends AbstractElementHandler {
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        X_AD_Package_Imp_Detail impDetail;
        X_AD_Menu mMenu;
        block20: {
            PoFiller filler;
            List notFounds;
            List excludes = this.defaultExcludeList("AD_Menu");
            mMenu = (X_AD_Menu)this.findPO(ctx, element);
            if (mMenu == null) {
                mMenu = new X_AD_Menu(ctx.ctx, 0, this.getTrxName(ctx));
            }
            if ((notFounds = (filler = new PoFiller(ctx, (PO)mMenu, element, (AbstractElementHandler)this)).autoFill(excludes)).size() > 0) {
                element.defer = true;
                element.unresolved = notFounds.toString();
                return;
            }
            element.recordId = mMenu.get_ID();
            if (!mMenu.is_new() && !mMenu.is_Changed()) {
                return;
            }
            impDetail = this.createImportDetail(ctx, element.qName, "AD_Menu", 116);
            String action = null;
            if (!mMenu.is_new()) {
                this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Menu", (PO)mMenu);
                action = "Update";
            } else {
                action = "New";
            }
            if (mMenu.save(this.getTrxName(ctx))) {
                try {
                    this.logImportDetail(ctx, impDetail, 1, mMenu.getName(), mMenu.get_ID(), action);
                    element.recordId = mMenu.get_ID();
                }
                catch (SAXException e) {
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("setmenu:" + e);
                    }
                    break block20;
                }
            }
            try {
                this.logImportDetail(ctx, impDetail, 0, mMenu.getName(), mMenu.get_ID(), action);
            }
            catch (SAXException e) {
                if (!this.log.isLoggable(Level.INFO)) break block20;
                this.log.info("setmenu:" + e);
            }
        }
        Element parentElement = (Element)element.properties.get("Parent_ID");
        int parentId = 0;
        if (parentElement != null) {
            parentId = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)parentElement, (String)this.getTrxName(ctx));
        }
        StringBuffer updateSQL = null;
        int AD_Tree_ID = this.getDefaultMenuTreeId();
        String sql = "SELECT count(Parent_ID) FROM AD_TREENODEMM WHERE AD_Tree_ID = " + AD_Tree_ID + " AND Node_ID = " + mMenu.getAD_Menu_ID();
        int countRecords = DB.getSQLValue((String)this.getTrxName(ctx), (String)sql);
        if (countRecords > 0) {
            sql = "select * from AD_TREENODEMM where AD_Tree_ID = " + AD_Tree_ID + " and " + " Node_ID =?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                    pstmt.setInt(1, mMenu.getAD_Menu_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String colValue = null;
                        ResultSetMetaData meta = rs.getMetaData();
                        int columns = meta.getColumnCount();
                        int tableID = 452;
                        int q = 1;
                        while (q <= columns) {
                            Object obj;
                            String colName = meta.getColumnName(q).toUpperCase();
                            sql = "SELECT AD_Column_ID FROM AD_column WHERE Upper(ColumnName) = ? AND AD_Table_ID = ?";
                            int columnID = DB.getSQLValue((String)this.getTrxName(ctx), (String)sql, (Object[])new Object[]{colName, tableID});
                            sql = "SELECT AD_Reference_ID FROM AD_COLUMN WHERE AD_Column_ID = ?";
                            int referenceID = DB.getSQLValue((String)this.getTrxName(ctx), (String)sql, (int)columnID);
                            colValue = referenceID == 20 || referenceID == 28 ? (rs.getObject(q).equals("Y") ? "true" : "false") : ((obj = rs.getObject(q)) == null ? "" : obj.toString());
                            X_AD_Package_Imp_Backup backup = new X_AD_Package_Imp_Backup(ctx.ctx, 0, this.getTrxName(ctx));
                            backup.setAD_Package_Imp_Detail_ID(impDetail.getAD_Package_Imp_Detail_ID());
                            backup.setAD_Package_Imp_ID(this.getPackageImpId(ctx.ctx));
                            backup.setAD_Table_ID(tableID);
                            backup.setAD_Column_ID(columnID);
                            backup.setAD_Reference_ID(referenceID);
                            backup.setColValue(colValue);
                            backup.saveEx();
                            ++q;
                        }
                    }
                }
                catch (Exception e) {
                    throw new DBException(e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            updateSQL = new StringBuffer("UPDATE AD_TREENODEMM ").append("SET Parent_ID = " + parentId).append(" , SeqNo = " + this.getStringValue(element, "SeqNo")).append(" WHERE AD_Tree_ID = " + AD_Tree_ID).append(" AND Node_ID = " + mMenu.getAD_Menu_ID());
        } else {
            updateSQL = new StringBuffer("INSERT INTO AD_TREENODEMM").append("(AD_Client_ID, AD_Org_ID, CreatedBy, UpdatedBy, ").append("Parent_ID, SeqNo, AD_Tree_ID, Node_ID)").append("VALUES(0, 0, 0, 0, ").append(String.valueOf(parentId) + "," + this.getStringValue(element, "SeqNo") + ", " + AD_Tree_ID + ", " + mMenu.getAD_Menu_ID() + ")");
        }
        DB.executeUpdate((String)updateSQL.toString(), (String)this.getTrxName(ctx));
    }

    private int getDefaultMenuTreeId() {
        return DB.getSQLValue(null, (String)"SELECT AD_Tree_ID FROM AD_Tree WHERE TreeType='MM' AND AD_Client_ID=0 ORDER BY IsDefault DESC, AD_Tree_ID");
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_Menu_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Menu_ID");
        if (ctx.packOut.isExported("AD_Menu_ID|" + AD_Menu_ID)) {
            return;
        }
        X_AD_Menu m_Menu = new X_AD_Menu(ctx.ctx, AD_Menu_ID, null);
        if (!m_Menu.isSummary()) {
            this.createApplication(ctx, document, AD_Menu_ID);
        } else {
            block5: {
                this.verifyPackOutRequirement((PO)m_Menu);
                AttributesImpl atts = new AttributesImpl();
                this.addTypeName(atts, "table");
                document.startElement("", "", "AD_Menu", atts);
                this.createMenuBinding(ctx, document, m_Menu);
                PackOut packOut = ctx.packOut;
                packOut.getCtx().ctx.put("Table_Name", "AD_Menu");
                try {
                    new CommonTranslationHandler().packOut(packOut, document, null, m_Menu.get_ID());
                }
                catch (Exception e) {
                    if (!this.log.isLoggable(Level.INFO)) break block5;
                    this.log.info(e.toString());
                }
            }
            this.createModule(ctx, document, AD_Menu_ID);
            document.endElement("", "", "AD_Menu");
        }
    }

    private void createMenuBinding(PIPOContext ctx, TransformerHandler document, X_AD_Menu m_Menu) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Menu);
        List excludes = this.defaultExcludeList("AD_Menu");
        int AD_Tree_ID = this.getDefaultMenuTreeId();
        String sql = "SELECT Parent_ID FROM AD_TreeNoDemm WHERE AD_Tree_ID = " + AD_Tree_ID + " and Node_ID=?";
        int id = DB.getSQLValue(null, (String)sql, (int)m_Menu.getAD_Menu_ID());
        if (id > 0) {
            filler.addTableReference("Parent_ID", "AD_Menu", id, new AttributesImpl());
        }
        sql = "SELECT SeqNo FROM AD_TreeNoDemm WHERE AD_Tree_ID = " + AD_Tree_ID + " and Node_ID=?";
        int seqNo = DB.getSQLValue(null, (String)sql, (int)m_Menu.getAD_Menu_ID());
        filler.addString("SeqNo", Integer.toString(seqNo), new AttributesImpl());
        if (m_Menu.getAD_Menu_ID() <= 999999) {
            filler.addString("AD_Menu_ID", Integer.toString(m_Menu.getAD_Menu_ID()), new AttributesImpl());
        }
        filler.export(excludes);
    }

    private void createApplication(PIPOContext ctx, TransformerHandler document, int AD_Menu_ID) throws SAXException {
        PackOut packOut = ctx.packOut;
        String sql = null;
        int AD_Tree_ID = this.getDefaultMenuTreeId();
        sql = "SELECT A.Node_ID, B.AD_Menu_ID, B.Name, B.AD_WINDOW_ID, B.AD_WORKFLOW_ID, B.AD_TASK_ID, B.AD_PROCESS_ID, B.AD_FORM_ID, B.AD_WORKBENCH_ID FROM AD_TreeNodeMM A, AD_Menu B WHERE A.Node_ID = " + AD_Menu_ID + " AND A.Node_ID = B.AD_Menu_ID" + " AND A.AD_Tree_ID=" + AD_Tree_ID;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    block18: {
                        X_AD_Menu m_Menu = new X_AD_Menu(ctx.ctx, rs.getInt("AD_Menu_ID"), null);
                        this.verifyPackOutRequirement((PO)m_Menu);
                        AttributesImpl atts = new AttributesImpl();
                        this.addTypeName(atts, "table");
                        document.startElement("", "", "AD_Menu", atts);
                        this.createMenuBinding(ctx, document, m_Menu);
                        packOut.getCtx().ctx.put("Table_Name", "AD_Menu");
                        try {
                            new CommonTranslationHandler().packOut(packOut, document, null, m_Menu.get_ID());
                        }
                        catch (Exception e) {
                            if (!this.log.isLoggable(Level.INFO)) break block18;
                            this.log.info(e.toString());
                        }
                    }
                    if (rs.getInt("AD_WINDOW_ID") > 0 || rs.getInt("AD_WORKFLOW_ID") > 0 || rs.getInt("AD_TASK_ID") > 0 || rs.getInt("AD_PROCESS_ID") > 0 || rs.getInt("AD_FORM_ID") > 0) {
                        ElementHandler handler;
                        if (rs.getInt("AD_Window_ID") > 0) {
                            handler = packOut.getHandler("AD_Window");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Window_ID"));
                        } else if (rs.getInt("AD_Process_ID") > 0) {
                            handler = packOut.getHandler("AD_Process");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Process_ID"));
                        } else if (rs.getInt("AD_Task_ID") > 0) {
                            handler = packOut.getHandler("AD_Task");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Task_ID"));
                        } else if (rs.getInt("AD_Form_ID") > 0) {
                            handler = packOut.getHandler("AD_Form");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Form_ID"));
                        } else if (rs.getInt("AD_Workflow_ID") > 0) {
                            handler = packOut.getHandler("AD_Workflow");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Workflow_ID"));
                        }
                    } else {
                        this.createModule(ctx, document, rs.getInt("Node_ID"));
                    }
                    document.endElement("", "", "AD_Menu");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getWindows", (Throwable)e);
                throw new DBException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
    }

    public void createModule(PIPOContext ctx, TransformerHandler document, int menu_id) throws SAXException {
        PackOut packOut = ctx.packOut;
        String sql = null;
        int AD_Tree_ID = this.getDefaultMenuTreeId();
        sql = "SELECT A.Node_ID, B.AD_Menu_ID, B.Name, B.AD_WINDOW_ID, B.AD_WORKFLOW_ID, B.AD_TASK_ID, B.AD_PROCESS_ID, B.AD_FORM_ID, B.AD_WORKBENCH_ID FROM AD_TreeNodeMM A, AD_Menu B WHERE A.Parent_ID = " + menu_id + " AND A.Node_ID = B.AD_Menu_ID" + " AND A.AD_Tree_ID=" + AD_Tree_ID;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_AD_Menu m_Menu = new X_AD_Menu(ctx.ctx, rs.getInt("AD_Menu_ID"), null);
                    this.verifyPackOutRequirement((PO)m_Menu);
                    AttributesImpl atts = new AttributesImpl();
                    this.addTypeName(atts, "table");
                    document.startElement("", "", "AD_Menu", atts);
                    this.createMenuBinding(ctx, document, m_Menu);
                    if (rs.getInt("AD_WINDOW_ID") > 0 || rs.getInt("AD_WORKFLOW_ID") > 0 || rs.getInt("AD_TASK_ID") > 0 || rs.getInt("AD_PROCESS_ID") > 0 || rs.getInt("AD_FORM_ID") > 0) {
                        ElementHandler handler;
                        if (rs.getInt("AD_Window_ID") > 0) {
                            handler = packOut.getHandler("AD_Window");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Window_ID"));
                        } else if (rs.getInt("AD_Process_ID") > 0) {
                            handler = packOut.getHandler("AD_Process");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Process_ID"));
                        } else if (rs.getInt("AD_Task_ID") > 0) {
                            handler = packOut.getHandler("AD_Task");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Task_ID"));
                        } else if (rs.getInt("AD_Form_ID") > 0) {
                            handler = packOut.getHandler("AD_Form");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Form_ID"));
                        } else if (rs.getInt("AD_Workflow_ID") > 0) {
                            handler = packOut.getHandler("AD_Workflow");
                            handler.packOut(packOut, document, null, rs.getInt("AD_Workflow_ID"));
                        }
                    } else {
                        this.createModule(ctx, document, rs.getInt("Node_ID"));
                    }
                    document.endElement("", "", "AD_Menu");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getWindows", (Throwable)e);
                throw new DBException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Menu_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Menu_ID");
    }
}

