/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class BOMFlagValidate
extends SvrProcess {
    private int p_M_Product_Category_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_Category_ID")) {
                    this.p_M_Product_Category_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        this.flagNonBOMs();
        this.flagBOMs();
        return "@OK@";
    }

    private void flagNonBOMs() throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT Name, M_Product_ID FROM M_Product WHERE IsBOM = 'Y' AND ").append("M_Product_ID NOT IN (SELECT M_Product_ID FROM M_Product_BOM ) AND ");
        if (this.p_M_Product_Category_ID == 0) {
            sql.append("AD_Client_ID= ?");
        } else {
            sql.append("M_Product_Category_ID= ?");
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            if (this.p_M_Product_Category_ID == 0) {
                pstmt.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
            } else {
                pstmt.setInt(1, this.p_M_Product_Category_ID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                StringBuilder msglog = new StringBuilder().append(rs.getString(1)).append(" BOM without BOM lines");
                this.addLog(0, null, null, msglog.toString(), 208, rs.getInt(2));
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        CPreparedStatement upstmt = null;
        try {
            StringBuilder update = new StringBuilder("UPDATE M_Product SET IsBOM = 'N' WHERE IsBOM = 'Y' AND M_Product_ID NOT IN ").append("(SELECT M_Product_ID FROM M_Product_BOM ) AND ");
            if (this.p_M_Product_Category_ID == 0) {
                update.append("AD_Client_ID= ?");
            } else {
                update.append("M_Product_Category_ID= ?");
            }
            upstmt = DB.prepareStatement((String)update.toString(), (String)this.get_TrxName());
            if (this.p_M_Product_Category_ID == 0) {
                upstmt.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
            } else {
                upstmt.setInt(1, this.p_M_Product_Category_ID);
            }
            upstmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DB.close(upstmt);
            upstmt = null;
            throw throwable;
        }
        DB.close((Statement)upstmt);
        upstmt = null;
    }

    private void flagBOMs() throws Exception {
        StringBuilder sql = new StringBuilder("SELECT Name, M_Product_ID FROM M_Product WHERE IsBOM = 'N' AND ").append("M_Product_ID IN (SELECT M_Product_ID FROM M_Product_BOM ) AND ");
        if (this.p_M_Product_Category_ID == 0) {
            sql.append("AD_Client_ID= ?");
        } else {
            sql.append("M_Product_Category_ID= ?");
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            if (this.p_M_Product_Category_ID == 0) {
                pstmt.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
            } else {
                pstmt.setInt(1, this.p_M_Product_Category_ID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                StringBuilder msglog = new StringBuilder().append(rs.getString(1)).append(" not BOM with BOM lines");
                this.addLog(0, null, null, msglog.toString(), 208, rs.getInt(2));
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        StringBuilder update = new StringBuilder("UPDATE M_Product SET ISBOM = 'Y' WHERE IsBOM = 'N' AND M_Product_ID IN ").append("(SELECT M_Product_ID FROM M_Product_BOM ) AND ");
        if (this.p_M_Product_Category_ID == 0) {
            update.append("AD_Client_ID= ?");
        } else {
            update.append("M_Product_Category_ID= ?");
        }
        CPreparedStatement upstmt = null;
        try {
            upstmt = DB.prepareStatement((String)update.toString(), (String)this.get_TrxName());
            if (this.p_M_Product_Category_ID == 0) {
                upstmt.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
            } else {
                upstmt.setInt(1, this.p_M_Product_Category_ID);
            }
            upstmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DB.close(upstmt);
            upstmt = null;
            throw throwable;
        }
        DB.close((Statement)upstmt);
        upstmt = null;
    }
}

