/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.model.MProductBOM;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class BOMVerify
extends SvrProcess {
    private int p_M_Product_ID = 0;
    private int p_M_Product_Category_ID = 0;
    private boolean p_IsReValidate = false;
    private boolean p_fromButton = false;
    private ArrayList<MProduct> foundproducts = new ArrayList();
    private ArrayList<MProduct> validproducts = new ArrayList();
    private ArrayList<MProduct> invalidproducts = new ArrayList();
    private ArrayList<MProduct> containinvalidproducts = new ArrayList();
    private ArrayList<MProduct> checkedproducts = new ArrayList();

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_ID")) {
                    this.p_M_Product_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Product_Category_ID")) {
                    this.p_M_Product_Category_ID = para[i].getParameterAsInt();
                } else if (name.equals("IsReValidate")) {
                    this.p_IsReValidate = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (this.p_M_Product_ID == 0) {
            this.p_M_Product_ID = this.getRecord_ID();
        }
        this.p_fromButton = this.getRecord_ID() > 0;
    }

    protected String doIt() throws Exception {
        if (this.p_M_Product_ID != 0) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("M_Product_ID=" + this.p_M_Product_ID);
            }
            this.checkProduct(new MProduct(this.getCtx(), this.p_M_Product_ID, this.get_TrxName()));
            return "Product Checked";
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("M_Product_Category_ID=" + this.p_M_Product_Category_ID + ", IsReValidate=" + this.p_IsReValidate);
        }
        int counter = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT M_Product_ID FROM M_Product WHERE IsBOM='Y' AND ";
        sql = this.p_M_Product_Category_ID == 0 ? String.valueOf(sql) + "AD_Client_ID=? " : String.valueOf(sql) + "M_Product_Category_ID=? ";
        if (!this.p_IsReValidate) {
            sql = String.valueOf(sql) + "AND IsVerified<>'Y' ";
        }
        sql = String.valueOf(sql) + "ORDER BY Name";
        int AD_Client_ID = Env.getAD_Client_ID((Properties)this.getCtx());
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            if (this.p_M_Product_Category_ID == 0) {
                pstmt.setInt(1, AD_Client_ID);
            } else {
                pstmt.setInt(1, this.p_M_Product_Category_ID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.p_M_Product_ID = rs.getInt(1);
                this.checkProduct(new MProduct(this.getCtx(), this.p_M_Product_ID, this.get_TrxName()));
                ++counter;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "#" + counter;
    }

    private void checkProduct(MProduct product) {
        if (product.isBOM() && !this.checkedproducts.contains(product)) {
            this.validateProduct(product);
        }
    }

    private boolean validateProduct(MProduct product) {
        if (!product.isBOM()) {
            return false;
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(product.getName());
        }
        this.foundproducts.add(product);
        MProductBOM[] productsBOMs = MProductBOM.getBOMLines((MProduct)product);
        boolean containsinvalid = false;
        boolean invalid = false;
        int lines = 0;
        MProductBOM[] mProductBOMArray = productsBOMs;
        int n = productsBOMs.length;
        int n2 = 0;
        while (n2 < n) {
            MProductBOM productsBOM = mProductBOMArray[n2];
            if (productsBOM.isActive()) {
                ++lines;
                MProduct pp = new MProduct(this.getCtx(), productsBOM.getM_ProductBOM_ID(), this.get_TrxName());
                if (!pp.isBOM()) {
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer(pp.getName());
                    }
                } else {
                    this.validproducts.contains(pp);
                    if (this.invalidproducts.contains(pp)) {
                        containsinvalid = true;
                    } else if (this.foundproducts.contains(pp)) {
                        invalid = true;
                        if (this.p_fromButton) {
                            this.addLog(0, null, null, String.valueOf(product.getValue()) + " recursively contains " + pp.getValue());
                        } else {
                            this.addLog(0, null, null, String.valueOf(product.getValue()) + " recursively contains " + pp.getValue(), 208, product.getM_Product_ID());
                        }
                    } else if (!this.validateProduct(pp)) {
                        containsinvalid = true;
                    }
                }
            }
            ++n2;
        }
        if (lines == 0) {
            invalid = true;
            if (this.p_fromButton) {
                this.addLog(0, null, null, String.valueOf(product.getValue()) + " does not have lines");
            } else {
                this.addLog(0, null, null, String.valueOf(product.getValue()) + " does not have lines", 208, product.getM_Product_ID());
            }
        }
        this.checkedproducts.add(product);
        this.foundproducts.remove(product);
        if (invalid) {
            this.invalidproducts.add(product);
            product.setIsVerified(false);
            product.saveEx();
            return false;
        }
        if (containsinvalid) {
            this.containinvalidproducts.add(product);
            product.setIsVerified(false);
            product.saveEx();
            return false;
        }
        this.validproducts.add(product);
        product.setIsVerified(true);
        product.saveEx();
        return true;
    }
}

