/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import org.compiere.model.DatabaseKey;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.CreateForeignKey;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.ValueNamePair;

public class ColumnSync
extends SvrProcess {
    private int p_AD_Column_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_AD_Column_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        String string;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_Column_ID=" + this.p_AD_Column_ID);
        }
        if (this.p_AD_Column_ID == 0) {
            throw new AdempiereUserError("@No@ @AD_Column_ID@");
        }
        MColumn column = new MColumn(this.getCtx(), this.p_AD_Column_ID, this.get_TrxName());
        if (column.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @AD_Column_ID@ " + this.p_AD_Column_ID);
        }
        MTable table = new MTable(this.getCtx(), column.getAD_Table_ID(), this.get_TrxName());
        if (table.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @AD_Table_ID@ " + column.getAD_Table_ID());
        }
        Connection conn = null;
        ResultSet rs = null;
        try {
            boolean isNoTable;
            conn = DB.getConnectionRO();
            DatabaseMetaData md = conn.getMetaData();
            String catalog = DB.getDatabase().getCatalog();
            String schema = DB.getDatabase().getSchema();
            String tableName = table.getTableName();
            if (md.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            } else if (md.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            }
            int noColumns = 0;
            String sql = null;
            rs = md.getColumns(catalog, schema, tableName, null);
            while (rs.next()) {
                ++noColumns;
                String columnName = rs.getString("COLUMN_NAME");
                if (!columnName.equalsIgnoreCase(column.getColumnName())) continue;
                boolean notNull = rs.getInt("NULLABLE") == 0;
                sql = column.getSQLModify(table, column.isMandatory() ^ notNull);
                break;
            }
            DB.close((ResultSet)rs);
            rs = null;
            boolean bl = isNoTable = noColumns == 0;
            if (isNoTable) {
                sql = table.getSQLCreate();
            } else if (sql == null) {
                sql = column.getSQLAdd(table);
            }
            if (isNoTable) {
                MColumn[] cols;
                MColumn[] mColumnArray = cols = table.getColumns(false);
                int n = cols.length;
                int n2 = 0;
                while (n2 < n) {
                    MColumn col = mColumnArray[n2];
                    String fkConstraintSql = this.getForeignKeyConstraintSql(md, catalog, schema, tableName, table, col);
                    if (fkConstraintSql != null && fkConstraintSql.length() > 0) {
                        sql = String.valueOf(sql) + fkConstraintSql;
                    }
                    ++n2;
                }
            } else {
                String fkConstraintSql = this.getForeignKeyConstraintSql(md, catalog, schema, tableName, table, column);
                if (fkConstraintSql != null && fkConstraintSql.length() > 0) {
                    sql = String.valueOf(sql) + fkConstraintSql;
                }
            }
            int no = 0;
            if (sql.indexOf("; ") == -1) {
                no = DB.executeUpdate((String)sql, (boolean)false, (String)this.get_TrxName());
                this.addLog(0, null, new BigDecimal(no), sql);
            } else {
                String[] statements = sql.split("; ");
                int i = 0;
                while (i < statements.length) {
                    int count = DB.executeUpdateEx((String)statements[i], (String)this.get_TrxName());
                    this.addLog(0, null, new BigDecimal(count), statements[i]);
                    no += count;
                    ++i;
                }
            }
            if (no == -1) {
                StringBuilder msg = new StringBuilder("@Error@ ");
                ValueNamePair pp = CLogger.retrieveError();
                if (pp != null) {
                    msg = new StringBuilder(pp.getName()).append(" - ");
                }
                msg.append(sql);
                throw new AdempiereUserError(msg.toString());
            }
            string = sql;
        }
        catch (Throwable throwable) {
            DB.close(rs);
            rs = null;
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        DB.close((ResultSet)rs);
        rs = null;
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private String getForeignKeyConstraintSql(DatabaseMetaData md, String catalog, String schema, String tableName, MTable table, MColumn column) throws Exception {
        String referenceTableName;
        int refid;
        StringBuilder fkConstraintSql = new StringBuilder();
        if (!column.isKey() && !column.getColumnName().equals(PO.getUUIDColumnName((String)table.getTableName())) && (refid = column.getAD_Reference_ID()) != 17 && refid != 200012 && (referenceTableName = column.getReferenceTableName()) != null) {
            String fkConstraint;
            Hashtable<String, DatabaseKey> htForeignKeys = new Hashtable<String, DatabaseKey>();
            if (md.storesUpperCaseIdentifiers()) {
                referenceTableName = referenceTableName.toUpperCase();
            } else if (md.storesLowerCaseIdentifiers()) {
                referenceTableName = referenceTableName.toLowerCase();
            }
            ResultSet rs = md.getCrossReference(catalog, schema, referenceTableName, catalog, schema, tableName);
            while (rs.next()) {
                String dbFKName = rs.getString("FK_NAME");
                if (dbFKName == null) continue;
                String dbFKTable = rs.getString("FKTABLE_NAME");
                short deleteRule = rs.getShort("DELETE_RULE");
                String key = dbFKName.toLowerCase();
                DatabaseKey dbForeignKey = (DatabaseKey)htForeignKeys.get(key);
                if (dbForeignKey == null) {
                    dbForeignKey = new DatabaseKey(dbFKName, dbFKTable, new String[30], deleteRule);
                }
                String columnName = rs.getString("FKCOLUMN_NAME");
                short pos = rs.getShort("KEY_SEQ");
                if (pos > 0) {
                    dbForeignKey.getKeyColumns()[pos - 1] = columnName;
                }
                htForeignKeys.put(key, dbForeignKey);
            }
            rs.close();
            Enumeration en = htForeignKeys.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                DatabaseKey dbForeignKey = (DatabaseKey)htForeignKeys.get(key);
                if (dbForeignKey.getKeyColumns()[1] == null) continue;
                htForeignKeys.remove(key);
            }
            boolean modified = false;
            en = htForeignKeys.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                DatabaseKey dbForeignKey = (DatabaseKey)htForeignKeys.get(key);
                if (!dbForeignKey.getKeyColumns()[0].equalsIgnoreCase(column.getColumnName())) continue;
                DatabaseKey primaryKey = CreateForeignKey.getPrimaryKey((DatabaseMetaData)md, (String)referenceTableName);
                if (primaryKey != null) {
                    fkConstraintSql.append("; ");
                    fkConstraintSql.append("ALTER TABLE ").append(table.getTableName());
                    fkConstraintSql.append(" DROP CONSTRAINT ").append(dbForeignKey.getKeyName());
                    String dbDeleteRule = "N";
                    if (dbForeignKey.getDeleteRule() == 0) {
                        dbDeleteRule = "C";
                    } else if (dbForeignKey.getDeleteRule() == 2) {
                        dbDeleteRule = "S";
                    }
                    String fkConstraintType = column.getFKConstraintType();
                    if (fkConstraintType == null) {
                        fkConstraintType = dbDeleteRule;
                    }
                    if (fkConstraintType == null) {
                        fkConstraintType = "N";
                    }
                    if (!fkConstraintType.equals("D")) {
                        String fkConstraintName = column.getFKConstraintName();
                        if (fkConstraintName == null || fkConstraintName.trim().length() == 0) {
                            fkConstraintName = dbForeignKey.getKeyName();
                        }
                        StringBuilder fkConstraint2 = new StringBuilder();
                        fkConstraint2.append("CONSTRAINT ").append(fkConstraintName);
                        fkConstraint2.append(" FOREIGN KEY (").append(column.getColumnName()).append(") REFERENCES ");
                        fkConstraint2.append(primaryKey.getKeyTable()).append("(").append(primaryKey.getKeyColumns()[0]);
                        int i = 1;
                        while (i < primaryKey.getKeyColumns().length) {
                            if (primaryKey.getKeyColumns()[i] == null) break;
                            fkConstraint2.append(", ").append(primaryKey.getKeyColumns()[i]);
                            ++i;
                        }
                        fkConstraint2.append(")");
                        if (!fkConstraintType.equals("N")) {
                            if (fkConstraintType.equals("C")) {
                                fkConstraint2.append(" ON DELETE CASCADE");
                            } else if (fkConstraintType.equals("S")) {
                                fkConstraint2.append(" ON DELETE SET NULL");
                            }
                        }
                        fkConstraintSql.append("; ");
                        fkConstraintSql.append("ALTER TABLE ").append(table.getTableName());
                        fkConstraintSql.append(" ADD ");
                        fkConstraintSql.append((CharSequence)fkConstraint2);
                        column.setFKConstraintName(fkConstraintName);
                        column.setFKConstraintType(fkConstraintType);
                        column.saveEx();
                    }
                }
                modified = true;
                break;
            }
            if (!modified && (fkConstraint = CreateForeignKey.getForeignKeyConstraint((DatabaseMetaData)md, (MTable)table, (MColumn)column)) != null && fkConstraint.length() > 0) {
                fkConstraintSql.append("; ");
                fkConstraintSql.append("ALTER TABLE ").append(table.getTableName());
                fkConstraintSql.append(" ADD ");
                fkConstraintSql.append(fkConstraint);
            }
        }
        return fkConstraintSql.toString();
    }
}

