/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.model.MSequence;
import org.compiere.process.ProcessInfo;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class SequenceCheck
extends SvrProcess {
    private static CLogger s_log = CLogger.getCLogger(SequenceCheck.class);

    protected void prepare() {
    }

    protected String doIt() throws Exception {
        this.log.info("");
        SequenceCheck.checkTableSequences(Env.getCtx(), this);
        SequenceCheck.checkTableID(Env.getCtx(), this);
        SequenceCheck.checkClientSequences(Env.getCtx(), this);
        return "Sequence Check";
    }

    public static void validate(Properties ctx) {
        try {
            SequenceCheck.checkTableSequences(ctx, null);
            SequenceCheck.checkTableID(ctx, null);
            SequenceCheck.checkClientSequences(ctx, null);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "validate", (Throwable)e);
        }
    }

    private static void checkTableSequences(Properties ctx, SvrProcess sp) {
        ResultSet rs;
        CPreparedStatement pstmt;
        String sql;
        String trxName;
        block20: {
            trxName = null;
            if (sp != null) {
                trxName = sp.get_TrxName();
            }
            sql = "SELECT TableName FROM AD_Table t WHERE IsActive='Y' AND IsView='N' AND NOT EXISTS (SELECT * FROM AD_Sequence s WHERE UPPER(s.Name)=UPPER(t.TableName) AND s.IsTableID='Y')";
            pstmt = null;
            rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String tableName = rs.getString(1);
                        if (MSequence.createTableSequence((Properties)ctx, (String)tableName, (String)trxName)) {
                            if (sp != null) {
                                sp.addLog(0, null, null, tableName);
                                continue;
                            }
                            s_log.fine(tableName);
                            continue;
                        }
                        throw new Exception("Error creating Table Sequence for " + tableName);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block20;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        sql = "UPDATE AD_Sequence s SET Name = (SELECT TableName FROM AD_Table t WHERE t.IsView='N' AND UPPER(s.Name)=UPPER(t.TableName)) WHERE s.IsTableID='Y' AND EXISTS (SELECT * FROM AD_Table t WHERE t.IsActive='Y' AND t.IsView='N' AND UPPER(s.Name)=UPPER(t.TableName) AND s.Name<>t.TableName)";
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no > 0) {
            if (sp != null) {
                StringBuilder msglog = new StringBuilder("SyncName #").append(no);
                sp.addLog(0, null, null, msglog.toString());
            } else if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("Sync #" + no);
            }
        }
        if (no >= 0) {
            return;
        }
        sql = "SELECT TableName, s.Name FROM AD_Table t, AD_Sequence s WHERE t.IsActive='Y' AND t.IsView='N' AND UPPER(s.Name)=UPPER(t.TableName) AND s.Name<>t.TableName";
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String TableName = rs.getString(1);
                    String SeqName = rs.getString(2);
                    StringBuilder msglog = new StringBuilder("ERROR: TableName=").append(TableName).append(" - Sequence=").append(SeqName);
                    sp.addLog(0, null, null, msglog.toString());
                }
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, sql, (Throwable)e);
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private static void checkTableID(Properties ctx, SvrProcess sp) {
        int counter;
        block13: {
            int IDRangeEnd = DB.getSQLValue(null, (String)"SELECT IDRangeEnd FROM AD_System");
            if (IDRangeEnd <= 0) {
                IDRangeEnd = DB.getSQLValue(null, (String)"SELECT MIN(IDRangeStart)-1 FROM AD_Replication");
            }
            if (s_log.isLoggable(Level.INFO)) {
                s_log.info("IDRangeEnd = " + IDRangeEnd);
            }
            String sql = "SELECT * FROM AD_Sequence WHERE IsTableID='Y' ORDER BY Name";
            counter = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String trxName = null;
            if (sp != null) {
                trxName = sp.get_TrxName();
            }
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MSequence seq = new MSequence(ctx, rs, trxName);
                        String tableValidation = seq.validateTableIDValue();
                        if (tableValidation == null) continue;
                        if (sp != null) {
                            sp.addLog(0, null, null, tableValidation);
                        } else {
                            s_log.fine(tableValidation);
                        }
                        if (seq.save()) {
                            ++counter;
                            continue;
                        }
                        s_log.severe("Not updated: " + seq);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("#" + counter);
        }
    }

    private static void checkClientSequences(Properties ctx, SvrProcess sp) {
        String trxName = null;
        if (sp != null) {
            trxName = sp.get_TrxName();
        }
        Trx trx = Trx.get((String)trxName, (boolean)false);
        trx.commit();
        MClient[] clients = MClient.getAll((Properties)ctx);
        int i = 0;
        while (i < clients.length) {
            MClient client = clients[i];
            if (client.isActive()) {
                MSequence.checkClientSequences((Properties)ctx, (int)client.getAD_Client_ID(), (String)trxName);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment((boolean)false);
        CLogMgt.setLevel((Level)Level.FINE);
        s_log.info("Sequence Check");
        s_log.info("--------------");
        ProcessInfo pi = new ProcessInfo("Sequence Check", 258);
        pi.setAD_Client_ID(0);
        pi.setAD_User_ID(100);
        SequenceCheck sc = new SequenceCheck();
        sc.startProcess(Env.getCtx(), pi, null);
        StringBuilder msgout = new StringBuilder("Process=").append(pi.getTitle()).append(" Error=").append(pi.isError()).append(" Summary=").append(pi.getSummary());
        System.out.println(msgout.toString());
    }
}

