/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.analytics.dataset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.analytics.data.Axis;
import net.sf.jasperreports.engine.analytics.dataset.DataAxis;
import net.sf.jasperreports.engine.analytics.dataset.DataMeasure;
import net.sf.jasperreports.engine.analytics.dataset.MultiAxisData;
import net.sf.jasperreports.engine.analytics.dataset.MultiAxisDataset;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class BaseMultiAxisData
implements MultiAxisData,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected MultiAxisDataset dataset;
    private DataAxis[] axes = new DataAxis[Axis.axisCount()];
    private List<DataAxis> axisList;
    protected List<DataMeasure> measures;

    public BaseMultiAxisData() {
        this.axisList = new ArrayList<DataAxis>();
        this.measures = new ArrayList<DataMeasure>();
    }

    public BaseMultiAxisData(MultiAxisData data, JRBaseObjectFactory factory) {
        factory.put(data, this);
        this.dataset = factory.getMultiAxisDataset(data.getDataset());
        List<DataAxis> dataAxes = data.getDataAxisList();
        this.axisList = new ArrayList<DataAxis>(dataAxes.size());
        for (DataAxis dataAxis : dataAxes) {
            DataAxis axis = factory.getDataAxis(dataAxis);
            this.axisList.add(axis);
            this.axes[axis.getAxis().ordinal()] = axis;
        }
        List<DataMeasure> dataMeasures = data.getMeasures();
        this.measures = new ArrayList<DataMeasure>(dataMeasures.size());
        for (DataMeasure measure : dataMeasures) {
            this.measures.add(factory.getDataMeasure(measure));
        }
    }

    protected void addDataAxis(DataAxis axis) {
        if (axis.getAxis() == null) {
            throw new JRRuntimeException("Data axis level needs to be specified");
        }
        int axisIndex = axis.getAxis().ordinal();
        DataAxis existingAxis = this.axes[axisIndex];
        if (existingAxis == null) {
            this.axes[axisIndex] = axis;
            this.axisList.add(axis);
        } else if (existingAxis != axis) {
            throw new JRRuntimeException("Axis " + axis.getAxis() + " already exists");
        }
    }

    protected int removeDataAxis(Axis axis) {
        int axisIndex = axis.ordinal();
        if (this.axes[axisIndex] == null) {
            return -1;
        }
        int listIndex = this.axisList.indexOf(this.axes[axisIndex]);
        if (listIndex >= 0) {
            this.axisList.remove(listIndex);
        }
        this.axes[axisIndex] = null;
        return listIndex;
    }

    @Override
    public MultiAxisDataset getDataset() {
        return this.dataset;
    }

    @Override
    public List<DataAxis> getDataAxisList() {
        return this.axisList;
    }

    @Override
    public DataAxis getDataAxis(Axis axis) {
        return this.axes[axis.ordinal()];
    }

    @Override
    public List<DataMeasure> getMeasures() {
        return this.measures;
    }

    @Override
    public Object clone() {
        BaseMultiAxisData clone = null;
        try {
            clone = (BaseMultiAxisData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.dataset = JRCloneUtils.nullSafeClone(this.dataset);
        clone.axisList = JRCloneUtils.cloneList(this.axisList);
        clone.axes = new DataAxis[Axis.axisCount()];
        Iterator<DataAxis> i$ = clone.axisList.iterator();
        while (i$.hasNext()) {
            DataAxis axis;
            clone.axes[axis.getAxis().ordinal()] = axis = i$.next();
        }
        clone.measures = JRCloneUtils.cloneList(this.measures);
        return clone;
    }
}

