/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plaf;

import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.adempiere.plaf.AdempiereLookAndFeel;
import org.compiere.plaf.CompiereLookAndFeel;
import org.compiere.swing.CButton;
import org.compiere.swing.ColorBlind;
import org.compiere.swing.ExtendedTheme;
import org.compiere.util.Ini;
import org.compiere.util.ValueNamePair;

public final class AdempierePLAF {
    private static Logger log = Logger.getLogger(AdempierePLAF.class.getName());
    private static ValueNamePair[] s_looks = null;
    private static ValueNamePair s_defaultPLAF = null;
    private static ValueNamePair[] s_metalThemes = null;
    private static ValueNamePair[] s_plasticThemes = null;
    private static ValueNamePair s_vp_compiereTheme = null;
    private static ValueNamePair s_vp_metalTheme = null;
    private static ValueNamePair s_vp_adempiereTheme = null;
    static ResourceBundle s_res;

    static {
        ArrayList<ValueNamePair> plafList = new ArrayList<ValueNamePair>();
        ValueNamePair vp = null;
        ArrayList<ValueNamePair> metalThemes = new ArrayList<ValueNamePair>();
        ArrayList<ValueNamePair> plasticThemes = new ArrayList<ValueNamePair>();
        try {
            Class.forName("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            vp = new ValueNamePair("org.adempiere.plaf.AdempiereLookAndFeel", "Adempiere");
            plafList.add(vp);
            s_vp_adempiereTheme = new ValueNamePair("org.adempiere.plaf.AdempiereTheme", "Adempiere Theme");
            plasticThemes.add(s_vp_adempiereTheme);
            List installedThemes = AdempiereLookAndFeel.getInstalledThemes();
            for (Object t : installedThemes) {
                MetalTheme theme = (MetalTheme)t;
                vp = new ValueNamePair(theme.getClass().getName(), theme.getName());
                plasticThemes.add(vp);
            }
        }
        catch (Exception e) {
            log.severe("Plastic look and feel not found");
        }
        vp = new ValueNamePair("org.compiere.plaf.CompiereLookAndFeel", "Compiere");
        plafList.add(vp);
        s_vp_compiereTheme = new ValueNamePair("org.compiere.plaf.CompiereThemeBlueMetal", "Compiere Theme");
        metalThemes.add(s_vp_compiereTheme);
        metalThemes.add(new ValueNamePair("org.compiere.plaf.CompiereThemeIce", "Compiere Ice"));
        s_vp_metalTheme = new ValueNamePair("javax.swing.plaf.metal.OceanTheme", "Ocean");
        metalThemes.add(s_vp_metalTheme);
        metalThemes.add(new ValueNamePair("javax.swing.plaf.metal.DefaultMetalTheme", "Steel"));
        metalThemes.add(new ValueNamePair("org.compiere.plaf.AquaTheme", "Aqua"));
        metalThemes.add(new ValueNamePair("org.compiere.plaf.CharcoalTheme", "Charcoal"));
        metalThemes.add(new ValueNamePair("org.compiere.plaf.ContrastTheme", "Contrast"));
        metalThemes.add(new ValueNamePair("org.compiere.plaf.EmeraldTheme", "Emerald"));
        metalThemes.add(new ValueNamePair("org.compiere.plaf.RubyTheme", "Ruby"));
        int i = 0;
        while (i < plafList.size()) {
            vp = (ValueNamePair)plafList.get(i);
            UIManager.installLookAndFeel(vp.getName(), vp.getValue());
            ++i;
        }
        plafList = new ArrayList();
        UIManager.LookAndFeelInfo[] lfInfo = UIManager.getInstalledLookAndFeels();
        int i2 = 0;
        while (i2 < lfInfo.length) {
            vp = new ValueNamePair(lfInfo[i2].getClassName(), lfInfo[i2].getName());
            plafList.add(vp);
            if (lfInfo[i2].getName().equals("Adempiere")) {
                s_defaultPLAF = vp;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(String.valueOf(vp.getName()) + " (default)");
                }
            } else if (log.isLoggable(Level.FINEST)) {
                log.finest(vp.getName());
            }
            ++i2;
        }
        s_looks = new ValueNamePair[plafList.size()];
        plafList.toArray(s_looks);
        s_metalThemes = new ValueNamePair[metalThemes.size()];
        metalThemes.toArray(s_metalThemes);
        s_plasticThemes = new ValueNamePair[plasticThemes.size()];
        plasticThemes.toArray(s_plasticThemes);
        s_res = ResourceBundle.getBundle("org.compiere.plaf.PlafRes");
    }

    public static Color getFieldBackground_Normal() {
        return ColorBlind.getDichromatColor(UIManager.getColor("text"));
    }

    public static Color getFieldBackground_Error() {
        Color c = UIManager.getColor("TextField.errorBackground");
        if (c == null) {
            c = ExtendedTheme.DEFAULT_ERROR_BG;
        }
        return ColorBlind.getDichromatColor(c);
    }

    public static Color getFieldBackground_Mandatory() {
        Color c = UIManager.getColor("TextField.mandatoryBackground");
        if (c == null) {
            c = ExtendedTheme.DEFAULT_MANDATORY_BG;
        }
        return ColorBlind.getDichromatColor(c);
    }

    public static Color getFieldBackground_Inactive() {
        Color c = UIManager.getColor("TextField.inactiveBackground");
        if (c != null) {
            return ColorBlind.getDichromatColor(c);
        }
        return AdempierePLAF.getFieldBackground_Normal();
    }

    public static Color getFieldBackground_Selected() {
        Color c = UIManager.getColor("TextField.selectedBackground");
        if (c == null) {
            c = ExtendedTheme.DEFAULT_SELECTED_BG;
        }
        return ColorBlind.getDichromatColor(c);
    }

    public static Color getFieldBackground_ReadOnly() {
        Color c = UIManager.getColor("TextField.readonlyBackground");
        if (c == null) {
            c = ExtendedTheme.DEFAULT_READONLY_BG;
        }
        return ColorBlind.getDichromatColor(c);
    }

    public static Color getFormBackground() {
        return ColorBlind.getDichromatColor(UIManager.getColor("control"));
    }

    public static Color getInfoBackground() {
        Color c = UIManager.getColor("Info.background");
        if (c == null) {
            c = UIManager.getColor("info");
        }
        return ColorBlind.getDichromatColor(c);
    }

    public static Color getTextColor_Normal() {
        return ColorBlind.getDichromatColor(UIManager.getColor("textText"));
    }

    public static Color getTextColor_OK() {
        return AdempierePLAF.getTextColor_Normal();
    }

    public static Color getTextColor_Issue() {
        Color c = UIManager.getColor("TextField.errorForeground");
        if (c == null) {
            c = ExtendedTheme.DEFAULT_ERROR_FG;
        }
        return ColorBlind.getDichromatColor(c);
    }

    public static Color getTextColor_Label() {
        return ColorBlind.getDichromatColor(UIManager.getColor("controlText"));
    }

    public static Color getPrimary1() {
        return ColorBlind.getDichromatColor(MetalLookAndFeel.getCurrentTheme().getPrimaryControlDarkShadow());
    }

    public static Color getPrimary2() {
        return ColorBlind.getDichromatColor(MetalLookAndFeel.getCurrentTheme().getPrimaryControlShadow());
    }

    public static Color getPrimary3() {
        return ColorBlind.getDichromatColor(MetalLookAndFeel.getCurrentTheme().getPrimaryControl());
    }

    public static Color getSecondary1() {
        return ColorBlind.getDichromatColor(MetalLookAndFeel.getCurrentTheme().getControlDarkShadow());
    }

    public static Color getSecondary2() {
        return ColorBlind.getDichromatColor(MetalLookAndFeel.getCurrentTheme().getControlShadow());
    }

    public static Color getSecondary3() {
        return ColorBlind.getDichromatColor(MetalLookAndFeel.getCurrentTheme().getControl());
    }

    public static Font getFont_Header() {
        return MetalLookAndFeel.getWindowTitleFont();
    }

    public static Font getFont_Field() {
        return UIManager.getFont("TextField.font");
    }

    public static Font getFont_Label() {
        return UIManager.getFont("Label.font");
    }

    public static Font getFont_Small() {
        return MetalLookAndFeel.getSubTextFont();
    }

    public static ValueNamePair[] getPLAFs() {
        return s_looks;
    }

    public static ValueNamePair[] getThemes() {
        LookAndFeel l = UIManager.getLookAndFeel();
        if (l instanceof AdempiereLookAndFeel) {
            return s_plasticThemes;
        }
        if (l instanceof MetalLookAndFeel) {
            return s_metalThemes;
        }
        return new ValueNamePair[0];
    }

    public static void setPLAF() {
        String look = Ini.getProperty((String)"UILookFeel");
        String lookTheme = Ini.getProperty((String)"UITheme");
        ValueNamePair plaf = null;
        int i = 0;
        while (i < s_looks.length) {
            if (s_looks[i].getName().equals(look)) {
                plaf = s_looks[i];
                break;
            }
            ++i;
        }
        ValueNamePair theme = null;
        int i2 = 0;
        while (i2 < s_metalThemes.length) {
            if (s_metalThemes[i2].getName().equals(lookTheme)) {
                theme = s_metalThemes[i2];
                break;
            }
            ++i2;
        }
        if (theme == null) {
            i2 = 0;
            while (i2 < s_plasticThemes.length) {
                if (s_plasticThemes[i2].getName().equals(lookTheme)) {
                    theme = s_plasticThemes[i2];
                    break;
                }
                ++i2;
            }
        }
        AdempierePLAF.setPLAF(plaf == null ? s_defaultPLAF : plaf, theme, true);
    }

    public static void setPLAF(ValueNamePair plaf, ValueNamePair theme, boolean updateIni) {
        if (plaf == null) {
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(plaf + (theme == null ? "" : " - " + theme));
        }
        Class<?> lafClass = null;
        try {
            lafClass = Class.forName(plaf.getValue());
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            return;
        }
        if (updateIni) {
            Ini.setProperty((String)"UILookFeel", (String)plaf.getName());
            Ini.setProperty((String)"UITheme", (String)"");
        }
        boolean metal = MetalLookAndFeel.class.isAssignableFrom(lafClass);
        boolean adempiere = AdempiereLookAndFeel.class.isAssignableFrom(lafClass);
        boolean compiere = CompiereLookAndFeel.class.isAssignableFrom(lafClass);
        if (theme == null && metal) {
            theme = compiere ? s_vp_compiereTheme : (adempiere ? s_vp_adempiereTheme : s_vp_metalTheme);
        }
        if (theme != null && metal && theme.getValue().length() > 0) {
            try {
                Class<?> c = Class.forName(theme.getValue());
                MetalTheme t = (MetalTheme)c.newInstance();
                if (compiere) {
                    CompiereLookAndFeel.setCurrentTheme(t);
                } else if (adempiere && t instanceof PlasticTheme) {
                    AdempiereLookAndFeel.setCurrentTheme((PlasticTheme)t);
                } else {
                    MetalLookAndFeel.setCurrentTheme(t);
                }
                if (updateIni) {
                    Ini.setProperty((String)"UITheme", (String)theme.getName());
                }
            }
            catch (Exception e) {
                log.severe("Theme - " + e.getMessage());
            }
        }
        try {
            UIManager.setLookAndFeel((LookAndFeel)lafClass.newInstance());
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(plaf + " - " + theme);
        }
    }

    public static void updateUI(Window win) {
        if (win == null) {
            return;
        }
        Window c = win;
        do {
            SwingUtilities.updateComponentTreeUI(c);
            c.invalidate();
            c.pack();
            c.validate();
            c.repaint();
        } while ((c = c.getOwner()) != null);
    }

    public static void reset() {
        AdempierePLAF.setPLAF();
    }

    public static void printPLAFDefaults() {
        System.out.println(UIManager.getLookAndFeel());
        Object[] keys = UIManager.getLookAndFeelDefaults().keySet().toArray();
        Arrays.sort(keys);
        char lastStart = ' ';
        int i = 0;
        while (i < keys.length) {
            StringBuffer sb = new StringBuffer();
            sb.append(keys[i]).append(" = ").append(UIManager.get(keys[i]));
            if (keys[i].toString().charAt(0) != lastStart) {
                System.out.println();
                lastStart = keys[i].toString().charAt(0);
            }
            System.out.println(sb);
            ++i;
        }
    }

    public static boolean isActive() {
        return UIManager.getLookAndFeel() instanceof AdempiereLookAndFeel;
    }

    public static CButton getOKButton() {
        CButton b = new CButton();
        b.setIcon(new ImageIcon(AdempierePLAF.class.getResource("icons/Ok24.gif")));
        b.setMargin(new Insets(0, 10, 0, 10));
        b.setToolTipText(s_res.getString("OK"));
        return b;
    }

    public static CButton getCancelButton() {
        CButton b = new CButton();
        b.setIcon(new ImageIcon(AdempierePLAF.class.getResource("icons/Cancel24.gif")));
        b.setMargin(new Insets(0, 10, 0, 10));
        b.setToolTipText(s_res.getString("Cancel"));
        return b;
    }

    public static void showCenterScreen(Window window) {
        window.pack();
        Dimension sSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension wSize = window.getSize();
        window.setLocation((sSize.width - wSize.width) / 2, (sSize.height - wSize.height) / 2);
        window.toFront();
        window.setVisible(true);
    }

    public static void setCurrentMetalTheme(MetalLookAndFeel laf, MetalTheme theme) {
        if (laf instanceof CompiereLookAndFeel) {
            CompiereLookAndFeel.setCurrentTheme(theme);
        } else if (laf instanceof AdempiereLookAndFeel && theme instanceof PlasticTheme) {
            AdempiereLookAndFeel.setCurrentTheme((PlasticTheme)theme);
        } else {
            MetalLookAndFeel.setCurrentTheme(theme);
        }
    }

    public static void main(String[] args) {
        String jVersion = System.getProperty("java.version");
        if (!jVersion.startsWith("1.5")) {
            JOptionPane.showMessageDialog(null, "Require Java Version 1.5 or up - Not " + jVersion, "AdempierePLAF - Version Conflict", 0);
            System.exit(1);
        }
        Ini.loadProperties((boolean)true);
        AdempierePLAF.setPLAF();
        if (args.length == 0) {
            return;
        }
        String className = args[0];
        Class<?> startClass = null;
        try {
            startClass = Class.forName(className);
        }
        catch (Exception e) {
            log.severe("Did not find: " + className);
            e.printStackTrace();
            System.exit(1);
        }
        try {
            Method[] methods = startClass.getMethods();
            if (methods.length > 0) {
                if (Modifier.isStatic(methods[0].getModifiers()) && methods[0].getName().equals("main")) {
                    String[] startArgs = new String[args.length - 1];
                    int ii = 1;
                    while (ii < args.length) {
                        startArgs[ii] = args[ii];
                        ++ii;
                    }
                    methods[0].invoke(null, new Object[]{startArgs});
                }
                return;
            }
        }
        catch (Exception ee) {
            log.severe("Problems invoking main");
            ee.printStackTrace();
        }
        try {
            startClass.newInstance();
        }
        catch (Exception e) {
            log.severe("Cannot start: " + className);
            e.printStackTrace();
            System.exit(1);
        }
    }
}

