/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Color;
import java.awt.Cursor;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.Worker;
import org.compiere.util.Env;

public class OnlineHelp
extends JEditorPane
implements HyperlinkListener {
    private static final long serialVersionUID = -7201158578463954623L;
    protected static final String BASE_URL = "http://www.adempiere.com/wiki/index.php/OnlineLoginHelp";
    private static HashMap<String, String> s_links = new HashMap();

    static {
        new Worker(BASE_URL, s_links).start();
    }

    public OnlineHelp() {
        this.setEditable(false);
        this.setContentType("text/html");
        this.addHyperlinkListener(this);
    }

    public OnlineHelp(String url) {
        this();
        try {
            if (url != null && url.length() > 0) {
                this.setPage(url);
            }
        }
        catch (Exception e) {
            System.err.println("OnlineHelp URL=" + url + " - " + e);
        }
    }

    public OnlineHelp(boolean loadOnline) {
        this(loadOnline ? BASE_URL : null);
    }

    public static void openInDefaultBrowser() {
        Env.startBrowser((String)BASE_URL);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (e instanceof HTMLFrameHyperlinkEvent) {
            HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
            HTMLDocument doc = (HTMLDocument)this.getDocument();
            doc.processHTMLFrameHyperlinkEvent(evt);
        } else if (e.getURL() == null) {
            this.scrollToReference(e.getDescription().substring(1));
        } else {
            try {
                this.setPage(e.getURL());
            }
            catch (Throwable t) {
                System.err.println("Help.hyperlinkUpdate - " + t.toString());
                this.displayError("Error", e.getURL(), t);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void setText(String text) {
        this.setBackground(AdempierePLAF.getInfoBackground());
        super.setText(text);
        this.setCaretPosition(0);
    }

    @Override
    public void setPage(final URL url) {
        this.setBackground(Color.white);
        Runnable pgm = new Runnable(){

            @Override
            public void run() {
                OnlineHelp.this.loadPage(url);
            }
        };
        new Thread(pgm).start();
    }

    private void loadPage(URL url) {
        try {
            super.setPage(url);
        }
        catch (Exception e) {
            this.displayError("Error: URL not found", url, e);
        }
    }

    protected void displayError(String header, Object url, Object exception) {
        StringBuilder msg = new StringBuilder("<HTML><BODY>");
        msg.append("<H1>").append(header).append("</H1>").append("<H3>URL=").append(url).append("</H3>").append("<H3>Error=").append(exception).append("</H3>").append("<p>&copy;&nbsp;Adempiere &nbsp; ").append("<A HREF=\"").append(BASE_URL).append("\">Online Help</A></p>").append("</BODY></HTML>");
        this.setText(msg.toString());
    }

    public static boolean isAvailable() {
        return s_links.size() != 0;
    }
}

