/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FactReconcile;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.AutoCompletion;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.Lookup;
import org.compiere.model.MClient;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VFactReconcile
extends FactReconcile
implements FormPanel,
ActionListener,
TableModelListener,
VetoableChangeListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private DecimalFormat m_format = DisplayType.getNumberFormat((int)12);
    private int m_noSelected = 0;
    private static CLogger log = CLogger.getCLogger(VFactReconcile.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CLabel labelAcctSchema = new CLabel();
    private VLookup fieldAcctSchema = null;
    private MigLayout parameterLayout = null;
    private CLabel labelOrg = new CLabel();
    private VLookup fieldOrg = null;
    private VCheckBox isReconciled = new VCheckBox();
    private CLabel labelAccount = new CLabel();
    private VComboBox fieldAccount = new VComboBox();
    private CLabel labelBPartner = new CLabel();
    private VLookup fieldBPartner = null;
    private JLabel dataStatus = new JLabel();
    private JScrollPane dataPane = new JScrollPane();
    private MiniTable miniTable = new MiniTable();
    private CPanel commandPanel = new CPanel();
    private JButton bCancel = ConfirmPanel.createCancelButton(true);
    private JButton bGenerate = ConfirmPanel.createProcessButton(true);
    private JButton bReset = ConfirmPanel.createResetButton(true);
    private JButton bZoom = ConfirmPanel.createZoomButton(true);
    private FlowLayout commandLayout = new FlowLayout();
    private JButton bRefresh = ConfirmPanel.createRefreshButton(true);
    private CLabel labelDateAcct = new CLabel();
    private VDate fieldDateAcct = new VDate();
    private CLabel labelDateAcct2 = new CLabel();
    private VDate fieldDateAcct2 = new VDate();
    private CLabel labelProduct = new CLabel();
    private VLookup fieldProduct = null;
    private boolean loading = false;
    private CLabel differenceLabel = new CLabel();
    private CTextField differenceField = new CTextField();

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.commandPanel, "South");
            frame.getContentPane().add((Component)this.mainPanel, "Center");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.parameterLayout = new MigLayout("fillx, wrap 4, hidemode 0", " [150:150][250:250][100:100][200:200]");
        this.parameterPanel.setLayout((LayoutManager)this.parameterLayout);
        this.bRefresh.addActionListener(this);
        this.bReset.addActionListener(this);
        this.bZoom.addActionListener(this);
        this.bGenerate.setEnabled(false);
        this.bReset.setEnabled(false);
        this.bGenerate.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Process"));
        this.bReset.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Reset"));
        this.bZoom.setText(Msg.translate((Properties)Env.getCtx(), (String)"Fact_Acct_ID"));
        this.labelAcctSchema.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_AcctSchema_ID"));
        this.labelAccount.setText(Msg.translate((Properties)Env.getCtx(), (String)"Account_ID"));
        this.labelBPartner.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.labelDateAcct.setText(Msg.translate((Properties)Env.getCtx(), (String)"DateAcct"));
        this.labelDateAcct2.setText("-");
        this.labelProduct.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        this.labelOrg.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        this.isReconciled.setText(Msg.translate((Properties)Env.getCtx(), (String)"IsReconciled"));
        this.dataStatus.setText(" ");
        this.differenceLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Difference"));
        this.differenceField.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.differenceField.setEditable(false);
        this.differenceField.setText("0");
        this.differenceField.setColumns(8);
        this.differenceField.setHorizontalAlignment(4);
        this.bGenerate.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.labelAcctSchema, "");
        this.parameterPanel.add((Component)this.fieldAcctSchema, "growx");
        this.parameterPanel.add((Component)this.labelOrg, "");
        this.parameterPanel.add((Component)this.fieldOrg, "growx");
        this.parameterPanel.add((Component)this.labelAccount, "");
        this.parameterPanel.add((Component)this.fieldAccount, "wmax 250");
        this.parameterPanel.add((Component)this.isReconciled, "skip 1");
        this.parameterPanel.add((Component)this.labelBPartner, "");
        this.parameterPanel.add((Component)this.fieldBPartner, "growx");
        this.parameterPanel.add((Component)this.labelProduct, "");
        this.parameterPanel.add((Component)this.fieldProduct, "growx");
        this.parameterPanel.add((Component)this.labelDateAcct, "");
        this.parameterPanel.add((Component)this.fieldDateAcct, "growx");
        this.parameterPanel.add((Component)this.labelDateAcct2, "");
        this.parameterPanel.add((Component)this.fieldDateAcct2, "growx");
        this.parameterPanel.add((Component)this.bRefresh, "growx");
        this.mainPanel.add((Component)this.dataStatus, "South");
        this.mainPanel.add((Component)this.dataPane, "Center");
        this.dataPane.getViewport().add((Component)this.miniTable, null);
        this.commandPanel.setLayout(this.commandLayout);
        this.commandLayout.setAlignment(2);
        this.commandLayout.setHgap(10);
        this.commandPanel.add((Component)this.bZoom, null);
        this.commandPanel.add((Component)this.differenceLabel, null);
        this.commandPanel.add((Component)this.differenceField, null);
        this.commandPanel.add((Component)this.bGenerate, null);
        this.commandPanel.add((Component)this.bReset, null);
        this.commandPanel.add((Component)this.bCancel, null);
    }

    public void dynInit() {
        Properties ctx = Env.getCtx();
        this.m_AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        int AD_Column_ID = FactReconcile.col_C_AcctSchema_ID;
        MLookup lookupAS = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)19);
        this.fieldAcctSchema = new VLookup("C_AcctSchema_ID", true, false, true, (Lookup)lookupAS);
        this.fieldAcctSchema.addActionListener(this);
        this.fieldAcctSchema.setValue(MClient.get((Properties)ctx).getAcctSchema().getC_AcctSchema_ID());
        Dimension dim = this.fieldAcctSchema.getPreferredSize();
        dim.width = 300;
        this.fieldAcctSchema.setPreferredSize(dim);
        AD_Column_ID = FactReconcile.col_AD_Org_ID;
        MLookup lookupOrg = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)19);
        this.fieldOrg = new VLookup("AD_Org_ID", true, false, true, (Lookup)lookupOrg);
        if (lookupOrg.containsKey((Object)0)) {
            this.fieldOrg.setValue(0);
        } else {
            this.fieldOrg.setValue(Env.getAD_Org_ID((Properties)ctx));
        }
        dim = this.fieldOrg.getPreferredSize();
        dim.width = 300;
        this.fieldOrg.setPreferredSize(dim);
        AD_Column_ID = FactReconcile.col_C_BPartner_ID;
        MLookup lookupBP = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.fieldBPartner = new VLookup("C_BPartner_ID", false, false, true, (Lookup)lookupBP);
        AD_Column_ID = FactReconcile.col_M_Product_ID;
        MLookup lookupProduct = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.fieldProduct = new VLookup("M_Product_ID", false, false, true, (Lookup)lookupProduct);
        Vector vector = this.getAccount();
        int i = 0;
        while (i < vector.size()) {
            this.fieldAccount.addItem(vector.get(i));
            ++i;
        }
        AutoCompletion.enable(this.fieldAccount);
        this.fieldAccount.setMandatory(true);
        this.fieldAccount.setSelectedIndex(0);
    }

    public void loadData() {
        KeyNamePair pp = (KeyNamePair)this.fieldAccount.getSelectedItem();
        int Account_ID = pp.getKey();
        if (Account_ID != 0) {
            this.m_Account_ID = Account_ID;
        }
        if (this.fieldOrg.getValue() != null) {
            this.m_AD_Org_ID = (Integer)this.fieldOrg.getValue();
        }
        if (this.fieldAcctSchema.getValue() != null) {
            this.m_C_AcctSchema_ID = (Integer)this.fieldAcctSchema.getValue();
        }
        if (this.isReconciled.getValue() != null) {
            this.m_isReconciled = (Boolean)this.isReconciled.getValue();
        }
        if (this.fieldBPartner.getValue() != null) {
            this.m_C_BPartner_ID = (Integer)this.fieldBPartner.getValue();
        }
        if ((Integer)this.fieldProduct.getValue() != null) {
            this.m_M_Product_ID = (Integer)this.fieldProduct.getValue();
        }
        if (this.fieldDateAcct.getValue() != null) {
            this.m_DateAcct = (Timestamp)this.fieldDateAcct.getValue();
        }
        if (this.fieldDateAcct2.getValue() != null) {
            this.m_DateAcct2 = (Timestamp)this.fieldDateAcct2.getValue();
        }
        Vector data = this.getData();
        Vector columnNames = this.getColumnNames();
        this.miniTable.getModel().removeTableModelListener(this);
        DefaultTableModel modelI = new DefaultTableModel(data, columnNames);
        modelI.addTableModelListener(this);
        this.miniTable.setModel(modelI);
        this.setColumnClass(this.miniTable);
        this.miniTable.setColorColumn(this.amtColIndex);
    }

    public void calculateSelection() {
        this.m_noSelected = 0;
        BigDecimal selectedAmt = Env.ZERO;
        int rows = this.miniTable.getRowCount();
        int i = 0;
        while (i < rows) {
            boolean isSelected = (Boolean)this.miniTable.getModel().getValueAt(i, this.selectedColIndex);
            if (isSelected) {
                BigDecimal amt = (BigDecimal)this.miniTable.getModel().getValueAt(i, this.amtColIndex);
                if (amt != null) {
                    selectedAmt = selectedAmt.add(amt);
                }
                ++this.m_noSelected;
            }
            ++i;
        }
        StringBuilder info = new StringBuilder();
        info.append(this.m_noSelected).append(" ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected")).append(" / ").append(this.miniTable.getRowCount());
        this.differenceField.setText(this.m_format.format(selectedAmt));
        this.dataStatus.setText(info.toString());
        this.bGenerate.setEnabled(this.m_noSelected != 0 && Env.ZERO.compareTo(selectedAmt) == 0 && !this.isReconciled.isSelected());
        this.bReset.setEnabled(this.m_noSelected > 0 && this.isReconciled.isSelected());
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.loading) {
            this.calculateSelection();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bGenerate) {
            this.generateReconciliation();
        } else if (e.getSource() == this.bReset) {
            this.resetReconciliation();
        } else if (e.getSource() == this.bZoom) {
            this.zoom();
        } else if (e.getSource() == this.bCancel) {
            this.dispose();
        } else if (e.getSource() == this.bRefresh) {
            this.loadData();
        }
    }

    private void generateReconciliation() {
        log.info("");
        this.miniTable.stopEditor(true);
        if (this.miniTable.getRowCount() == 0) {
            return;
        }
        this.miniTable.setRowSelectionInterval(0, 0);
        this.calculateSelection();
        if (this.m_noSelected == 0) {
            return;
        }
        String format = "yyyy-MM-dd HH:mm:ss.SSS";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String time = sdf.format(cal.getTime());
        int r = 0;
        while (r < this.miniTable.getModel().getRowCount()) {
            KeyNamePair pp;
            int factId;
            boolean result;
            boolean isSelected = (Boolean)this.miniTable.getModel().getValueAt(r, this.selectedColIndex);
            if (isSelected && (result = this.generate(factId = (pp = (KeyNamePair)this.miniTable.getModel().getValueAt(r, this.idColIndex)).getKey(), time))) {
                ((DefaultTableModel)this.miniTable.getModel()).removeRow(r--);
            }
            ++r;
        }
    }

    protected void zoom() {
        log.info("");
        int selected = this.miniTable.getSelectedRow();
        if (selected == -1) {
            return;
        }
        KeyNamePair pp = (KeyNamePair)this.miniTable.getModel().getValueAt(selected, this.idColIndex);
        int factId = pp.getKey();
        AEnv.zoom(270, factId);
    }

    private void resetReconciliation() {
        log.info("");
        this.miniTable.stopEditor(true);
        if (this.miniTable.getRowCount() == 0) {
            return;
        }
        this.miniTable.setRowSelectionInterval(0, 0);
        this.calculateSelection();
        if (this.m_noSelected == 0) {
            return;
        }
        int r = 0;
        while (r < this.miniTable.getModel().getRowCount()) {
            KeyNamePair pp;
            int factId;
            boolean result;
            boolean isSelected = (Boolean)this.miniTable.getModel().getValueAt(r, this.selectedColIndex);
            if (isSelected && (result = this.reset(factId = (pp = (KeyNamePair)this.miniTable.getModel().getValueAt(r, this.idColIndex)).getKey()))) {
                ((DefaultTableModel)this.miniTable.getModel()).removeRow(r--);
            }
            ++r;
        }
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }
}

