/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.dbPort;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.db.CConnectionEditor;
import org.compiere.db.Database;
import org.compiere.dbPort.Convert;
import org.compiere.swing.CFrame;

public class ConvertDialog
extends CFrame
implements ActionListener {
    private static final long serialVersionUID = 4748833703849693696L;
    private JPanel parameterPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel lSelectFile = new JLabel();
    private JComboBox fSelectFile = new JComboBox();
    private JButton bSelectFile = new JButton();
    private JCheckBox fExecute = new JCheckBox();
    private JLabel lConnect = new JLabel();
    private CConnectionEditor fConnect = new CConnectionEditor();
    private JButton bStart = new JButton();
    private JScrollPane scrollPane = new JScrollPane();
    private JTextArea infoPane = new JTextArea();
    private Component component1;
    private Component component2;
    private Component component3;
    private Component component4;
    private JLabel lTarget = new JLabel();
    private JComboBox fTarget = new JComboBox<String>(Database.getDatabaseNames());
    private JCheckBox fVerbose = new JCheckBox();

    public ConvertDialog() {
        try {
            this.jbInit();
            this.fSelectFile.addItem("D:\\adempiere\\db\\database\\create\\views.sql");
            this.fSelectFile.addItem("D:\\adempiere\\db\\database\\create\\temporary.sql");
            this.fSelectFile.addItem("D:\\adempiere\\db\\database\\create\\sequences.sql");
            this.fSelectFile.addItem("D:\\adempiere\\db\\database\\create\\adempiere.sql");
            this.fConnect.setValue(CConnection.get((String)Database.DB_POSTGRESQL, (String)"linux", (int)5432, (String)"adempiere"));
            this.fTarget.setSelectedItem(Database.DB_POSTGRESQL);
            this.fExecute.setSelected(true);
            this.cmd_execute();
            this.pack();
            this.setVisible(true);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void jbInit() throws Exception {
        this.component1 = Box.createHorizontalStrut(8);
        this.component2 = Box.createHorizontalStrut(8);
        this.component3 = Box.createVerticalStrut(8);
        this.component4 = Box.createVerticalStrut(8);
        this.setDefaultCloseOperation(3);
        this.setTitle("DB Convert Dialog");
        this.parameterPanel.setLayout(this.gridBagLayout1);
        this.lSelectFile.setText("Select File");
        this.fSelectFile.setEditable(true);
        this.bSelectFile.setText("add file");
        this.bSelectFile.addActionListener(this);
        this.fExecute.setText("Execute Directly");
        this.fExecute.addActionListener(this);
        this.lConnect.setText("Connection");
        this.bStart.setText("Start");
        this.bStart.addActionListener(this);
        this.infoPane.setBackground(Color.lightGray);
        this.infoPane.setEditable(false);
        this.scrollPane.setPreferredSize(new Dimension(200, 200));
        this.lTarget.setText("Target");
        this.fVerbose.setText("Verbose");
        this.getContentPane().add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.lSelectFile, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fSelectFile, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bSelectFile, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fExecute, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.lConnect, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fConnect, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bStart, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add(this.component1, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.parameterPanel.add(this.component2, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.parameterPanel.add(this.component3, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.parameterPanel.add(this.component4, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.parameterPanel.add((Component)this.lTarget, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.infoPane, null);
        this.parameterPanel.add((Component)this.fTarget, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fVerbose, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (e.getSource() == this.bStart) {
            this.bStart.setEnabled(false);
            this.cmd_start();
            this.bStart.setEnabled(true);
        } else if (e.getSource() == this.bSelectFile) {
            this.cmd_selectFile();
        } else if (e.getSource() == this.fExecute) {
            this.cmd_execute();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void cmd_execute() {
        this.lConnect.setEnabled(this.fExecute.isSelected());
        this.fConnect.setReadWrite(this.fExecute.isSelected());
        this.lTarget.setEnabled(!this.fExecute.isSelected());
        this.fTarget.setEnabled(!this.fExecute.isSelected());
    }

    private void cmd_selectFile() {
        JFileChooser fc = new JFileChooser();
        fc.setMultiSelectionEnabled(false);
        if (fc.showOpenDialog(this) != 0) {
            return;
        }
        File f = fc.getSelectedFile();
        if (f == null || !f.isFile()) {
            return;
        }
        String fileName = f.getAbsolutePath();
        this.fSelectFile.addItem(fileName);
        this.fSelectFile.setSelectedItem(fileName);
    }

    private void cmd_start() {
        Convert convert;
        File file = new File((String)this.fSelectFile.getSelectedItem());
        if (!file.exists() || file.isDirectory()) {
            this.infoPane.append("File does not exist or a directory: " + file + "\n");
            return;
        }
        this.infoPane.append("Opening file: " + file + "\n");
        StringBuilder sb = new StringBuilder(1000);
        try {
            FileReader fr = new FileReader(file);
            BufferedReader in = new BufferedReader(fr);
            String line = null;
            int lines = 0;
            while ((line = in.readLine()) != null) {
                ++lines;
                sb.append(line).append('\n');
            }
            in.close();
            fr.close();
            this.infoPane.append("- Read lines: " + lines + ", size: " + sb.length() + "\n");
        }
        catch (FileNotFoundException fnf) {
            this.infoPane.append("Error: " + fnf + "\n");
            return;
        }
        catch (IOException ioe) {
            this.infoPane.append("Error: " + ioe + "\n");
            return;
        }
        if (this.fExecute.isSelected()) {
            CConnection cc = (CConnection)this.fConnect.getValue();
            convert = cc.getDatabase().getConvert();
            convert.setVerbose(this.fVerbose.isSelected());
            Connection conn = cc.getConnection(true, 2);
            convert.execute(sb.toString(), conn);
            if (convert.hasError()) {
                StringBuilder sbb = new StringBuilder("- Error: ");
                if (convert.getConversionError() != null) {
                    sbb.append(convert.getConversionError()).append(' ');
                }
                if (convert.getException() != null) {
                    sbb.append(convert.getException());
                    convert.getException().printStackTrace();
                }
                sbb.append("\n");
                this.infoPane.append(sbb.toString());
            } else {
                this.infoPane.append("- OK\n");
            }
        } else {
            String target = (String)this.fTarget.getSelectedItem();
            if (Database.DB_ORACLE.equals(target)) {
                this.infoPane.append("No conversion needed.\n");
                return;
            }
            convert = null;
            try {
                convert = Database.getDatabase((String)target).getConvert();
            }
            catch (Exception e) {
                this.infoPane.append("Error: " + e + "\n");
                return;
            }
            String cc = convert.convertAll(sb.toString());
            String fileName = file.getAbsolutePath();
            int pos = fileName.lastIndexOf(46);
            fileName = pos == -1 ? String.valueOf(fileName) + target : String.valueOf(fileName.substring(0, pos)) + target + fileName.substring(pos);
            this.infoPane.append("Writing to: " + fileName + "\n");
            try {
                FileWriter fw = new FileWriter(fileName, false);
                BufferedWriter out = new BufferedWriter(fw);
                out.write("-- Adempiere dbPort - Convert Oracle to " + target);
                out.newLine();
                out.write("-- " + Adempiere.getSummary());
                out.newLine();
                out.write(cc);
                out.close();
                fw.close();
            }
            catch (IOException ioe) {
                this.infoPane.append("Error: " + ioe + "\n");
            }
            this.infoPane.append("- Written: " + cc.length() + "\n");
        }
    }

    public static void main(String[] args) {
        new ConvertDialog();
    }
}

