/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.swing.CColumnControlButton;
import org.compiere.swing.TableCellNone;
import org.compiere.util.MSort;
import org.jdesktop.swingx.icon.ColumnControlIcon;

public class CTable
extends JTable {
    private static final long serialVersionUID = 975975420639030844L;
    protected int p_lastSortIndex = -1;
    protected boolean p_asc = true;
    private final int SLACK = 15;
    private final int MAXSIZE = 250;
    protected int p_keyColumnIndex = -1;
    protected boolean sorting;
    private static Logger log = Logger.getLogger(CTable.class.getName());
    private int verticalScrollPolicy;
    private boolean columnControlVisible = false;
    private JComponent columnControlButton;
    private List<TableColumn> hiddenColumns = new ArrayList<TableColumn>();
    private Map<TableColumn, ColumnAttributes> columnAttributesMap = new HashMap<TableColumn, ColumnAttributes>();

    public CTable() {
        super(new DefaultTableModel());
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(2);
        this.setAutoResizeMode(0);
        this.getTableHeader().addMouseListener(new CTableMouseListener());
        this.setSurrendersFocusOnKeystroke(true);
        this.setRowHeight(this.getFont().getSize() + 8);
        this.setColumnControlVisible(true);
        this.addHierarchyListener(this.createHierarchyListener());
    }

    private HierarchyListener createHierarchyListener() {
        return new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getChangeFlags() == 1L) {
                    CTable.this.configureColumnControl();
                }
            }
        };
    }

    public void setKeyColumnIndex(int keyColumnIndex) {
        this.p_keyColumnIndex = keyColumnIndex;
    }

    public int getKeyColumnIndex() {
        return this.p_keyColumnIndex;
    }

    public Object getSelectedKeyColumnValue() {
        int row = this.getSelectedRow();
        if (row != -1 && this.p_keyColumnIndex != -1) {
            return this.getModel().getValueAt(row, this.p_keyColumnIndex);
        }
        return null;
    }

    public Object getSelectedValue() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1 || col == -1) {
            return null;
        }
        return this.getValueAt(row, col);
    }

    public void stopEditor(boolean saveValue) {
        ChangeEvent ce = new ChangeEvent(this);
        if (saveValue) {
            this.editingStopped(ce);
        } else {
            this.editingCanceled(ce);
        }
        if (this.getInputContext() != null) {
            this.getInputContext().endComposition();
        }
        this.transferFocus();
    }

    public void autoSize(boolean useColumnIdentifier) {
        TableModel model = this.getModel();
        int size = model.getColumnCount();
        int c = 0;
        while (c < size) {
            TableColumn column = this.getColumnModel().getColumn(c);
            if (!useColumnIdentifier || column.getIdentifier() != null && column.getMaxWidth() != 0 && column.getIdentifier().toString().length() != 0) {
                int width = 0;
                TableCellRenderer renderer = column.getHeaderRenderer();
                if (renderer == null) {
                    renderer = new DefaultTableCellRenderer();
                }
                Component comp = null;
                if (renderer != null) {
                    comp = renderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
                }
                if (comp != null) {
                    width = comp.getPreferredSize().width;
                    width = Math.max(width, comp.getWidth());
                    int col = column.getModelIndex();
                    int maxRow = Math.min(20, this.getRowCount());
                    try {
                        int row = 0;
                        while (row < maxRow) {
                            renderer = this.getCellRenderer(row, col);
                            comp = renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                            if (comp != null) {
                                int rowWidth = comp.getPreferredSize().width;
                                width = Math.max(width, rowWidth);
                            }
                            ++row;
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, column.getIdentifier().toString(), e);
                    }
                    width = Math.min(250, width + 15);
                }
                column.setPreferredWidth(width);
            }
            ++c;
        }
    }

    public void packColumn(TableColumn column) {
        int width = 0;
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = new DefaultTableCellRenderer();
        }
        Component comp = null;
        if (renderer != null) {
            comp = renderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
        }
        if (comp != null) {
            width = comp.getPreferredSize().width;
            width = Math.max(width, comp.getWidth());
            int col = column.getModelIndex();
            int maxRow = Math.min(20, this.getRowCount());
            try {
                int row = 0;
                while (row < maxRow) {
                    renderer = this.getCellRenderer(row, col);
                    comp = renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                    if (comp != null) {
                        int rowWidth = comp.getPreferredSize().width;
                        width = Math.max(width, rowWidth);
                    }
                    ++row;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, column.getIdentifier().toString(), e);
            }
            width = Math.min(250, width + 15);
        }
        column.setPreferredWidth(width);
    }

    protected void sort(final int modelColumnIndex) {
        int selCol;
        int rows = this.getRowCount();
        if (rows == 0) {
            return;
        }
        this.sorting = true;
        this.p_asc = modelColumnIndex != this.p_lastSortIndex ? true : !this.p_asc;
        this.p_lastSortIndex = modelColumnIndex;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("#" + modelColumnIndex + " - rows=" + rows + ", asc=" + this.p_asc);
        }
        Object selected = null;
        int selRow = this.getSelectedRow();
        int n = selCol = this.p_keyColumnIndex == -1 ? 0 : this.p_keyColumnIndex;
        if (this.getSelectedRow() >= 0) {
            selected = this.getValueAt(selRow, selCol);
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        final MSort sort = new MSort(0, null);
        sort.setSortAsc(this.p_asc);
        Collections.sort(model.getDataVector(), new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Object item1 = ((Vector)o1).get(modelColumnIndex);
                Object item2 = ((Vector)o2).get(modelColumnIndex);
                return sort.compare(item1, item2);
            }
        });
        this.clearSelection();
        if (selected != null) {
            int r = 0;
            while (r < rows) {
                if (selected.equals(this.getValueAt(r, selCol))) {
                    this.setRowSelectionInterval(r, r);
                    this.scrollRectToVisible(this.getCellRect(r, modelColumnIndex, true));
                    break;
                }
                ++r;
            }
        }
        this.sorting = false;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e != null && e.getFirstRow() == 0 && e.getLastRow() == Integer.MAX_VALUE && e.getColumn() == -1 && e.getType() == 0) {
            if (!this.sorting) {
                this.p_asc = true;
                this.p_lastSortIndex = -1;
            }
        } else if (this.getRowCount() == 0) {
            this.p_asc = true;
            this.p_lastSortIndex = -1;
        }
        super.tableChanged(e);
    }

    @Override
    public String toString() {
        return new StringBuffer("CTable[").append(this.getModel()).append("]").toString();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.setRowHeight(this.getFont().getSize() + 8);
    }

    public int getSortColumn() {
        return this.p_lastSortIndex;
    }

    public boolean isSortAscending() {
        return this.p_asc;
    }

    public boolean isColumnControlVisible() {
        return this.columnControlVisible;
    }

    public void setColumnControlVisible(boolean visible) {
        boolean old = this.isColumnControlVisible();
        this.columnControlVisible = visible;
        if (old != this.isColumnControlVisible()) {
            this.configureColumnControl();
            this.firePropertyChange("columnControlVisible", old, !old);
        }
    }

    public JComponent getColumnControl() {
        if (this.columnControlButton == null) {
            this.columnControlButton = this.createDefaultColumnControl();
        }
        return this.columnControlButton;
    }

    protected JComponent createDefaultColumnControl() {
        return new CColumnControlButton(this, (Icon)new ColumnControlIcon());
    }

    protected void configureColumnControl() {
        Container gp;
        Container p2 = this.getParent();
        if (p2 instanceof JViewport && (gp = p2.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            if (this.isColumnControlVisible()) {
                this.verticalScrollPolicy = scrollPane.getVerticalScrollBarPolicy();
                scrollPane.setCorner("UPPER_TRAILING_CORNER", this.getColumnControl());
                scrollPane.setVerticalScrollBarPolicy(22);
            } else {
                if (this.verticalScrollPolicy != 0) {
                    scrollPane.setVerticalScrollBarPolicy(this.verticalScrollPolicy);
                }
                try {
                    scrollPane.setCorner("UPPER_TRAILING_CORNER", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isColumnVisible(TableColumn column) {
        return !this.hiddenColumns.contains(column);
    }

    public void setColumnVisibility(TableColumn column, boolean visible) {
        if (visible) {
            if (this.isColumnVisible(column)) {
                return;
            }
            ColumnAttributes attributes = this.columnAttributesMap.get(column);
            if (attributes == null) {
                return;
            }
            column.setCellEditor(attributes.cellEditor);
            column.setCellRenderer(attributes.cellRenderer);
            column.setMinWidth(attributes.minWidth);
            column.setMaxWidth(attributes.maxWidth);
            column.setPreferredWidth(attributes.preferredWidth);
            this.columnAttributesMap.remove(column);
            this.hiddenColumns.remove(column);
        } else {
            if (!this.isColumnVisible(column)) {
                return;
            }
            ColumnAttributes attributes = new ColumnAttributes();
            attributes.cellEditor = column.getCellEditor();
            attributes.cellRenderer = column.getCellRenderer();
            attributes.minWidth = column.getMinWidth();
            attributes.maxWidth = column.getMaxWidth();
            attributes.preferredWidth = column.getPreferredWidth();
            this.columnAttributesMap.put(column, attributes);
            TableCellNone h = new TableCellNone(column.getIdentifier() != null ? column.getIdentifier().toString() : column.getHeaderValue().toString());
            column.setCellEditor(h);
            column.setCellRenderer(h);
            column.setMinWidth(0);
            column.setMaxWidth(0);
            column.setPreferredWidth(0);
            this.hiddenColumns.add(column);
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
        Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
        if (c == null) {
            return c;
        }
        if (!this.isCellEditable(rowIndex, vColIndex) || this.isCellSelected(rowIndex, vColIndex)) {
            return c;
        }
        if (rowIndex % 2 == 0) {
            c.setBackground(AdempierePLAF.getFieldBackground_Selected());
        } else {
            c.setBackground(this.getBackground());
        }
        return c;
    }

    class CTableMouseListener
    extends MouseAdapter {
        private TableColumn cachedResizingColumn = null;

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.isInResizeRegion(e)) {
                if (e.getClickCount() == 2) {
                    CTable.this.packColumn(this.cachedResizingColumn);
                }
                this.uncacheResizingColumn();
            } else {
                int vc = CTable.this.getColumnModel().getColumnIndexAtX(e.getX());
                int mc = CTable.this.convertColumnIndexToModel(vc);
                TableColumn column = CTable.this.getTableHeader().getResizingColumn();
                if (column != null) {
                    return;
                }
                CTable.this.sort(mc);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.cacheResizingColumn(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.cacheResizingColumn(e);
        }

        private void cacheResizingColumn(MouseEvent e) {
            TableColumn column = CTable.this.getTableHeader().getResizingColumn();
            if (column != null) {
                this.cachedResizingColumn = column;
            }
        }

        private void uncacheResizingColumn() {
            this.cachedResizingColumn = null;
        }

        private boolean isInResizeRegion(MouseEvent e) {
            return this.cachedResizingColumn != null;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.uncacheResizingColumn();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.uncacheResizingColumn();
        }
    }

    class ColumnAttributes {
        protected TableCellEditor cellEditor;
        protected TableCellRenderer cellRenderer;
        protected Object headerValue;
        protected int minWidth;
        protected int maxWidth;
        protected int preferredWidth;

        ColumnAttributes() {
        }
    }
}

