/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.graph;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;

public class FCHtmlEditorKit
extends HTMLEditorKit {
    private static final long serialVersionUID = -3371176452691681668L;
    private static ViewFactory defaultFactory = null;

    @Override
    public ViewFactory getViewFactory() {
        if (defaultFactory == null) {
            defaultFactory = new FCHtmlFactory(super.getViewFactory());
        }
        return defaultFactory;
    }

    private static class FCHtmlFactory
    implements ViewFactory {
        private ViewFactory oldFactory;

        public FCHtmlFactory(ViewFactory factory) {
            this.oldFactory = factory;
        }

        @Override
        public View create(Element elem) {
            String src;
            View result = this.oldFactory.create(elem);
            if (result instanceof ImageView && "res:".equals((src = (String)elem.getAttributes().getAttribute(HTML.Attribute.SRC)).substring(0, 4))) {
                result = new NewImageView(elem);
            }
            return result;
        }

        private static class NewImageView
        extends ImageView {
            Element elem;
            private static Image smileImage = null;

            public NewImageView(Element elem) {
                super(elem);
                this.elem = elem;
            }

            @Override
            public Image getImage() {
                String src = (String)this.elem.getAttributes().getAttribute(HTML.Attribute.SRC);
                URL url = this.getClass().getClassLoader().getResource(src.substring(4));
                if (url == null) {
                    return null;
                }
                smileImage = Toolkit.getDefaultToolkit().getImage(url);
                if (smileImage == null) {
                    return null;
                }
                ImageIcon ii = new ImageIcon();
                ii.setImage(smileImage);
                return smileImage;
            }

            @Override
            public URL getImageURL() {
                String src = (String)this.elem.getAttributes().getAttribute(HTML.Attribute.SRC);
                URL url = this.getClass().getClassLoader().getResource(src.substring(4));
                if (url != null) {
                    return url;
                }
                return null;
            }
        }
    }
}

