/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JPasswordField;
import org.compiere.Adempiere;
import org.compiere.apps.ConfirmPanel;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Ini;

public final class ClientCredentialDialog
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = 2728290476926236505L;
    protected static final String RESOURCE = "org.compiere.apps.ALoginRes";
    private static ResourceBundle res = ResourceBundle.getBundle("org.compiere.apps.ALoginRes");
    private static CLogger log = CLogger.getCLogger(ClientCredentialDialog.class);
    private CPanel mainPanel = new CPanel(new BorderLayout());
    private CLabel userLabel = new CLabel();
    private CTextField userTextField = new CTextField();
    private CLabel passwordLabel = new CLabel();
    private JPasswordField passwordField = new JPasswordField();
    private GridBagLayout loginLayout = new GridBagLayout();
    private CPanel loginPanel = new CPanel(this.loginLayout);
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, false, false, false, false, false, false);
    private boolean m_okPressed = false;

    public ClientCredentialDialog(Dialog parent) {
        super(parent, "Login", true);
        log.finer("");
        this.setDefaultCloseOperation(2);
        res = ResourceBundle.getBundle(RESOURCE);
        try {
            this.jbInit();
            this.initLogin();
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
        this.getRootPane().setDefaultButton(this.confirmPanel.getOKButton());
        parent.setIconImage(Adempiere.getImage16());
    }

    private void jbInit() throws Exception {
        this.setName("Login");
        this.userLabel.setRequestFocusEnabled(false);
        this.userLabel.setLabelFor(this.userTextField);
        this.passwordLabel.setRequestFocusEnabled(false);
        this.passwordLabel.setLabelFor(this.passwordField);
        this.southPanel.setLayout(this.southLayout);
        this.userLabel.setHorizontalAlignment(4);
        this.userLabel.setText(res.getString("User"));
        this.userLabel.setLabelFor(this.userTextField);
        this.loginPanel.add((Component)this.userLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.userTextField.setText("System");
        this.loginPanel.add((Component)this.userTextField, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.passwordLabel.setHorizontalAlignment(4);
        this.passwordLabel.setText(res.getString("Password"));
        this.passwordLabel.setLabelFor(this.passwordField);
        this.loginPanel.add((Component)this.passwordLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.passwordField.setText("System");
        this.loginPanel.add((Component)this.passwordField, new GridBagConstraints(1, 4, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.loginPanel, "Center");
        this.mainPanel.setName("loginMainPanel");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.confirmPanel, "North");
        this.confirmPanel.addActionListener(this);
    }

    public boolean initLogin() {
        this.userTextField.setText(Ini.getProperty((String)"ApplicationUserID"));
        if (Ini.isPropertyBool((String)"StorePassword")) {
            this.passwordField.setText(Ini.getProperty((String)"ApplicationPassword"));
        } else {
            this.passwordField.setText("");
        }
        return false;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.toFront();
            this.confirmPanel.getOKButton().requestFocusInWindow();
        }
    }

    private void appExit() {
        this.dispose();
    }

    public boolean isOKpressed() {
        return this.m_okPressed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.m_okPressed = true;
            this.appExit();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.m_okPressed = false;
            this.appExit();
        }
    }

    public String getUserId() {
        return this.userTextField.getText();
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }
}

