/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.standard.DocumentName;
import org.adempiere.process.IPrintShippingLabel;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MShipperLabels;

public class DefaultPrintShippingLabel
implements IPrintShippingLabel {
    public String printToLabelPrinter(MAttachment attachment, MShipperLabels labelType) throws Exception {
        MAttachmentEntry[] entries = attachment.getEntries();
        ArrayList<MAttachmentEntry> list = new ArrayList<MAttachmentEntry>();
        if (entries != null && entries.length > 0) {
            PrinterJob pjob;
            MAttachmentEntry[] mAttachmentEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                MAttachmentEntry entry = mAttachmentEntryArray[n2];
                if (entry.getName().startsWith("shipping_label")) {
                    list.add(entry);
                }
                ++n2;
            }
            if (list.size() > 0 && (pjob = PrinterJob.getPrinterJob()).printDialog()) {
                PrintService service = pjob.getPrintService();
                DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
                for (MAttachmentEntry entry : list) {
                    DocPrintJob job = service.createPrintJob();
                    HashDocAttributeSet as = new HashDocAttributeSet();
                    as.add(new DocumentName(entry.getName(), null));
                    SimpleDoc doc = new SimpleDoc(entry.getData(), flavor, as);
                    job.print(doc, null);
                }
            }
        }
        return String.valueOf(list.size()) + " labels printed.";
    }

    public String printImageLabel(MAttachment attachment, MShipperLabels labelType, String title) throws Exception {
        MAttachmentEntry[] entries = attachment.getEntries();
        ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
        if (entries != null && entries.length > 0) {
            MAttachmentEntry[] mAttachmentEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                BufferedImage image;
                MAttachmentEntry entry = mAttachmentEntryArray[n2];
                if (entry.getName().startsWith("shipping_label") && entry.isGraphic() && (image = ImageIO.read(entry.getInputStream())) != null) {
                    list.add(image);
                }
                ++n2;
            }
            if (list.size() > 0) {
                Book book = new Book();
                PrinterJob pjob = PrinterJob.getPrinterJob();
                pjob.setJobName(title);
                if (pjob.printDialog()) {
                    PageFormat pf = pjob.pageDialog(pjob.defaultPage());
                    Paper p = pf.getPaper();
                    BigDecimal width = labelType.getWidth();
                    BigDecimal height = labelType.getHeight();
                    if (width != null && width.compareTo(BigDecimal.ZERO) > 0 && height != null && height.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal factor = new BigDecimal(72);
                        width = width.multiply(factor);
                        height = height.multiply(factor);
                        p.setImageableArea(p.getImageableX(), p.getImageableY(), width.doubleValue(), height.doubleValue());
                        pf.setPaper(p);
                    }
                    for (BufferedImage image : list) {
                        book.append(new ImagePrintable(image), pf);
                    }
                    pjob.setPageable(book);
                    pjob.print();
                }
            }
        }
        return String.valueOf(list.size()) + " labels printed.";
    }

    static final class ImagePrintable
    implements Printable {
        private BufferedImage image;

        protected ImagePrintable(BufferedImage image) {
            this.image = image;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex > 0) {
                return 1;
            }
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            AffineTransform at = new AffineTransform();
            at.translate(0.0, 0.0);
            double xScale = pageFormat.getImageableWidth() / (double)this.image.getWidth();
            double yScale = pageFormat.getImageableHeight() / (double)this.image.getHeight();
            at.scale(xScale, yScale);
            g2d.drawRenderedImage(this.image, at);
            return 0;
        }
    }
}

