/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class AGlassPane
extends JPanel
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 618724937492933184L;
    public static Image s_image = Env.getImage((String)"iD10030.png");
    public static Font s_font = new Font("Dialog", 3, 14);
    public static Color s_color = AdempierePLAF.getTextColor_OK();
    private static final int GAP = 4;
    private String m_message = Msg.getMsg((Properties)Env.getCtx(), (String)"Processing");
    private Timer m_timer;
    private int m_timervalue = 0;
    private int m_timermax = 0;
    private static CLogger log = CLogger.getCLogger(AGlassPane.class);

    public AGlassPane() {
        this.setOpaque(false);
        this.setVisible(false);
        this.addMouseListener(this);
    }

    public void setMessage(String AD_Message) {
        this.m_message = AD_Message == null ? Msg.getMsg((Properties)Env.getCtx(), (String)"Processing") : (AD_Message.length() == 0 ? AD_Message : Msg.getMsg((Properties)Env.getCtx(), (String)AD_Message));
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public String getMessage() {
        return this.m_message;
    }

    public void setBusyTimer(int time) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Time=" + time);
        }
        if (time < 2) {
            this.m_timermax = 0;
            if (this.isVisible()) {
                this.repaint();
            }
            return;
        }
        this.m_timermax = time;
        this.m_timervalue = 0;
        if (this.m_timer == null) {
            this.m_timer = new Timer(1000, this);
        }
        this.m_timer.start();
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.repaint();
    }

    @Override
    public void setVisible(boolean flag) {
        if (!flag && this.m_timer != null) {
            this.m_timer.stop();
        }
        super.setVisible(flag);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_timermax > 0) {
            ++this.m_timervalue;
            if (this.m_timervalue > this.m_timermax) {
                this.m_timervalue = 0;
            }
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension panelSize = this.getSize();
        g.setColor(new Color(1.0f, 1.0f, 1.0f, 0.4f));
        g.fillRect(0, 0, panelSize.width, panelSize.height);
        g.setFont(s_font);
        g.setColor(s_color);
        FontMetrics fm = g.getFontMetrics();
        Dimension messageSize = new Dimension(fm.stringWidth(this.m_message), fm.getAscent() + fm.getDescent());
        Dimension imageSize = new Dimension(s_image.getWidth(this), s_image.getHeight(this));
        Dimension progressSize = new Dimension(150, 15);
        int height = imageSize.height + 4 + messageSize.height + 4 + progressSize.height;
        if (height > panelSize.height) {
            log.log(Level.SEVERE, "Panel too small - height=" + panelSize.height);
            return;
        }
        int yImage = panelSize.height / 2 - height / 2;
        int yMessage = yImage + imageSize.height + 4 + fm.getAscent();
        int yProgress = yMessage + fm.getDescent() + 4;
        if (imageSize.width > panelSize.width || messageSize.width > panelSize.width) {
            log.log(Level.SEVERE, "Panel too small - width=" + panelSize.width);
            return;
        }
        int xImage = panelSize.width / 2 - imageSize.width / 2;
        int xMessage = panelSize.width / 2 - messageSize.width / 2;
        int xProgress = panelSize.width / 2 - progressSize.width / 2;
        g.drawImage(s_image, xImage, yImage, this);
        g.drawString(this.m_message, xMessage, yMessage);
        if (this.m_timermax > 0) {
            int pWidth = progressSize.width / this.m_timermax * this.m_timervalue;
            g.setColor(AdempierePLAF.getPrimary3());
            g.fill3DRect(xProgress, yProgress, pWidth, progressSize.height, true);
            g.setColor(AdempierePLAF.getPrimary2());
            g.draw3DRect(xProgress, yProgress, progressSize.width, progressSize.height, true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isVisible()) {
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isVisible()) {
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isVisible()) {
            e.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isVisible()) {
            e.consume();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isVisible()) {
            e.consume();
        }
    }
}

