/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Container;
import java.awt.Frame;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.compiere.apps.AEnv;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.ProcessParameter;
import org.compiere.model.MPInstance;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class ClientProcessCtrl {
    private static CLogger log = CLogger.getCLogger(ClientProcessCtrl.class);

    public static ProcessCtl process(IProcessUI parent, int WindowNo, ProcessInfo pi, Trx trx) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("WindowNo=" + WindowNo + " - " + pi);
        }
        MPInstance instance = null;
        try {
            instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getRecord_ID());
        }
        catch (Exception e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        catch (Error e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        if (!instance.save()) {
            pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessNoInstance"));
            pi.setError(true);
            return null;
        }
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        ProcessParameter para = new ProcessParameter((Frame)AEnv.getFrame((Container)parent), WindowNo, pi);
        if (para.initDialog()) {
            para.setVisible(true);
            if (!para.isOK()) {
                pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessCancelled"));
                pi.setError(true);
                return null;
            }
        }
        ProcessCtl worker = new ProcessCtl(parent, WindowNo, pi, trx);
        if (parent != null) {
            worker.start();
        } else {
            worker.run();
        }
        return worker;
    }
}

