/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Container;
import java.awt.Frame;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.adempiere.util.IProcessUI;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.apps.AbstractProcessCtl;
import org.compiere.apps.IProcessParameter;
import org.compiere.apps.ProcessParameter;
import org.compiere.apps.Waiting;
import org.compiere.model.MPInstance;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class ProcessCtl
extends AbstractProcessCtl {
    private Waiting m_waiting;
    private static CLogger log = CLogger.getCLogger(ProcessCtl.class);

    public static ProcessCtl process(IProcessUI parent, int WindowNo, ProcessInfo pi, Trx trx) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("WindowNo=" + WindowNo + " - " + pi);
        }
        MPInstance instance = null;
        try {
            instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getRecord_ID());
        }
        catch (Exception e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        catch (Error e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        if (!instance.save()) {
            pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessNoInstance"));
            pi.setError(true);
            return null;
        }
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        ProcessParameter para = new ProcessParameter((Frame)AEnv.getFrame((Container)parent), WindowNo, pi);
        if (para.initDialog()) {
            para.setVisible(true);
            if (!para.isOK()) {
                pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessCancelled"));
                pi.setError(true);
                return null;
            }
        }
        ProcessCtl worker = new ProcessCtl(parent, WindowNo, pi, trx);
        if (parent != null) {
            worker.start();
        } else {
            worker.run();
        }
        return worker;
    }

    public static ProcessCtl process(IProcessUI parent, int WindowNo, IProcessParameter parameter, ProcessInfo pi, Trx trx) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("WindowNo=" + WindowNo + " - " + pi);
        }
        MPInstance instance = null;
        try {
            instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getRecord_ID());
        }
        catch (Exception e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        catch (Error e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        if (!instance.save()) {
            pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessNoInstance"));
            pi.setError(true);
            return null;
        }
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        if (parameter != null && !parameter.saveParameters()) {
            pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessCancelled"));
            pi.setError(true);
            return null;
        }
        ProcessCtl worker = new ProcessCtl(parent, WindowNo, pi, trx);
        if (parent != null) {
            worker.start();
        } else {
            worker.run();
        }
        return worker;
    }

    public ProcessCtl(IProcessUI parent, int WindowNo, ProcessInfo pi, Trx trx) {
        super(parent, WindowNo, pi, trx);
    }

    protected void lock() {
        if (this.getProcessMonitor() != null) {
            if (this.getProcessMonitor() instanceof Container) {
                JFrame frame = AEnv.getFrame((Container)this.getProcessMonitor());
                if (frame instanceof AWindow) {
                    ((AWindow)frame).setBusyTimer(this.getProcessInfo().getEstSeconds());
                } else {
                    this.m_waiting = new Waiting((Frame)frame, Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"), false, this.getProcessInfo().getEstSeconds());
                }
                ProcessUpdateRunnable runnable = new ProcessUpdateRunnable(){

                    @Override
                    public void run() {
                        if (ProcessCtl.this.m_waiting != null) {
                            ProcessCtl.this.m_waiting.toFront();
                            ProcessCtl.this.m_waiting.setVisible(true);
                        }
                        log.finer("lock");
                        this.parent.lockUI(this.pi);
                    }
                };
                runnable.setParent(this.getProcessMonitor());
                runnable.setProcessInfo(this.getProcessInfo());
                SwingUtilities.invokeLater(runnable);
            } else {
                log.finer("lock");
                this.getProcessMonitor().lockUI(this.getProcessInfo());
            }
        }
    }

    protected void unlock() {
        if (this.getProcessInfo().isBatch()) {
            this.getProcessInfo().setIsTimeout(true);
        }
        if (this.getParent() != null) {
            if (this.getParent() instanceof Container) {
                ProcessUpdateRunnable runnable = new ProcessUpdateRunnable(){

                    @Override
                    public void run() {
                        if (ProcessCtl.this.m_waiting != null) {
                            ProcessCtl.this.m_waiting.dispose();
                        }
                        ProcessCtl.this.m_waiting = null;
                        String summary = this.pi.getSummary();
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("unlock - " + summary);
                        }
                        if (summary != null && summary.indexOf(64) != -1) {
                            this.pi.setSummary(Msg.parseTranslation((Properties)Env.getCtx(), (String)summary));
                        }
                        this.parent.unlockUI(this.pi);
                    }
                };
                runnable.setParent(this.getParent());
                runnable.setProcessInfo(this.getProcessInfo());
                SwingUtilities.invokeLater(runnable);
            } else {
                this.getParent().unlockUI(this.getProcessInfo());
            }
        }
    }

    protected void updateProgressWindowTimerEstimate(int estSeconds) {
        if (this.m_waiting != null) {
            this.m_waiting.setTimerEstimate(this.getProcessInfo().getEstSeconds());
        }
    }

    protected void updateProgressWindowTitle(String title) {
        if (this.m_waiting != null) {
            this.m_waiting.setTitle(this.getProcessInfo().getTitle());
        }
    }

    abstract class ProcessUpdateRunnable
    implements Runnable {
        protected ProcessInfo pi = null;
        protected IProcessUI parent = null;

        ProcessUpdateRunnable() {
        }

        public void setProcessInfo(ProcessInfo pi) {
            this.pi = pi;
        }

        public void setParent(IProcessUI parent) {
            this.parent = parent;
        }
    }
}

