/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class VResetPassword
implements FormPanel,
ActionListener,
VetoableChangeListener {
    private static CLogger log = CLogger.getCLogger(VResetPassword.class);
    private FormFrame frame;
    private CPanel mainPanel;
    private ConfirmPanel confirmPanel;
    private CLabel lblUser;
    private CLabel lblOldPassword;
    private CLabel lblNewPassword;
    private CLabel lblRetypeNewPassword;
    private CLabel lblNewEMail;
    private CLabel lblRetypeNewEMail;
    private CLabel lblNewEMailUser;
    private CLabel lblNewEMailUserPW;
    private VLookup fUser;
    private JPasswordField txtOldPassword;
    private JPasswordField txtNewPassword;
    private JPasswordField txtRetypeNewPassword;
    private JTextField txtNewEMail;
    private JTextField txtRetypeNewEMail;
    private JTextField txtNewEMailUser;
    private JTextField txtNewEMailUserPW;
    public int windowNo = 0;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.windowNo = WindowNo;
        this.frame = frame;
        try {
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.confirmPanel, "South");
            this.confirmPanel.addActionListener(this);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "init", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        GridBagLayout panelLayout = new GridBagLayout();
        this.mainPanel.setLayout(panelLayout);
        this.mainPanel.add((Component)this.lblUser, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.fUser, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.mainPanel.add((Component)this.lblOldPassword, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.txtOldPassword, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.mainPanel.add((Component)this.lblNewPassword, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.txtNewPassword, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.mainPanel.add((Component)this.lblRetypeNewPassword, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.txtRetypeNewPassword, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.mainPanel.add((Component)this.lblNewEMail, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.txtNewEMail, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.mainPanel.add((Component)this.lblRetypeNewEMail, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.txtRetypeNewEMail, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.mainPanel.add((Component)this.lblNewEMailUser, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.txtNewEMailUser, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.mainPanel.add((Component)this.lblNewEMailUserPW, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.txtNewEMailUserPW, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.fUser.addVetoableChangeListener(this);
    }

    private void dynInit() {
        this.mainPanel = new CPanel();
        MLookup userLkp = MLookupFactory.get((Properties)Env.getCtx(), (int)this.windowNo, (int)0, (int)212, (int)30);
        this.fUser = new VLookup("AD_User_ID", false, false, true, (Lookup)userLkp);
        this.txtOldPassword = new JPasswordField();
        this.txtOldPassword.setName("txtOldPassword");
        this.txtNewPassword = new JPasswordField();
        this.txtNewPassword.setName("txtNewPassword");
        this.txtRetypeNewPassword = new JPasswordField();
        this.txtRetypeNewPassword.setName("txtRetypeNewPassword");
        this.txtNewEMail = new JTextField();
        this.txtNewEMail.setName("txtNewEMail");
        this.txtRetypeNewEMail = new JTextField();
        this.txtRetypeNewEMail.setName("txtRetypeNewEMail");
        this.txtNewEMailUser = new JTextField();
        this.txtNewEMailUser.setName("txtNewEMailUser");
        this.txtNewEMailUserPW = new JTextField();
        this.txtNewEMailUserPW.setName("txtNewEMailUserPW");
        this.lblUser = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"AD_User_ID"));
        this.lblUser.setRequestFocusEnabled(false);
        this.lblUser.setLabelFor(this.fUser);
        this.lblUser.setHorizontalAlignment(4);
        this.lblOldPassword = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Old Password"));
        this.lblOldPassword.setRequestFocusEnabled(false);
        this.lblOldPassword.setLabelFor(this.txtOldPassword);
        this.lblOldPassword.setHorizontalAlignment(4);
        this.lblNewPassword = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"New Password"));
        this.lblNewPassword.setRequestFocusEnabled(false);
        this.lblNewPassword.setLabelFor(this.txtNewPassword);
        this.lblNewPassword.setHorizontalAlignment(4);
        this.lblRetypeNewPassword = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"New Password Confirm"));
        this.lblRetypeNewPassword.setRequestFocusEnabled(false);
        this.lblRetypeNewPassword.setLabelFor(this.txtRetypeNewPassword);
        this.lblRetypeNewPassword.setHorizontalAlignment(4);
        this.lblNewEMail = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"New EMail"));
        this.lblNewEMail.setRequestFocusEnabled(false);
        this.lblNewEMail.setLabelFor(this.txtNewEMail);
        this.lblNewEMail.setHorizontalAlignment(4);
        this.lblRetypeNewEMail = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"New EMail Confirm"));
        this.lblRetypeNewEMail.setRequestFocusEnabled(false);
        this.lblRetypeNewEMail.setLabelFor(this.txtRetypeNewEMail);
        this.lblRetypeNewEMail.setHorizontalAlignment(4);
        this.lblNewEMailUser = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"New EMail User"));
        this.lblNewEMailUser.setRequestFocusEnabled(false);
        this.lblNewEMailUser.setLabelFor(this.txtNewEMailUser);
        this.lblNewEMailUser.setHorizontalAlignment(4);
        this.lblNewEMailUserPW = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"New EMail User Password"));
        this.lblNewEMailUserPW.setRequestFocusEnabled(false);
        this.lblNewEMailUserPW.setLabelFor(this.txtNewEMailUserPW);
        this.lblNewEMailUserPW.setHorizontalAlignment(4);
        this.confirmPanel = new ConfirmPanel();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        }
        if (e.getPropertyName().equals("AD_User_ID")) {
            this.fUser.setValue(e.getNewValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
        if (e.getActionCommand().equals("Ok")) {
            this.validateChangePassword();
        }
    }

    private void validateChangePassword() {
        int p_AD_User_ID = -1;
        if (this.fUser.getValue() != null) {
            p_AD_User_ID = Integer.parseInt(this.fUser.getValue().toString());
        }
        if (p_AD_User_ID < 0) {
            ADialog.error(this.windowNo, this.frame, "UserMandatory");
            return;
        }
        String p_OldPassword = new String(this.txtOldPassword.getPassword());
        String p_NewPassword = new String(this.txtNewPassword.getPassword());
        String p_NewPasswordConfirm = new String(this.txtRetypeNewPassword.getPassword());
        String p_NewEMail = this.txtNewEMail.getText();
        String p_NewEMailConfirm = this.txtRetypeNewEMail.getText();
        String p_NewEMailUser = this.txtNewEMailUser.getText();
        String p_NewEMailUserPW = this.txtNewEMailUserPW.getText();
        MUser user = MUser.get((Properties)Env.getCtx(), (int)p_AD_User_ID);
        if (log.isLoggable(Level.FINE)) {
            log.fine("User=" + user);
        }
        if (Util.isEmpty((String)p_OldPassword)) {
            MUser operator = MUser.get((Properties)Env.getCtx(), (int)Env.getAD_User_ID((Properties)Env.getCtx()));
            if (log.isLoggable(Level.FINE)) {
                log.fine("Operator=" + operator);
            }
            if (p_AD_User_ID == 0 || p_AD_User_ID == 100 || !operator.isAdministrator()) {
                ADialog.error(this.windowNo, this.frame, "OldPasswordMandatory");
                return;
            }
        } else {
            boolean hash_password = MSysConfig.getBooleanValue((String)"USER_PASSWORD_HASH", (boolean)false);
            if (hash_password) {
                if (!user.authenticateHash(p_OldPassword)) {
                    ADialog.error(this.windowNo, this.frame, "OldPasswordNoMatch");
                    return;
                }
            } else if (!p_OldPassword.equals(user.getPassword())) {
                ADialog.error(this.windowNo, this.frame, "OldPasswordNoMatch");
                return;
            }
            if (MSysConfig.getBooleanValue((String)"CHANGE_PASSWORD_MUST_DIFFER", (boolean)true) && p_OldPassword.equals(p_NewPassword)) {
                ADialog.error(this.windowNo, this.frame, "NewPasswordMustDiffer");
                return;
            }
        }
        if (Util.isEmpty((String)p_NewPasswordConfirm)) {
            ADialog.error(this.windowNo, this.frame, "NewPasswordConfirmMandatory");
            return;
        }
        if (!p_NewPassword.equals(p_NewPasswordConfirm)) {
            ADialog.error(this.windowNo, this.frame, "PasswordNotMatch");
            return;
        }
        if (!Util.isEmpty((String)p_NewEMailUserPW)) {
            if (Util.isEmpty((String)p_NewEMailConfirm)) {
                ADialog.error(this.windowNo, this.frame, "NewEmailConfirmMandatory");
                return;
            }
            if (!p_NewEMailUserPW.equals(p_NewEMailConfirm)) {
                ADialog.error(this.windowNo, this.frame, "NewEmailNotMatch");
                return;
            }
        }
        if (!Util.isEmpty((String)p_NewPassword)) {
            user.set_ValueOfColumn("Password", (Object)p_NewPassword);
        }
        if (!Util.isEmpty((String)p_NewEMail)) {
            user.setEMail(p_NewEMail);
        }
        if (!Util.isEmpty((String)p_NewEMailUser)) {
            user.setEMailUser(p_NewEMailUser);
        }
        if (!Util.isEmpty((String)p_NewEMailUserPW)) {
            user.setEMailUserPW(p_NewEMailUserPW);
        }
        try {
            user.saveEx();
        }
        catch (Exception e) {
            ADialog.error(this.windowNo, this.frame, e.getLocalizedMessage());
            user.load(user.get_TrxName());
            return;
        }
        this.clearForm();
        ADialog.info(this.windowNo, this.frame, "RecordSaved");
    }

    private void clearForm() {
        this.fUser.setValue(null);
        this.txtOldPassword.setText(null);
        this.txtNewPassword.setText(null);
        this.txtRetypeNewPassword.setText(null);
        this.txtNewEMail.setText(null);
        this.txtRetypeNewEMail.setText(null);
        this.txtNewEMailUser.setText(null);
        this.txtNewEMailUserPW.setText(null);
    }

    @Override
    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.frame = null;
    }
}

