/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.form.myJTree;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProduct;
import org.compiere.model.MProductBOM;
import org.compiere.model.MUOM;
import org.compiere.model.Query;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class VTreeBOM
extends CPanel
implements FormPanel,
ActionListener,
TreeSelectionListener {
    private static final long serialVersionUID = -4045195906352692040L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private myJTree m_tree;
    private static CLogger log = CLogger.getCLogger(VTreeBOM.class);
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private FlowLayout northLayout = new FlowLayout(2, 20, 5);
    private CPanel southPanel = new CPanel();
    private CPanel southPanel2 = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private FlowLayout southLayout2 = new FlowLayout();
    private CLabel labelProduct = new CLabel();
    private VLookup fieldProduct;
    private CCheckBox implosion = new CCheckBox();
    private CLabel treeInfo = new CLabel();
    private CLabel spacer = new CLabel();
    private JSplitPane splitPane = new JSplitPane();
    private JScrollPane dataPane = new JScrollPane();
    private JScrollPane treePane = new JScrollPane();
    private CCheckBox treeExpand = new CCheckBox();
    private CTextField treeSearch = new CTextField(10);
    private CLabel treeSearchLabel = new CLabel();
    private String m_search = "";
    private Enumeration<?> m_nodeEn;
    private DefaultMutableTreeNode m_selectedNode;
    private int m_selected_id = 0;
    private MouseListener mouseListener = new VTreeBOM_mouseAdapter(this);
    private KeyListener keyListener = new VTreeBOM_keyAdapter(this);
    private DefaultMutableTreeNode m_root = null;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    protected StatusBar statusBar = new StatusBar();
    private MiniTable tableBOM = new MiniTable();
    private Vector<Vector<Object>> dataBOM = new Vector();
    private Vector<String> columnNames;
    private final int DIVIDER_LOCATION = 300;
    private boolean reload = false;
    private Language language = Language.getLoginLanguage();
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mBOM;
    private CMenuItem mImplosion;
    private MLookup m_fieldProduct;

    public Properties getCtx() {
        return Env.getCtx();
    }

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        if (log.isLoggable(Level.INFO)) {
            log.info("VTreeBOM.init - WinNo=" + this.m_WindowNo);
        }
        try {
            this.preInit();
            this.jbInit();
            frame.getContentPane().add((Component)this, "Center");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "VTreeMaintenance.init", (Throwable)ex);
        }
    }

    private void preInit() throws Exception {
        this.m_fieldProduct = MLookupFactory.get((Properties)this.getCtx(), (int)this.m_WindowNo, (int)MColumn.getColumn_ID((String)"M_Product", (String)"M_Product_ID"), (int)30, (Language)this.language, (String)"M_Product_ID", (int)0, (boolean)false, (String)" M_Product.IsSummary = 'N'");
        this.fieldProduct = new VLookup("M_Product_ID", false, false, true, (Lookup)this.m_fieldProduct){
            private static final long serialVersionUID = 1084743143950828526L;

            @Override
            public void setValue(Object value) {
                super.setValue(value);
            }
        };
        this.implosion.addActionListener(this);
        this.splitPane.add((Component)this.dataPane, "right");
        this.splitPane.add((Component)this.treePane, "left");
    }

    private void loadTableBOM() {
        this.columnNames = new Vector(10);
        this.columnNames.add(Msg.getElement((Properties)this.getCtx(), (String)"IsActive"));
        this.columnNames.add(Msg.getElement((Properties)this.getCtx(), (String)"Line"));
        this.columnNames.add(Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID"));
        this.columnNames.add(Msg.getElement((Properties)this.getCtx(), (String)"C_UOM_ID"));
        this.columnNames.add(Msg.getElement((Properties)this.getCtx(), (String)"QtyBOM"));
        DefaultTableModel model = new DefaultTableModel(this.dataBOM, this.columnNames);
        this.tableBOM.setModel(model);
        this.tableBOM.setColumnClass(0, Boolean.class, true);
        this.tableBOM.setColumnClass(1, String.class, true);
        this.tableBOM.setColumnClass(2, KeyNamePair.class, true);
        this.tableBOM.setColumnClass(3, KeyNamePair.class, true);
        this.tableBOM.setColumnClass(4, BigDecimal.class, true);
        this.tableBOM.setMultiSelection(false);
        this.tableBOM.autoSize();
    }

    private void jbInit() {
        this.setLayout(this.mainLayout);
        this.setPreferredSize(new Dimension(640, 480));
        this.labelProduct.setText(Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID"));
        this.implosion.setText(Msg.getElement((Properties)this.getCtx(), (String)"Implosion"));
        this.treeInfo.setText("Selected Product: ");
        this.spacer.setText("     ");
        this.northPanel.setLayout(this.northLayout);
        this.northLayout.setAlignment(0);
        this.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.labelProduct, null);
        this.northPanel.add((Component)this.fieldProduct, null);
        this.northPanel.add((Component)this.implosion, null);
        this.northPanel.add((Component)this.spacer, null);
        this.northPanel.add((Component)this.spacer, null);
        this.northPanel.add((Component)this.treeInfo, null);
        this.treeExpand.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"ExpandTree"));
        this.treeExpand.setActionCommand("Expand");
        this.treeExpand.addMouseListener(this.mouseListener);
        this.treeExpand.addActionListener(this);
        this.treeSearchLabel.setText(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"TreeSearch")) + " ");
        this.treeSearchLabel.setLabelFor(this.treeSearch);
        this.treeSearchLabel.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"TreeSearchText"));
        this.treeSearch.setBackground(AdempierePLAF.getInfoBackground());
        this.treeSearch.addKeyListener(this.keyListener);
        this.add((Component)this.southPanel, "South");
        this.southPanel.setLayout(this.southLayout);
        this.confirmPanel.addActionListener(this);
        this.southPanel.add((Component)this.confirmPanel, "South");
        this.southPanel2.setLayout(this.southLayout2);
        this.southLayout2.setAlignment(0);
        this.southPanel.add((Component)this.southPanel2, "North");
        this.southPanel2.add((Component)this.treeExpand, null);
        this.southPanel2.add((Component)this.spacer, null);
        this.southPanel2.add((Component)this.treeSearchLabel, null);
        this.southPanel2.add((Component)this.treeSearch, null);
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setDividerLocation(300);
        this.mBOM = new CMenuItem(Msg.getMsg((Properties)Env.getCtx(), (String)"BOM"), Env.getImageIcon((String)"Detail16.gif"));
        this.mBOM.addActionListener(this);
        this.popupMenu.add(this.mBOM);
        this.mImplosion = new CMenuItem(Msg.getMsg((Properties)Env.getCtx(), (String)"Implosion"), Env.getImageIcon((String)"Parent16.gif"));
        this.mImplosion.addActionListener(this);
        this.popupMenu.add(this.mImplosion);
    }

    protected void keyPressed(KeyEvent e) {
        if (e.getSource() == this.treeSearch) {
            String search = this.treeSearch.getText();
            boolean found = false;
            if (this.m_nodeEn != null && !this.m_nodeEn.hasMoreElements()) {
                this.m_search = "";
            }
            if (!search.equals(this.m_search)) {
                this.m_nodeEn = this.m_root.preorderEnumeration();
                this.m_search = search;
            }
            while (!found && this.m_nodeEn != null && this.m_nodeEn.hasMoreElements()) {
                DefaultMutableTreeNode nd = (DefaultMutableTreeNode)this.m_nodeEn.nextElement();
                Vector nodeInfo = (Vector)nd.getUserObject();
                String uoName = ((KeyNamePair)nodeInfo.elementAt(2)).getName();
                if (uoName.toUpperCase().indexOf(search.toUpperCase()) == -1) continue;
                found = true;
                TreePath treePath = new TreePath(nd.getPath());
                this.m_tree.setSelectionPath(treePath);
                this.m_tree.makeVisible(treePath);
                this.m_tree.scrollPathToVisible(treePath);
            }
            if (!found) {
                ADialog.beep();
            }
        }
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mBOM) {
            this.fieldProduct.setValue(this.m_selected_id);
            if (this.implosion.isSelected()) {
                this.implosion.doClick();
            }
            this.action_loadBOM();
        }
        if (e.getSource() == this.mImplosion) {
            this.fieldProduct.setValue(this.m_selected_id);
            if (!this.implosion.isSelected()) {
                this.implosion.doClick();
            }
            this.action_loadBOM();
        }
        if (e.getActionCommand().equals("Ok") && (this.m_selected_id > 0 || this.getM_Product_ID() > 0)) {
            this.action_loadBOM();
        }
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getSource() instanceof JCheckBox && e.getActionCommand().equals("Expand")) {
            this.expandTree();
        }
    }

    private void action_loadBOM() {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        this.reload = false;
        int M_Product_ID = this.getM_Product_ID();
        if (M_Product_ID == 0) {
            return;
        }
        MProduct M_Product = MProduct.get((Properties)this.getCtx(), (int)M_Product_ID);
        this.treeInfo.setText("Selected Product: " + M_Product.getValue());
        Vector<Object> line = new Vector<Object>(10);
        line.add(new Boolean(M_Product.isActive()));
        line.add(new Integer(0).toString());
        KeyNamePair pp = new KeyNamePair(M_Product.getM_Product_ID(), M_Product.getValue().concat("_").concat(M_Product.getName()));
        line.add(pp);
        MUOM u = new MUOM(M_Product.getCtx(), M_Product.getC_UOM_ID(), M_Product.get_TrxName());
        KeyNamePair uom = new KeyNamePair(u.get_ID(), u.getUOMSymbol());
        line.add(uom);
        line.add(Env.ONE);
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(line);
        this.m_root = (DefaultMutableTreeNode)parent.getRoot();
        this.dataBOM.clear();
        if (this.isImplosion()) {
            for (MProductBOM bomline : this.getParentBOMs(M_Product_ID)) {
                this.addParent(bomline, parent);
            }
            this.m_tree = new myJTree(parent);
            this.m_tree.addMouseListener(this.mouseListener);
        } else {
            for (MProductBOM bom : this.getChildBOMs(M_Product_ID, true)) {
                this.addChild(bom, parent);
            }
            this.m_tree = new myJTree(parent);
            this.m_tree.addMouseListener(this.mouseListener);
        }
        this.m_tree.addTreeSelectionListener(this);
        this.treePane.getViewport().add((Component)this.m_tree, null);
        this.loadTableBOM();
        this.dataPane.getViewport().add((Component)this.tableBOM, null);
        this.splitPane.setDividerLocation(300);
        this.m_frame.setCursor(Cursor.getDefaultCursor());
    }

    private void action_reloadBOM() {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        this.reload = true;
        int M_Product_ID = this.m_selected_id;
        if (M_Product_ID == 0) {
            return;
        }
        MProduct M_Product = MProduct.get((Properties)this.getCtx(), (int)M_Product_ID);
        this.treeInfo.setText("Selected Product: " + M_Product.getValue());
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(this.productSummary(M_Product, false));
        this.dataBOM.clear();
        if (this.isImplosion()) {
            for (MProductBOM bomline : this.getParentBOMs(M_Product_ID)) {
                this.addParent(bomline, parent);
            }
        } else {
            for (MProductBOM bom : this.getChildBOMs(M_Product_ID, true)) {
                this.addChild(bom, parent);
            }
        }
        this.loadTableBOM();
        this.m_frame.setCursor(Cursor.getDefaultCursor());
    }

    public void addChild(MProductBOM bomline, DefaultMutableTreeNode parent) {
        MProduct M_Product = MProduct.get((Properties)this.getCtx(), (int)bomline.getM_ProductBOM_ID());
        Vector<Object> line = new Vector<Object>(10);
        line.add(new Boolean(bomline.isActive()));
        line.add(new Integer(bomline.getLine()).toString());
        KeyNamePair pp = new KeyNamePair(M_Product.getM_Product_ID(), M_Product.getValue().concat("_").concat(M_Product.getName()));
        line.add(pp);
        MUOM u = new MUOM(M_Product.getCtx(), M_Product.getC_UOM_ID(), M_Product.get_TrxName());
        KeyNamePair uom = new KeyNamePair(u.get_ID(), u.getUOMSymbol());
        line.add(uom);
        line.add(bomline.getBOMQty() != null ? bomline.getBOMQty() : Env.ZERO);
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(line);
        parent.add(child);
        if (this.m_selected_id == bomline.getM_Product_ID() || this.getM_Product_ID() == bomline.getM_Product_ID()) {
            this.dataBOM.add(line);
        }
        if (this.reload) {
            return;
        }
        for (MProductBOM bom : this.getChildBOMs(bomline.getM_ProductBOM_ID(), false)) {
            this.addChild(bom, child);
        }
    }

    public void addParent(MProductBOM bom, DefaultMutableTreeNode parent) {
        MProduct M_Product = MProduct.get((Properties)this.getCtx(), (int)bom.getM_Product_ID());
        Vector<Object> line = new Vector<Object>(10);
        line.add(new Boolean(M_Product.isActive()));
        line.add(new Integer(bom.getLine()).toString());
        KeyNamePair pp = new KeyNamePair(M_Product.getM_Product_ID(), M_Product.getValue().concat("_").concat(M_Product.getName()));
        line.add(pp);
        MUOM u = new MUOM(M_Product.getCtx(), M_Product.getC_UOM_ID(), M_Product.get_TrxName());
        KeyNamePair uom = new KeyNamePair(u.get_ID(), u.getUOMSymbol());
        line.add(uom);
        line.add(bom.getBOMQty() != null ? bom.getBOMQty() : Env.ZERO);
        if (this.m_selected_id == bom.getM_ProductBOM_ID() || this.getM_Product_ID() == bom.getM_ProductBOM_ID()) {
            this.dataBOM.add(line);
        }
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(line);
        parent.add(child);
        if (this.reload) {
            return;
        }
        for (MProductBOM bomline : this.getParentBOMs(bom.getM_Product_ID())) {
            this.addParent(bomline, child);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        this.m_selectedNode = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        if (this.m_selectedNode == null) {
            return;
        }
        Vector nodeInfo = (Vector)this.m_selectedNode.getUserObject();
        this.m_selected_id = ((KeyNamePair)nodeInfo.elementAt(2)).getKey();
        this.action_reloadBOM();
    }

    private void expandTree() {
        if (this.treeExpand.isSelected()) {
            int row = 0;
            while (row < this.m_tree.getRowCount()) {
                this.m_tree.expandRow(row);
                ++row;
            }
        } else {
            int row = this.m_tree.getRowCount();
            while (row > 0) {
                this.m_tree.collapseRow(row);
                --row;
            }
        }
    }

    public String productSummary(MProduct product, boolean isLeaf) {
        MUOM uom = MUOM.get((Properties)this.getCtx(), (int)product.getC_UOM_ID());
        String value = product.getValue();
        String name = product.get_Translation("Name");
        StringBuilder sb = new StringBuilder(value);
        if (name != null && !value.equals(name)) {
            sb.append("_").append(product.getName());
        }
        sb.append(" [").append(uom.get_Translation("UOMSymbol")).append("]");
        return sb.toString();
    }

    private boolean isImplosion() {
        return this.implosion.isSelected();
    }

    private int getM_Product_ID() {
        Integer Product = (Integer)this.fieldProduct.getValue();
        if (Product == null) {
            return 0;
        }
        return Product;
    }

    private List<MProductBOM> getChildBOMs(int M_Product_ID, boolean onlyActiveRecords) {
        String filter = "M_Product_ID=?" + (onlyActiveRecords ? " AND IsActive='Y'" : "");
        return new Query(this.getCtx(), "M_Product_BOM", filter, null).setParameters(new Object[]{M_Product_ID}).setOrderBy("Line").list();
    }

    private List<MProductBOM> getParentBOMs(int M_Product_ID) {
        String filter = "M_ProductBOM_ID=?";
        return new Query(this.getCtx(), "M_Product_BOM", filter, null).setParameters(new Object[]{M_Product_ID}).setOrderBy("M_Product_ID,Line").list();
    }

    class VTreeBOM_keyAdapter
    extends KeyAdapter {
        VTreeBOM m_adaptee;

        VTreeBOM_keyAdapter(VTreeBOM adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.m_adaptee.keyPressed(e);
            }
        }
    }

    final class VTreeBOM_mouseAdapter
    extends MouseAdapter {
        private VTreeBOM m_adaptee;

        VTreeBOM_mouseAdapter(VTreeBOM adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.m_adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            } else {
                this.m_adaptee.popupMenu.setVisible(false);
            }
        }
    }
}

