/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.AutoCompleteDocument;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.autocomplete.TextComponentAdaptor;

public class ADempiereAutoCompleteDecorator
extends AutoCompleteDecorator {
    static Object errorFeedbackAction = new TextAction("provide-error-feedback"){
        private static final long serialVersionUID = 6251452041316544686L;

        @Override
        public void actionPerformed(ActionEvent e) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.getTextComponent(e));
        }
    };

    public static void decorate(JTextComponent textComponent, List<?> items, boolean strictMatching) {
        ADempiereAutoCompleteDecorator.decorate(textComponent, items, strictMatching, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public static void decorate(JTextComponent textComponent, List<?> items, boolean strictMatching, ObjectToStringConverter stringConverter) {
        TextComponentAdaptor adaptor = new TextComponentAdaptor(textComponent, items);
        AutoCompleteDocument document = new AutoCompleteDocument((AbstractAutoCompleteAdaptor)adaptor, strictMatching, stringConverter);
        ADempiereAutoCompleteDecorator.decorate(textComponent, document, (AbstractAutoCompleteAdaptor)adaptor);
    }

    public static void decorate(JTextComponent textComponent, AutoCompleteDocument document, final AbstractAutoCompleteAdaptor adaptor) {
        textComponent.setDocument((Document)document);
        textComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextComponent textComponent = (JTextComponent)e.getSource();
                adaptor.markEntireText();
            }
        });
        InputMap editorInputMap = textComponent.getInputMap();
        if (document.isStrictMatching()) {
            editorInputMap.put(KeyStroke.getKeyStroke(8, 0), "selection-backward");
            editorInputMap.put(KeyStroke.getKeyStroke(127, 0), errorFeedbackAction);
            editorInputMap.put(KeyStroke.getKeyStroke(88, 128), errorFeedbackAction);
        } else {
            ActionMap editorActionMap = textComponent.getActionMap();
            editorInputMap.put(KeyStroke.getKeyStroke(8, 0), "nonstrict-backspace");
            editorActionMap.put("nonstrict-backspace", new NonStrictBackspaceAction(editorActionMap.get("delete-previous"), editorActionMap.get("selection-backward"), adaptor));
            editorInputMap.put(KeyStroke.getKeyStroke(9, 128), "NextMatchAction");
            editorActionMap.put("NextMatchAction", new NextMatchAction(textComponent, document, adaptor));
        }
    }

    static class NextMatchAction
    extends TextAction {
        private static final long serialVersionUID = 2987063701364646859L;
        JTextComponent textComponent;
        AutoCompleteDocument document;
        final AbstractAutoCompleteAdaptor adaptor;
        final List<String> items;
        int currentIndex = 0;

        public NextMatchAction(JTextComponent textComponent, AutoCompleteDocument document, AbstractAutoCompleteAdaptor adaptor) {
            super("NextMatchAction");
            this.textComponent = textComponent;
            this.document = document;
            this.adaptor = adaptor;
            this.items = new ArrayList<String>(adaptor.getItemCount());
            int i = 0;
            while (i < adaptor.getItemCount()) {
                Object o = adaptor.getItem(i);
                this.items.add(o != null ? (String)adaptor.getItem(i) : "");
                ++i;
            }
            Collections.sort(this.items);
        }

        private String getNextMatch(String start) {
            int i = this.currentIndex;
            while (i < this.items.size()) {
                if (this.items.get(i).toLowerCase().startsWith(start.toLowerCase())) {
                    this.currentIndex = i + 1;
                    return this.items.get(i);
                }
                ++i;
            }
            this.currentIndex = 0;
            return start;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null && e != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(target);
                    return;
                }
                String content = target.getText();
                if (content != null && target.getSelectionStart() > 0) {
                    content = content.substring(0, target.getSelectionStart());
                }
                if (content != null) {
                    target.setText(this.getNextMatch(content));
                    this.adaptor.markText(content.length());
                }
            }
        }
    }

    static class NonStrictBackspaceAction
    extends TextAction {
        private static final long serialVersionUID = 7260685268274438388L;
        Action backspace;
        Action selectionBackward;
        AbstractAutoCompleteAdaptor adaptor;

        public NonStrictBackspaceAction(Action backspace, Action selectionBackward, AbstractAutoCompleteAdaptor adaptor) {
            super("nonstrict-backspace");
            this.backspace = backspace;
            this.selectionBackward = selectionBackward;
            this.adaptor = adaptor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.adaptor.listContainsSelectedItem()) {
                this.selectionBackward.actionPerformed(e);
            } else {
                this.backspace.actionPerformed(e);
            }
        }
    }
}

