/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.adempiere.apps.graph.GraphUtil;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.grid.VTable;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;

public final class VCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 3135422746697244864L;
    private int m_displayType;
    private String m_columnName = null;
    private Lookup m_lookup = null;
    private boolean m_password = false;
    private SimpleDateFormat m_dateFormat = null;
    private DecimalFormat m_numberFormat = null;
    private JCheckBox m_check = null;
    private static CLogger log = CLogger.getCLogger(VCellRenderer.class);

    public VCellRenderer(GridField mField) {
        this(mField.getDisplayType());
        this.m_columnName = mField.getColumnName();
        this.setName(this.m_columnName);
        this.m_lookup = mField.getLookup();
        this.m_password = mField.isEncryptedField();
    }

    public VCellRenderer(int displayType) {
        this.m_displayType = displayType;
        if (DisplayType.isNumeric((int)this.m_displayType)) {
            this.m_numberFormat = DisplayType.getNumberFormat((int)this.m_displayType);
            this.setHorizontalAlignment(4);
        } else if (DisplayType.isDate((int)this.m_displayType)) {
            this.m_dateFormat = DisplayType.getDateFormat((int)this.m_displayType);
        } else if (this.m_displayType == 20) {
            this.m_check = new JCheckBox();
            this.m_check.setMargin(new Insets(0, 0, 0, 0));
            this.m_check.setHorizontalAlignment(0);
            this.m_check.setOpaque(true);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        boolean ro;
        Component c = null;
        if (this.m_displayType == 20) {
            c = this.m_check;
        } else {
            c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            c.setFont(table.getFont());
        }
        Color bg = AdempierePLAF.getFieldBackground_Normal();
        Color fg = AdempierePLAF.getTextColor_Normal();
        boolean bl = ro = !table.isCellEditable(row, col);
        if (ro) {
            bg = AdempierePLAF.getFieldBackground_Inactive();
            if (isSelected && !hasFocus) {
                bg = bg.darker();
            }
        }
        int cCode = 0;
        if (table instanceof VTable) {
            cCode = ((VTable)table).getColorCode(row);
        } else if (table instanceof MiniTable) {
            cCode = ((MiniTable)table).getColorCode(row);
        }
        if (cCode != 0) {
            fg = cCode < 0 ? AdempierePLAF.getTextColor_Issue() : AdempierePLAF.getTextColor_OK();
        }
        if (isSelected) {
            bg = table.getSelectionBackground();
            fg = table.getSelectionForeground();
            if (hasFocus) {
                bg = GraphUtil.brighter(bg, 0.9);
            }
        }
        c.setBackground(bg);
        c.setForeground(fg);
        this.setValue(value);
        return c;
    }

    @Override
    protected void setValue(Object value) {
        String retValue;
        block11: {
            retValue = null;
            try {
                if (this.m_displayType == 20) {
                    if (value instanceof Boolean) {
                        this.m_check.setSelected((Boolean)value);
                    } else {
                        this.m_check.setSelected("Y".equals(value));
                    }
                    return;
                }
                if (value == null) break block11;
                if (DisplayType.isNumeric((int)this.m_displayType)) {
                    retValue = value instanceof Number ? this.m_numberFormat.format(value) : value.toString();
                    break block11;
                }
                if (DisplayType.isDate((int)this.m_displayType)) {
                    retValue = value instanceof Date ? this.m_dateFormat.format(value) : value.toString();
                    break block11;
                }
                if (this.m_displayType == 26) {
                    retValue = "";
                    break block11;
                }
                if (this.m_lookup != null && (DisplayType.isLookup((int)this.m_displayType) || this.m_displayType == 21 || this.m_displayType == 25 || this.m_displayType == 31 || this.m_displayType == 35)) {
                    retValue = this.m_lookup.getDisplay(value);
                    break block11;
                }
                if (this.m_displayType == 28) {
                    retValue = "Record_ID".equals(this.m_columnName) ? "#" + value + "#" : null;
                    break block11;
                }
                if (this.m_password) {
                    retValue = "**********";
                    break block11;
                }
                super.setValue(value);
                return;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "(" + value + ") " + value.getClass().getName(), (Throwable)e);
                retValue = value.toString();
            }
        }
        super.setValue(retValue);
    }

    @Override
    public String toString() {
        return "VCellRenderer[" + this.m_columnName + ",DisplayType=" + this.m_displayType + " - " + this.m_lookup + "]";
    }

    public void dispose() {
        if (this.m_lookup != null) {
            this.m_lookup.dispose();
        }
        this.m_lookup = null;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public Lookup getLookup() {
        return this.m_lookup;
    }

    public int getDisplayType() {
        return this.m_displayType;
    }

    public boolean isPassword() {
        return this.m_password;
    }
}

