/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.model.MProduct;
import org.compiere.pos.AdempierePOSException;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ValueNamePair;

public class PosOrderModel
extends MOrder {
    private static final long serialVersionUID = 5253837037827124425L;
    private MPOS m_pos;
    private String trxName;

    public PosOrderModel(Properties ctx, int C_Order_ID, String trxName, MPOS pos) {
        super(ctx, C_Order_ID, trxName);
        this.trxName = trxName;
        this.m_pos = pos;
    }

    public static PosOrderModel createOrder(MPOS pos, MBPartner partner, String trxName) {
        PosOrderModel order = new PosOrderModel(Env.getCtx(), 0, trxName, pos);
        order.setAD_Org_ID(pos.getAD_Org_ID());
        order.setIsSOTrx(true);
        order.setC_POS_ID(pos.getC_POS_ID());
        if (pos.getC_DocType_ID() != 0) {
            order.setC_DocTypeTarget_ID(pos.getC_DocType_ID());
        } else {
            order.setC_DocTypeTarget_ID("WR");
        }
        if (partner == null || partner.get_ID() == 0) {
            partner = pos.getBPartner();
        }
        if (partner == null || partner.get_ID() == 0) {
            throw new AdempierePOSException("No BPartner for order");
        }
        order.setBPartner(partner);
        order.setM_PriceList_ID(pos.getM_PriceList_ID());
        order.setM_Warehouse_ID(pos.getM_Warehouse_ID());
        order.setSalesRep_ID(pos.getSalesRep_ID());
        order.setPaymentRule("B");
        if (!order.save()) {
            order = null;
            throw new AdempierePOSException("Save order failed");
        }
        return order;
    }

    public void setBPartner(MBPartner partner) {
        if (this.getDocStatus().equals("DR")) {
            if (partner == null || partner.get_ID() == 0) {
                throw new AdempierePOSException("no BPartner");
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("SubCurrentLine.getOrder -" + partner);
            }
            super.setBPartner(partner);
            MOrderLine[] lineas = this.getLines();
            int i = 0;
            while (i < lineas.length) {
                lineas[i].setC_BPartner_ID(partner.getC_BPartner_ID());
                lineas[i].setTax();
                lineas[i].saveEx();
                ++i;
            }
            this.saveEx();
        }
    }

    public MOrderLine createLine(MProduct product, BigDecimal QtyOrdered, BigDecimal PriceActual) {
        if (!this.getDocStatus().equals("DR")) {
            return null;
        }
        int numLines = 0;
        MOrderLine[] lines = null;
        try {
            lines = this.getLines(null, "Line");
            numLines = lines.length;
            int i = 0;
            while (i < numLines) {
                if (lines[i].getM_Product_ID() == product.getM_Product_ID()) {
                    BigDecimal current = lines[i].getQtyEntered();
                    BigDecimal toadd = QtyOrdered;
                    BigDecimal total = current.add(toadd);
                    lines[i].setQty(total);
                    lines[i].setPrice();
                    if (PriceActual.compareTo(Env.ZERO) > 0) {
                        lines[i].setPrice(PriceActual);
                    }
                    lines[i].saveEx();
                    return lines[i];
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.log.severe("Order lines cannot be created - " + e.getMessage());
        }
        MOrderLine line = new MOrderLine((MOrder)this);
        line.setProduct(product);
        line.setQty(QtyOrdered);
        line.setPrice();
        if (PriceActual.compareTo(Env.ZERO) > 0) {
            line.setPrice(PriceActual);
        }
        line.saveEx();
        return line;
    }

    public boolean deleteOrder() {
        if (this.getDocStatus().equals("DR")) {
            int numTax;
            MOrderTax[] taxs;
            int numLines;
            MOrderLine[] lines = this.getLines();
            if (lines != null && (numLines = lines.length) > 0) {
                int i = numLines - 1;
                while (i >= 0) {
                    if (lines[i] != null) {
                        this.deleteLine(lines[i].getC_OrderLine_ID());
                    }
                    --i;
                }
            }
            if ((taxs = this.getTaxes(true)) != null && (numTax = taxs.length) > 0) {
                int i = taxs.length - 1;
                while (i >= 0) {
                    if (taxs[i] != null) {
                        taxs[i].delete(true);
                    }
                    taxs[i].saveEx();
                    taxs[i] = null;
                    --i;
                }
            }
            this.getLines(true, null);
            this.setDocStatus("VO");
            this.setProcessed(true);
            this.saveEx();
            return true;
        }
        return false;
    }

    public void deleteLine(int C_OrderLine_ID) {
        if (C_OrderLine_ID != -1) {
            MOrderLine[] mOrderLineArray = this.getLines(true, "M_Product_ID");
            int n = mOrderLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                MOrderLine line = mOrderLineArray[n2];
                if (line.getC_OrderLine_ID() == C_OrderLine_ID) {
                    line.delete(true);
                    line.saveEx();
                }
                ++n2;
            }
        }
    }

    public boolean processOrder() {
        boolean orderCompleted;
        block13: {
            orderCompleted = false;
            if (this.getDocStatus().equals("DR") || this.getDocStatus().equals("IP")) {
                this.setDocAction("CO");
                try {
                    try {
                        if (this.processIt("CO")) {
                            this.saveEx();
                            break block13;
                        }
                        this.log.info("Process Order FAILED");
                    }
                    catch (Exception e) {
                        this.log.severe("Order can not be completed - " + e.getMessage());
                        if (this.getDocStatus().equals("IN")) {
                            this.setDocStatus("DR");
                            break block13;
                        }
                        if (this.getDocStatus().equals("CO")) {
                            orderCompleted = true;
                            this.log.info("SubCheckout - processOrder OK");
                            break block13;
                        }
                        this.log.info("SubCheckout - processOrder - unrecognized DocStatus");
                    }
                }
                finally {
                    if (this.getDocStatus().equals("IN")) {
                        this.setDocStatus("DR");
                    } else if (this.getDocStatus().equals("CO")) {
                        orderCompleted = true;
                        this.log.info("SubCheckout - processOrder OK");
                    } else {
                        this.log.info("SubCheckout - processOrder - unrecognized DocStatus");
                    }
                }
            }
        }
        return orderCompleted;
    }

    public BigDecimal getTaxAmt() {
        BigDecimal taxAmt = Env.ZERO;
        MOrderTax[] mOrderTaxArray = this.getTaxes(true);
        int n = mOrderTaxArray.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderTax tax = mOrderTaxArray[n2];
            taxAmt = taxAmt.add(tax.getTaxAmt());
            ++n2;
        }
        return taxAmt;
    }

    public BigDecimal getSubtotal() {
        return this.getGrandTotal().subtract(this.getTaxAmt());
    }

    public BigDecimal getPaidAmt() {
        BigDecimal cashline;
        String sql = "SELECT sum(PayAmt) FROM C_Payment WHERE C_Order_ID = ? AND DocStatus IN ('CO','CL')";
        BigDecimal received = DB.getSQLValueBD(null, (String)sql, (int)this.getC_Order_ID());
        if (received == null) {
            received = Env.ZERO;
        }
        if ((cashline = DB.getSQLValueBD(null, (String)(sql = "SELECT sum(Amount) FROM C_CashLine WHERE C_Invoice_ID = ? "), (int)this.getC_Invoice_ID())) != null) {
            received = received.add(cashline);
        }
        return received;
    }

    public boolean payCash(BigDecimal amt) {
        MPayment payment = this.createPayment("X");
        payment.setC_CashBook_ID(this.m_pos.getC_CashBook_ID());
        payment.setAmount(this.getC_Currency_ID(), amt);
        payment.setC_BankAccount_ID(this.m_pos.getC_BankAccount_ID());
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            return true;
        }
        return false;
    }

    public boolean payCheck(BigDecimal amt, String accountNo, String routingNo, String checkNo) {
        MPayment payment = this.createPayment("K");
        payment.setAmount(this.getC_Currency_ID(), amt);
        payment.setC_BankAccount_ID(this.m_pos.getC_BankAccount_ID());
        payment.setAccountNo(accountNo);
        payment.setRoutingNo(routingNo);
        payment.setCheckNo(checkNo);
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            return true;
        }
        return false;
    }

    public boolean payCreditCard(BigDecimal amt, String accountName, int month, int year, String cardNo, String cvc, String cardtype) {
        MPayment payment = this.createPayment("C");
        payment.setAmount(this.getC_Currency_ID(), amt);
        payment.setC_BankAccount_ID(this.m_pos.getC_BankAccount_ID());
        payment.setCreditCard("S", cardtype, cardNo, cvc, month, year);
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            return true;
        }
        return false;
    }

    private MPayment createPayment(String tenderType) {
        MPayment payment = new MPayment(this.getCtx(), 0, this.trxName);
        payment.setAD_Org_ID(this.m_pos.getAD_Org_ID());
        payment.setTenderType(tenderType);
        payment.setC_Order_ID(this.getC_Order_ID());
        payment.setIsReceipt(true);
        payment.setC_BPartner_ID(this.getC_BPartner_ID());
        return payment;
    }

    public void reload() {
        this.load(this.get_TrxName());
        this.getLines(true, "");
    }

    public ValueNamePair[] getCreditCards(BigDecimal amt) {
        try {
            MBankAccountProcessor[] m_mBankAccountProcessors = MBankAccountProcessor.find((Properties)this.getCtx(), null, null, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID(), (int)this.getC_Currency_ID(), (BigDecimal)amt, (String)this.get_TrxName());
            HashMap<String, ValueNamePair> map = new HashMap<String, ValueNamePair>();
            int i = 0;
            while (i < m_mBankAccountProcessors.length) {
                MBankAccountProcessor bankAccountProcessor = m_mBankAccountProcessors[i];
                if (bankAccountProcessor.isAcceptAMEX()) {
                    map.put("A", this.getCreditCardPair("A"));
                }
                if (bankAccountProcessor.isAcceptDiners()) {
                    map.put("D", this.getCreditCardPair("D"));
                }
                if (bankAccountProcessor.isAcceptDiscover()) {
                    map.put("N", this.getCreditCardPair("N"));
                }
                if (bankAccountProcessor.isAcceptMC()) {
                    map.put("M", this.getCreditCardPair("M"));
                }
                if (bankAccountProcessor.isAcceptCorporate()) {
                    map.put("P", this.getCreditCardPair("P"));
                }
                if (bankAccountProcessor.isAcceptVisa()) {
                    map.put("V", this.getCreditCardPair("V"));
                }
                ++i;
            }
            ValueNamePair[] retValue = new ValueNamePair[map.size()];
            map.values().toArray(retValue);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("getCreditCards - #" + retValue.length + " - Processors=" + m_mBankAccountProcessors.length);
            }
            return retValue;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private ValueNamePair getCreditCardPair(String CreditCardType) {
        return new ValueNamePair(CreditCardType, this.getCreditCardName(CreditCardType));
    }

    public String getCreditCardName(String CreditCardType) {
        if (CreditCardType == null) {
            return "--";
        }
        if ("M".equals(CreditCardType)) {
            return "MasterCard";
        }
        if ("V".equals(CreditCardType)) {
            return "Visa";
        }
        if ("A".equals(CreditCardType)) {
            return "Amex";
        }
        if ("C".equals(CreditCardType)) {
            return "ATM";
        }
        if ("D".equals(CreditCardType)) {
            return "Diners";
        }
        if ("N".equals(CreditCardType)) {
            return "Discover";
        }
        if ("P".equals(CreditCardType)) {
            return "PurchaseCard";
        }
        return "?" + CreditCardType + "?";
    }
}

