/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InOutGenerate
extends SvrProcess {
    private boolean p_Selection = false;
    private int p_M_Warehouse_ID = 0;
    private int p_C_BPartner_ID = 0;
    private Timestamp p_DatePromised = null;
    private boolean p_IsUnconfirmedInOut = false;
    private String p_docAction = "CO";
    private boolean p_ConsolidateDocument = true;
    private Timestamp p_DateShipped = null;
    private MInOut m_shipment = null;
    private int m_created = 0;
    private int m_line = 0;
    private Timestamp m_movementDate = null;
    private int m_lastC_BPartner_Location_ID = -1;
    private StringBuffer m_sql = null;
    private HashMap<SParameter, MStorageOnHand[]> m_map = new HashMap();
    private SParameter m_lastPP = null;
    private MStorageOnHand[] m_lastStorages = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Warehouse_ID")) {
                    this.p_M_Warehouse_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("DatePromised")) {
                    this.p_DatePromised = (Timestamp)para[i].getParameter();
                } else if (name.equals("Selection")) {
                    this.p_Selection = "Y".equals(para[i].getParameter());
                } else if (name.equals("IsUnconfirmedInOut")) {
                    this.p_IsUnconfirmedInOut = "Y".equals(para[i].getParameter());
                } else if (name.equals("ConsolidateDocument")) {
                    this.p_ConsolidateDocument = "Y".equals(para[i].getParameter());
                } else if (name.equals("DocAction")) {
                    this.p_docAction = (String)para[i].getParameter();
                } else if (name.equals("MovementDate")) {
                    this.p_DateShipped = (Timestamp)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            if (this.p_DateShipped == null) {
                this.m_movementDate = Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date");
                if (this.m_movementDate == null) {
                    this.m_movementDate = new Timestamp(System.currentTimeMillis());
                }
            } else {
                this.m_movementDate = this.p_DateShipped;
            }
            if (!"CO".equals(this.p_docAction)) {
                this.p_docAction = "PR";
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Selection=" + this.p_Selection + ", M_Warehouse_ID=" + this.p_M_Warehouse_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", Consolidate=" + this.p_ConsolidateDocument + ", IsUnconfirmed=" + this.p_IsUnconfirmedInOut + ", Movement=" + this.m_movementDate);
        }
        if (this.p_M_Warehouse_ID == 0) {
            throw new AdempiereUserError("@NotFound@ @M_Warehouse_ID@");
        }
        if (this.p_Selection) {
            this.m_sql = new StringBuffer("SELECT C_Order.* FROM C_Order, T_Selection ").append("WHERE C_Order.DocStatus='CO' AND C_Order.IsSOTrx='Y' AND C_Order.AD_Client_ID=? ").append("AND C_Order.C_Order_ID = T_Selection.T_Selection_ID ").append("AND T_Selection.AD_PInstance_ID=? ");
        } else {
            this.m_sql = new StringBuffer("SELECT * FROM C_Order o ").append("WHERE DocStatus='CO' AND IsSOTrx='Y'").append(" AND o.C_DocType_ID IN (SELECT C_DocType_ID FROM C_DocType ").append("WHERE DocBaseType='SOO' AND DocSubTypeSO NOT IN ('ON','OB','WR'))").append("\tAND o.IsDropShip='N'").append(" AND o.DeliveryRule<>'M'").append(" AND EXISTS (SELECT * FROM C_OrderLine ol ").append("WHERE ol.M_Warehouse_ID=?");
            if (this.p_DatePromised != null) {
                this.m_sql.append(" AND TRUNC(ol.DatePromised)<=?");
            }
            this.m_sql.append(" AND o.C_Order_ID=ol.C_Order_ID AND ol.QtyOrdered<>ol.QtyDelivered)");
            if (this.p_C_BPartner_ID != 0) {
                this.m_sql.append(" AND o.C_BPartner_ID=?");
            }
        }
        this.m_sql.append(" ORDER BY M_Warehouse_ID, PriorityRule, M_Shipper_ID, C_BPartner_ID, C_BPartner_Location_ID, C_Order_ID");
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)this.m_sql.toString(), (String)this.get_TrxName());
            int index = 1;
            if (this.p_Selection) {
                pstmt.setInt(index++, Env.getAD_Client_ID((Properties)this.getCtx()));
                pstmt.setInt(index++, this.getAD_PInstance_ID());
            } else {
                pstmt.setInt(index++, this.p_M_Warehouse_ID);
                if (this.p_DatePromised != null) {
                    pstmt.setTimestamp(index++, this.p_DatePromised);
                }
                if (this.p_C_BPartner_ID != 0) {
                    pstmt.setInt(index++, this.p_C_BPartner_ID);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, this.m_sql.toString(), (Throwable)e);
        }
        return this.generate((PreparedStatement)pstmt);
    }

    private String generate(PreparedStatement pstmt) {
        block43: {
            ResultSet rs = null;
            try {
                try {
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        BigDecimal toDeliver;
                        MOrderLine line;
                        MOrder order = new MOrder(this.getCtx(), rs, this.get_TrxName());
                        this.statusUpdate(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Processing")) + " " + order.getDocumentInfo());
                        if (!this.p_ConsolidateDocument || this.m_shipment != null && (this.m_shipment.getC_BPartner_Location_ID() != order.getC_BPartner_Location_ID() || this.m_shipment.getM_Shipper_ID() != order.getM_Shipper_ID())) {
                            this.completeShipment();
                        }
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("check: " + order + " - DeliveryRule=" + order.getDeliveryRule());
                        }
                        Timestamp minGuaranteeDate = this.m_movementDate;
                        boolean completeOrder = "O".equals(order.getDeliveryRule());
                        StringBuilder where = new StringBuilder(" AND M_Warehouse_ID=").append(this.p_M_Warehouse_ID);
                        if (this.p_DatePromised != null) {
                            where.append(" AND (TRUNC(DatePromised)<=").append(DB.TO_DATE((Timestamp)this.p_DatePromised, (boolean)true)).append(" OR DatePromised IS NULL)");
                        }
                        if (!"F".equals(order.getDeliveryRule())) {
                            where.append(" AND (C_OrderLine.M_Product_ID IS NULL").append(" OR EXISTS (SELECT * FROM M_Product p ").append("WHERE C_OrderLine.M_Product_ID=p.M_Product_ID").append(" AND IsExcludeAutoDelivery='N'))");
                        }
                        if (!this.p_IsUnconfirmedInOut) {
                            where.append(" AND NOT EXISTS (SELECT * FROM M_InOutLine iol").append(" INNER JOIN M_InOut io ON (iol.M_InOut_ID=io.M_InOut_ID) ").append("WHERE iol.C_OrderLine_ID=C_OrderLine.C_OrderLine_ID AND io.DocStatus IN ('IP','WC'))");
                        }
                        MOrderLine[] lines = order.getLines(where.toString(), "C_BPartner_Location_ID, M_Product_ID");
                        int i = 0;
                        while (i < lines.length) {
                            line = lines[i];
                            if (line.getM_Warehouse_ID() == this.p_M_Warehouse_ID) {
                                if (this.log.isLoggable(Level.FINE)) {
                                    this.log.fine("check: " + line);
                                }
                                BigDecimal onHand = Env.ZERO;
                                toDeliver = line.getQtyOrdered().subtract(line.getQtyDelivered());
                                MProduct product = line.getProduct();
                                if (!(product != null && toDeliver.signum() == 0 || line.getC_Charge_ID() != 0 && toDeliver.signum() == 0)) {
                                    BigDecimal unconfirmedShippedQty = Env.ZERO;
                                    if (this.p_IsUnconfirmedInOut && product != null && toDeliver.signum() != 0) {
                                        String where2 = "EXISTS (SELECT * FROM M_InOut io WHERE io.M_InOut_ID=M_InOutLine.M_InOut_ID AND io.DocStatus IN ('IP','WC'))";
                                        MInOutLine[] iols = MInOutLine.getOfOrderLine((Properties)this.getCtx(), (int)line.getC_OrderLine_ID(), (String)where2, null);
                                        int j = 0;
                                        while (j < iols.length) {
                                            unconfirmedShippedQty = unconfirmedShippedQty.add(iols[j].getMovementQty());
                                            ++j;
                                        }
                                        StringBuilder logInfo = new StringBuilder("Unconfirmed Qty=").append(unconfirmedShippedQty).append(" - ToDeliver=").append(toDeliver).append("->");
                                        toDeliver = toDeliver.subtract(unconfirmedShippedQty);
                                        logInfo.append(toDeliver);
                                        if (toDeliver.signum() < 0) {
                                            toDeliver = Env.ZERO;
                                            logInfo.append(" (set to 0)");
                                        }
                                        onHand = onHand.subtract(unconfirmedShippedQty);
                                        if (this.log.isLoggable(Level.FINE)) {
                                            this.log.fine(logInfo.toString());
                                        }
                                    }
                                    if (!(product != null && product.isStocked() || line.getQtyOrdered().signum() != 0 && toDeliver.signum() == 0)) {
                                        if (!"O".equals(order.getDeliveryRule())) {
                                            this.createLine(order, line, toDeliver, null, false);
                                        }
                                    } else {
                                        BigDecimal deliver;
                                        boolean fullLine;
                                        String MMPolicy = product.getMMPolicy();
                                        MStorageOnHand[] storages = this.getStorages(line.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy));
                                        int j = 0;
                                        while (j < storages.length) {
                                            MStorageOnHand storage = storages[j];
                                            onHand = onHand.add(storage.getQtyOnHand());
                                            ++j;
                                        }
                                        boolean bl = fullLine = onHand.compareTo(toDeliver) >= 0 || toDeliver.signum() < 0;
                                        if (completeOrder && !fullLine) {
                                            if (this.log.isLoggable(Level.FINE)) {
                                                this.log.fine("Failed CompleteOrder - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + " - " + line);
                                            }
                                            completeOrder = false;
                                            break;
                                        }
                                        if (fullLine && "L".equals(order.getDeliveryRule())) {
                                            if (this.log.isLoggable(Level.FINE)) {
                                                this.log.fine("CompleteLine - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + ", ToDeliver=" + toDeliver + " - " + line);
                                            }
                                            this.createLine(order, line, toDeliver, storages, false);
                                        } else if ("A".equals(order.getDeliveryRule()) && (onHand.signum() > 0 || toDeliver.signum() < 0)) {
                                            deliver = toDeliver;
                                            if (deliver.compareTo(onHand) > 0) {
                                                deliver = onHand;
                                            }
                                            if (this.log.isLoggable(Level.FINE)) {
                                                this.log.fine("Available - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + ", Delivering=" + deliver + " - " + line);
                                            }
                                            this.createLine(order, line, deliver, storages, false);
                                        } else if ("F".equals(order.getDeliveryRule())) {
                                            deliver = toDeliver;
                                            if (this.log.isLoggable(Level.FINE)) {
                                                this.log.fine("Force - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + ", Delivering=" + deliver + " - " + line);
                                            }
                                            this.createLine(order, line, deliver, storages, true);
                                        } else if ("M".equals(order.getDeliveryRule())) {
                                            if (this.log.isLoggable(Level.FINE)) {
                                                this.log.fine("Manual - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + ") - " + line);
                                            }
                                        } else if (this.log.isLoggable(Level.FINE)) {
                                            this.log.fine("Failed: " + order.getDeliveryRule() + " - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + " - " + line);
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                        if (completeOrder && "O".equals(order.getDeliveryRule())) {
                            i = 0;
                            while (i < lines.length) {
                                line = lines[i];
                                if (line.getM_Warehouse_ID() == this.p_M_Warehouse_ID) {
                                    MProduct product = line.getProduct();
                                    toDeliver = line.getQtyOrdered().subtract(line.getQtyDelivered());
                                    MStorageOnHand[] storages = null;
                                    if (product != null && product.isStocked()) {
                                        String MMPolicy = product.getMMPolicy();
                                        storages = this.getStorages(line.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy));
                                    }
                                    this.createLine(order, line, toDeliver, storages, false);
                                }
                                ++i;
                            }
                        }
                        this.m_line += 1000;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, this.m_sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block43;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.completeShipment();
        StringBuilder msgreturn = new StringBuilder("@Created@ = ").append(this.m_created);
        return msgreturn.toString();
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qty, MStorageOnHand[] storages, boolean force) {
        if (this.m_lastC_BPartner_Location_ID != orderLine.getC_BPartner_Location_ID()) {
            this.completeShipment();
        }
        this.m_lastC_BPartner_Location_ID = orderLine.getC_BPartner_Location_ID();
        if (this.m_shipment == null) {
            this.m_shipment = new MInOut(order, 0, this.m_movementDate);
            this.m_shipment.setM_Warehouse_ID(orderLine.getM_Warehouse_ID());
            if (order.getC_BPartner_ID() != orderLine.getC_BPartner_ID()) {
                this.m_shipment.setC_BPartner_ID(orderLine.getC_BPartner_ID());
            }
            if (order.getC_BPartner_Location_ID() != orderLine.getC_BPartner_Location_ID()) {
                this.m_shipment.setC_BPartner_Location_ID(orderLine.getC_BPartner_Location_ID());
            }
            if (!this.m_shipment.save()) {
                throw new IllegalStateException("Could not create Shipment");
            }
        }
        if (storages == null) {
            MInOutLine line = new MInOutLine(this.m_shipment);
            line.setOrderLine(orderLine, 0, Env.ZERO);
            line.setQty(qty);
            if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                line.setQtyEntered(qty.multiply(orderLine.getQtyEntered()).divide(orderLine.getQtyOrdered(), 12, 4));
            }
            line.setLine(this.m_line + orderLine.getLine());
            if (!line.save()) {
                throw new IllegalStateException("Could not create Shipment Line");
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(line.toString());
            }
            return;
        }
        ArrayList<MInOutLine> list = new ArrayList<MInOutLine>();
        BigDecimal toDeliver = qty;
        int i = 0;
        while (i < storages.length) {
            MStorageOnHand storage = storages[i];
            BigDecimal deliver = toDeliver;
            if (storage.getQtyOnHand().signum() >= 0) {
                if (deliver.compareTo(storage.getQtyOnHand()) > 0 && storage.getQtyOnHand().signum() >= 0 && (!force || force && i + 1 != storages.length)) {
                    deliver = storage.getQtyOnHand();
                }
                if (deliver.signum() != 0) {
                    int M_Locator_ID = storage.getM_Locator_ID();
                    MInOutLine line = null;
                    if (orderLine.getM_AttributeSetInstance_ID() == 0) {
                        int ll = 0;
                        while (ll < list.size()) {
                            MInOutLine test = (MInOutLine)list.get(ll);
                            if (test.getM_Locator_ID() == M_Locator_ID && test.getM_AttributeSetInstance_ID() == 0) {
                                line = test;
                                break;
                            }
                            ++ll;
                        }
                    }
                    if (line == null) {
                        line = new MInOutLine(this.m_shipment);
                        line.setOrderLine(orderLine, M_Locator_ID, order.isSOTrx() ? deliver : Env.ZERO);
                        line.setQty(deliver);
                        list.add(line);
                    } else {
                        line.setQty(line.getMovementQty().add(deliver));
                    }
                    if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                        line.setQtyEntered(line.getMovementQty().multiply(orderLine.getQtyEntered()).divide(orderLine.getQtyOrdered(), 12, 4));
                    }
                    line.setLine(this.m_line + orderLine.getLine());
                    if (!line.save()) {
                        throw new IllegalStateException("Could not create Shipment Line");
                    }
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("ToDeliver=" + qty + "/" + deliver + " - " + line);
                    }
                    toDeliver = toDeliver.subtract(deliver);
                    storage.setQtyOnHand(storage.getQtyOnHand().subtract(deliver));
                    if (toDeliver.signum() == 0) break;
                }
            }
            ++i;
        }
        if (toDeliver.signum() != 0) {
            if (!force) {
                throw new IllegalStateException("Not All Delivered - Remainder=" + toDeliver);
            }
            MInOutLine line = new MInOutLine(this.m_shipment);
            line.setOrderLine(orderLine, 0, order.isSOTrx() ? toDeliver : Env.ZERO);
            line.setQty(toDeliver);
            if (!line.save()) {
                throw new IllegalStateException("Could not create Shipment Line");
            }
        }
    }

    private MStorageOnHand[] getStorages(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp minGuaranteeDate, boolean FiFo) {
        this.m_lastPP = new SParameter(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, minGuaranteeDate, FiFo);
        this.m_lastStorages = this.m_map.get(this.m_lastPP);
        if (this.m_lastStorages == null) {
            this.m_lastStorages = MStorageOnHand.getWarehouse((Properties)this.getCtx(), (int)M_Warehouse_ID, (int)M_Product_ID, (int)M_AttributeSetInstance_ID, (Timestamp)minGuaranteeDate, (boolean)FiFo, (boolean)false, (int)0, (String)this.get_TrxName());
            this.m_map.put(this.m_lastPP, this.m_lastStorages);
        }
        return this.m_lastStorages;
    }

    private void completeShipment() {
        if (this.m_shipment != null) {
            if (!this.m_shipment.processIt(this.p_docAction)) {
                this.log.warning("Failed: " + this.m_shipment);
                throw new IllegalStateException("Shipment Process Failed: " + this.m_shipment + " - " + this.m_shipment.getProcessMsg());
            }
            this.m_shipment.saveEx();
            String message = Msg.parseTranslation((Properties)this.getCtx(), (String)("@ShipmentProcessed@ " + this.m_shipment.getDocumentNo()));
            this.addLog(this.m_shipment.getM_InOut_ID(), this.m_shipment.getMovementDate(), null, message, this.m_shipment.get_Table_ID(), this.m_shipment.getM_InOut_ID());
            ++this.m_created;
            this.m_map = new HashMap();
            this.m_lastPP = null;
            this.m_lastStorages = null;
        }
        this.m_shipment = null;
        this.m_line = 0;
    }

    static class SParameter {
        public int M_Warehouse_ID;
        public int M_Product_ID;
        public int M_AttributeSetInstance_ID;
        public int M_AttributeSet_ID;
        public boolean allAttributeInstances;
        public Timestamp minGuaranteeDate;
        public boolean FiFo;

        protected SParameter(int p_Warehouse_ID, int p_Product_ID, int p_AttributeSetInstance_ID, Timestamp p_minGuaranteeDate, boolean p_FiFo) {
            this.M_Warehouse_ID = p_Warehouse_ID;
            this.M_Product_ID = p_Product_ID;
            this.M_AttributeSetInstance_ID = p_AttributeSetInstance_ID;
            this.minGuaranteeDate = p_minGuaranteeDate;
            this.FiFo = p_FiFo;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof SParameter) {
                boolean eq;
                SParameter cmp = (SParameter)obj;
                boolean bl = eq = cmp.M_Warehouse_ID == this.M_Warehouse_ID && cmp.M_Product_ID == this.M_Product_ID && cmp.M_AttributeSetInstance_ID == this.M_AttributeSetInstance_ID && cmp.M_AttributeSet_ID == this.M_AttributeSet_ID && cmp.allAttributeInstances == this.allAttributeInstances && cmp.FiFo == this.FiFo;
                if (!(!eq || cmp.minGuaranteeDate == null && this.minGuaranteeDate == null || cmp.minGuaranteeDate != null && this.minGuaranteeDate != null && cmp.minGuaranteeDate.equals(this.minGuaranteeDate))) {
                    eq = false;
                }
                return eq;
            }
            return false;
        }

        public int hashCode() {
            long hash = this.M_Warehouse_ID + this.M_Product_ID * 2 + this.M_AttributeSetInstance_ID * 3 + this.M_AttributeSet_ID * 4;
            if (this.allAttributeInstances) {
                hash *= -1L;
            }
            if (this.FiFo) {
                hash *= -2L;
            }
            if (hash < 0L) {
                hash = -hash + 7L;
            }
            while (hash > Integer.MAX_VALUE) {
                hash -= Integer.MAX_VALUE;
            }
            if (this.minGuaranteeDate != null) {
                hash += (long)this.minGuaranteeDate.hashCode();
                while (hash > Integer.MAX_VALUE) {
                    hash -= Integer.MAX_VALUE;
                }
            }
            return (int)hash;
        }
    }
}

