/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MRfQResponseLine;
import org.compiere.model.MRfQResponseLineQty;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class RfQCreatePO
extends SvrProcess {
    private int p_C_RfQ_ID = 0;
    private int p_C_DocType_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_C_RfQ_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MRfQ rfq = new MRfQ(this.getCtx(), this.p_C_RfQ_ID, this.get_TrxName());
        if (rfq.get_ID() == 0) {
            throw new IllegalArgumentException("No RfQ found");
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(rfq.toString());
        }
        MRfQResponse[] responses = rfq.getResponses(true, true);
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("#Responses=" + responses.length);
        }
        if (responses.length == 0) {
            throw new IllegalArgumentException("No completed RfQ Responses found");
        }
        int i = 0;
        while (i < responses.length) {
            MRfQResponse response = responses[i];
            if (response.isSelectedWinner()) {
                MBPartner bp = new MBPartner(this.getCtx(), response.getC_BPartner_ID(), this.get_TrxName());
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Winner=" + bp);
                }
                MOrder order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                order.setIsSOTrx(false);
                if (this.p_C_DocType_ID != 0) {
                    order.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
                } else {
                    order.setC_DocTypeTarget_ID();
                }
                order.setBPartner(bp);
                order.setC_BPartner_Location_ID(response.getC_BPartner_Location_ID());
                order.setSalesRep_ID(rfq.getSalesRep_ID());
                if (response.getDateWorkComplete() != null) {
                    order.setDatePromised(response.getDateWorkComplete());
                } else if (rfq.getDateWorkComplete() != null) {
                    order.setDatePromised(rfq.getDateWorkComplete());
                }
                order.saveEx();
                MRfQResponseLine[] lines = response.getLines(false);
                int j = 0;
                while (j < lines.length) {
                    MRfQResponseLine line = lines[j];
                    if (line.isActive()) {
                        MRfQResponseLineQty[] qtys = line.getQtys(false);
                        int k = 0;
                        while (k < qtys.length) {
                            MRfQResponseLineQty qty = qtys[k];
                            if (qty.getRfQLineQty().isActive() && qty.getRfQLineQty().isPurchaseQty()) {
                                MOrderLine ol = new MOrderLine(order);
                                ol.setM_Product_ID(line.getRfQLine().getM_Product_ID(), qty.getRfQLineQty().getC_UOM_ID());
                                ol.setDescription(line.getDescription());
                                ol.setQty(qty.getRfQLineQty().getQty());
                                BigDecimal price = qty.getNetAmt();
                                ol.setPrice();
                                ol.setPrice(price);
                                ol.saveEx();
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                response.setC_Order_ID(order.getC_Order_ID());
                response.saveEx();
                return order.getDocumentNo();
            }
            ++i;
        }
        int noOrders = 0;
        int i2 = 0;
        while (i2 < responses.length) {
            MRfQResponse response = responses[i2];
            MBPartner bp = null;
            MOrder order = null;
            MRfQResponseLine[] lines = response.getLines(false);
            int j = 0;
            while (j < lines.length) {
                MRfQResponseLine line = lines[j];
                if (line.isActive() && line.isSelectedWinner()) {
                    if (bp == null || bp.getC_BPartner_ID() != response.getC_BPartner_ID()) {
                        bp = new MBPartner(this.getCtx(), response.getC_BPartner_ID(), this.get_TrxName());
                        order = null;
                    }
                    if (this.log.isLoggable(Level.CONFIG)) {
                        this.log.config("Line=" + line + ", Winner=" + bp);
                    }
                    if (order == null) {
                        order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                        order.setIsSOTrx(false);
                        order.setC_DocTypeTarget_ID();
                        order.setBPartner(bp);
                        order.setC_BPartner_Location_ID(response.getC_BPartner_Location_ID());
                        order.setSalesRep_ID(rfq.getSalesRep_ID());
                        order.saveEx();
                        ++noOrders;
                        this.addLog(0, null, null, order.getDocumentNo());
                    }
                    MRfQResponseLineQty[] qtys = line.getQtys(false);
                    int k = 0;
                    while (k < qtys.length) {
                        MRfQResponseLineQty qty = qtys[k];
                        if (qty.getRfQLineQty().isActive() && qty.getRfQLineQty().isPurchaseQty()) {
                            MOrderLine ol = new MOrderLine(order);
                            ol.setM_Product_ID(line.getRfQLine().getM_Product_ID(), qty.getRfQLineQty().getC_UOM_ID());
                            ol.setDescription(line.getDescription());
                            ol.setQty(qty.getRfQLineQty().getQty());
                            BigDecimal price = qty.getNetAmt();
                            ol.setPrice();
                            ol.setPrice(price);
                            ol.saveEx();
                        }
                        ++k;
                    }
                }
                ++j;
            }
            if (order != null) {
                response.setC_Order_ID(order.getC_Order_ID());
                response.saveEx();
            }
            ++i2;
        }
        StringBuilder msgreturn = new StringBuilder("#").append(noOrders);
        return msgreturn.toString();
    }
}

