/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.db.postgresql.config;

import java.net.InetAddress;
import java.sql.Connection;
import java.util.logging.Level;
import org.adempiere.install.DBConfigStatus;
import org.adempiere.install.IDBConfigMonitor;
import org.adempiere.install.IDatabaseConfig;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.Database;
import org.compiere.install.ConfigurationData;
import org.compiere.util.CLogger;

public class ConfigPostgreSQL
implements IDatabaseConfig {
    private static final CLogger log = CLogger.getCLogger(ConfigPostgreSQL.class);
    private String[] p_discovered = null;
    private AdempiereDatabase p_db = Database.getDatabase((String)Database.DB_POSTGRESQL);

    public void init(ConfigurationData configurationData) {
        configurationData.setDatabasePort(String.valueOf(5432));
        configurationData.setDatabaseName("idempiere");
    }

    public String[] discoverDatabases(String selected) {
        if (this.p_discovered != null) {
            return this.p_discovered;
        }
        this.p_discovered = new String[0];
        return this.p_discovered;
    }

    public String test(IDBConfigMonitor monitor, ConfigurationData data) {
        String server = data.getDatabaseServer();
        boolean pass = server != null && server.length() > 0;
        String error = "Not correct: DB Server = " + server;
        InetAddress databaseServer = null;
        try {
            if (pass) {
                databaseServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = String.valueOf(error) + " - " + e.getMessage();
            pass = false;
        }
        if (monitor != null) {
            monitor.update(new DBConfigStatus("DATABASE_SERVER", "ErrorDatabaseServer", pass, true, error));
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: Database Server = " + databaseServer);
        }
        data.setProperty("ADEMPIERE_DB_SERVER", databaseServer != null ? databaseServer.getHostName() : null);
        data.setProperty("ADEMPIERE_DB_TYPE", data.getDatabaseType());
        data.setProperty("ADEMPIERE_DB_PATH", data.getDatabaseType().toLowerCase());
        int databasePort = data.getDatabasePort();
        pass = data.testPort(databaseServer, databasePort, true);
        error = "DB Server Port = " + databasePort;
        if (monitor != null) {
            monitor.update(new DBConfigStatus("DATABASE_SERVER", "ErrorDatabasePort", pass, true, error));
        }
        if (!pass) {
            return error;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: Database Port = " + databasePort);
        }
        data.setProperty("ADEMPIERE_DB_PORT", String.valueOf(databasePort));
        boolean isDBExists = data.getDatabaseExists();
        String databaseName = data.getDatabaseName();
        String systemPassword = data.getDatabaseSystemPassword();
        String urlSystem = this.p_db.getConnectionURL(databaseServer.getHostName(), databasePort, this.p_db.getSystemDatabase(databaseName), this.p_db.getSystemUser());
        pass = this.testJDBC(urlSystem, this.p_db.getSystemUser(), systemPassword);
        error = "Error connecting: " + urlSystem + " - " + this.p_db.getSystemUser() + "/" + systemPassword;
        if (monitor != null) {
            monitor.update(new DBConfigStatus("DATABASE_SYSTEM_PASSWORD", "ErrorJDBC", pass, true, error));
        }
        if (!pass) {
            if (isDBExists) {
                log.warning(error);
            } else {
                return error;
            }
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: System Connection = " + urlSystem);
        }
        data.setProperty("ADEMPIERE_DB_SYSTEM", systemPassword);
        String databaseUser = data.getDatabaseUser();
        String databasePassword = data.getDatabasePassword();
        String url = this.p_db.getConnectionURL(databaseServer.getHostName(), databasePort, databaseName, databaseUser);
        pass = this.testJDBC(url, databaseUser, databasePassword);
        error = "Database imported? Cannot connect to User: " + databaseUser + "/" + databasePassword;
        if (monitor != null) {
            monitor.update(new DBConfigStatus("DATABASE_USER", "ErrorJDBC", pass, true, error));
        }
        if (pass) {
            if (log.isLoggable(Level.INFO)) {
                log.info("OK: Database User = " + databaseUser);
            }
        } else {
            if (isDBExists) {
                return error;
            }
            log.warning(error);
        }
        data.setProperty("ADEMPIERE_DB_URL", url);
        data.setProperty("ADEMPIERE_DB_NAME", databaseName);
        data.setProperty("ADEMPIERE_DB_USER", databaseUser);
        data.setProperty("ADEMPIERE_DB_PASSWORD", databasePassword);
        data.setProperty("ADEMPIERE_DB_EXISTS", isDBExists ? "Y" : "N");
        return null;
    }

    private boolean testJDBC(String url, String uid, String pwd) {
        try {
            Connection conn = this.p_db.getDriverConnection(url, uid, pwd);
        }
        catch (Exception e) {
            log.severe(e.toString());
            return false;
        }
        return true;
    }

    public String getDatabaseName(String nativeConnectioName) {
        return nativeConnectioName;
    }

    public String getName() {
        return Database.DB_POSTGRESQL;
    }
}

