/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public abstract class CreateFromBatch
extends CreateFrom {
    public CreateFromBatch(GridTab gridTab) {
        super(gridTab);
    }

    public String getSQLWhere(Object BPartner, String DocumentNo, Object DateFrom, Object DateTo, Object AmtFrom, Object AmtTo, Object DocType, Object TenderType, String AuthCode) {
        Comparable<BigDecimal> to;
        Comparable<BigDecimal> from;
        StringBuilder sql = new StringBuilder();
        sql.append("WHERE p.Processed='Y' AND p.IsReconciled='N'");
        sql.append(" AND p.DocStatus IN ('CO','CL','RE','VO') AND p.PayAmt<>0");
        sql.append(" AND p.C_BankAccount_ID = ?");
        sql.append(" AND NOT EXISTS (SELECT * FROM C_BankStatementLine l WHERE p.C_Payment_ID=l.C_Payment_ID AND l.StmtAmt <> 0)");
        if (DocType != null) {
            sql.append(" AND p.C_DocType_ID=?");
        }
        if (TenderType != null && TenderType.toString().length() > 0) {
            sql.append(" AND p.TenderType=?");
        }
        if (BPartner != null) {
            sql.append(" AND p.C_BPartner_ID=?");
        }
        if (DocumentNo.length() > 0) {
            sql.append(" AND UPPER(p.DocumentNo) LIKE ?");
        }
        if (AuthCode.length() > 0) {
            sql.append(" AND p.R_AuthCode LIKE ?");
        }
        if (AmtFrom != null || AmtTo != null) {
            from = (BigDecimal)AmtFrom;
            to = (BigDecimal)AmtTo;
            if (from == null && to != null) {
                sql.append(" AND p.PayAmt <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND p.PayAmt >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND p.PayAmt BETWEEN ? AND ?");
            }
        }
        if (DateFrom != null || DateTo != null) {
            from = (Timestamp)DateFrom;
            to = (Timestamp)DateTo;
            if (from == null && to != null) {
                sql.append(" AND TRUNC(p.DateTrx) <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(p.DateTrx) >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(p.DateTrx) BETWEEN ? AND ?");
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(sql.toString());
        }
        return sql.toString();
    }

    void setParameters(PreparedStatement pstmt, Object BankAccount, Object BPartner, String DocumentNo, Object DateFrom, Object DateTo, Object AmtFrom, Object AmtTo, Object DocType, Object TenderType, String AuthCode) throws SQLException {
        Comparable<BigDecimal> to;
        Comparable<BigDecimal> from;
        int index = 1;
        pstmt.setInt(index++, BankAccount != null ? (Integer)BankAccount : (Integer)this.getGridTab().getValue("C_BankAccount_ID"));
        if (DocType != null) {
            pstmt.setInt(index++, (Integer)DocType);
        }
        if (TenderType != null && TenderType.toString().length() > 0) {
            pstmt.setString(index++, (String)TenderType);
        }
        if (BPartner != null) {
            pstmt.setInt(index++, (Integer)BPartner);
        }
        if (DocumentNo.length() > 0) {
            pstmt.setString(index++, this.getSQLText(DocumentNo));
        }
        if (AuthCode.length() > 0) {
            pstmt.setString(index++, this.getSQLText(AuthCode));
        }
        if (AmtFrom != null || AmtTo != null) {
            from = (BigDecimal)AmtFrom;
            to = (BigDecimal)AmtTo;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Amt From=" + from + ", To=" + to);
            }
            if (from == null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            } else if (from != null && to == null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
            } else if (from != null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            }
        }
        if (DateFrom != null || DateTo != null) {
            from = (Timestamp)DateFrom;
            to = (Timestamp)DateTo;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Date From=" + from + ", To=" + to);
            }
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
                pstmt.setTimestamp(index++, (Timestamp)to);
            }
        }
    }

    private String getSQLText(String text) {
        String s = text.toUpperCase();
        if (!s.endsWith("%")) {
            s = String.valueOf(s) + "%";
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("String=" + s);
        }
        return s;
    }

    protected abstract Vector<Vector<Object>> getBankAccountData(Object var1, Object var2, String var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, String var10);

    @Override
    public void info(IMiniTable miniTable, IStatusBar statusBar) {
        DecimalFormat format = DisplayType.getNumberFormat((int)12);
        BigDecimal total = Env.ZERO;
        int rows = miniTable.getRowCount();
        int count = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                total = total.add((BigDecimal)miniTable.getValueAt(i, 4));
                ++count;
            }
            ++i;
        }
        statusBar.setStatusLine(String.valueOf(String.valueOf(count)) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"Sum") + "  " + format.format(total));
    }
}

