/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.iconlabel;

import java.awt.Graphics2D;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.export.GenericElementGraphics2DHandler;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterContext;
import net.sf.jasperreports.engine.export.draw.FrameDrawer;
import net.sf.jasperreports.engine.export.draw.Offset;
import net.sf.jasperreports.engine.export.draw.TextDrawer;

public class IconLabelElementGraphics2DHandler
implements GenericElementGraphics2DHandler {
    private static final IconLabelElementGraphics2DHandler INSTANCE = new IconLabelElementGraphics2DHandler();

    public static IconLabelElementGraphics2DHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void exportElement(JRGraphics2DExporterContext exporterContext, JRGenericPrintElement element, Graphics2D grx, Offset offset) {
        try {
            JRPrintText labelPrintText = (JRPrintText)element.getParameterValue("labelTextElement");
            if (labelPrintText == null) {
                return;
            }
            JRGraphics2DExporter exporter = (JRGraphics2DExporter)exporterContext.getExporter();
            JRBasePrintFrame frame = new JRBasePrintFrame(element.getDefaultStyleProvider());
            frame.setX(element.getX());
            frame.setY(element.getY());
            frame.setWidth(element.getWidth());
            frame.setHeight(element.getHeight());
            frame.setBackcolor(element.getBackcolor());
            frame.setForecolor(element.getForecolor());
            frame.setMode(element.getModeValue());
            FrameDrawer frameDrawer = exporter.getFrameDrawer();
            frameDrawer.draw(grx, frame, offset.getX(), offset.getY());
            TextDrawer textDrawer = exporter.getFrameDrawer().getDrawVisitor().getTextDrawer();
            textDrawer.draw(grx, labelPrintText, offset.getX() + element.getX(), offset.getY() + element.getY());
            JRGenericPrintElement iconGenericElement = (JRGenericPrintElement)element.getParameterValue("iconGenericElement");
            JRPrintText iconPrintText = (JRPrintText)iconGenericElement.getParameterValue("iconTextElement");
            if (iconPrintText != null) {
                textDrawer.draw(grx, iconPrintText, offset.getX() + element.getX(), offset.getY() + element.getY());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }
}

