/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.web.servlets.AbstractServlet;
import net.sf.jasperreports.web.util.ContentTypeMapping;
import net.sf.jasperreports.web.util.DefaultWebResourceHandler;
import net.sf.jasperreports.web.util.WebResourceHandler;
import net.sf.jasperreports.web.util.WebUtil;

public class ResourceServlet
extends AbstractServlet {
    private static final long serialVersionUID = 10200L;

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        WebUtil webUtil = WebUtil.getInstance(this.getJasperReportsContext());
        String resource = webUtil.getResourceUri(request);
        WebResourceHandler webResourceHandler = null;
        List<WebResourceHandler> resourceHandlers = this.getJasperReportsContext().getExtensions(WebResourceHandler.class);
        if (resourceHandlers != null) {
            for (WebResourceHandler handler : resourceHandlers) {
                if (!handler.hadlesResource(resource)) continue;
                webResourceHandler = handler;
                break;
            }
        }
        if (webResourceHandler == null) {
            webResourceHandler = DefaultWebResourceHandler.getInstance();
        }
        byte[] bytes = webResourceHandler.getData(resource, request, this.getJasperReportsContext());
        String resourceType = webResourceHandler.getResourceType(resource);
        if (resourceType != null) {
            List<ContentTypeMapping> contentTypeMappings = this.getJasperReportsContext().getExtensions(ContentTypeMapping.class);
            for (ContentTypeMapping contentTypeMapping : contentTypeMappings) {
                if (!resourceType.equals(contentTypeMapping.getFileType())) continue;
                response.setContentType(contentTypeMapping.getContentType());
                break;
            }
        }
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.getOutputStream().write(bytes);
    }
}

