/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.dbPort;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.pool.OracleDataSource;

public class JdbcTest
extends Thread {
    private static final int NUM_OF_THREADS = 10;
    private static final String DRIVER = "thin";
    private static final String CONNECTION = "jdbc:oracle:thin:@//dev:1521/dev1";
    private static final String UID = "adempiere";
    private static final String PWD = "adempiere";
    private static final String STATEMENT = "SELECT * FROM AD_Column";
    private static final boolean WITH_OUTPUT = false;
    private static boolean s_do_yield = true;
    private static Connection s_sconn = null;
    private static Connection[] s_conn = null;
    private static OracleDataSource s_ds = null;
    private static int s_fetchSize = 10;
    private static int s_cType = 0;
    private static final String[] C_INFO = new String[]{"Shared Connection    ", "Multiple Connections ", "Multiple PreCreated  ", "Data Source          ", "Connection Cache     "};
    private static final int C_SHARED = 0;
    private static final int C_MULTIPLE = 1;
    private static final int C_PRECREATED = 2;
    private static final int C_DATASOURCE = 3;
    private static final int C_CACHE = 4;
    private int m_myId = 0;
    static boolean greenLight = false;

    public static void main(String[] args) {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            s_ds = new OracleDataSource();
            s_ds.setDriverType(DRIVER);
            s_ds.setServerName("dev");
            s_ds.setNetworkProtocol("tcp");
            s_ds.setDatabaseName("dev1");
            s_ds.setPortNumber(1521);
            s_ds.setUser("adempiere");
            s_ds.setPassword("adempiere");
            s_fetchSize = 10;
            s_cType = 1;
            JdbcTest.statementTiming();
            JdbcTest.statementTiming();
            JdbcTest.statementTiming();
            s_cType = 3;
            JdbcTest.statementTiming();
            JdbcTest.statementTiming();
            JdbcTest.statementTiming();
            s_cType = 4;
            JdbcTest.statementTiming();
            JdbcTest.statementTiming();
            JdbcTest.statementTiming();
            s_fetchSize = 20;
            s_cType = 1;
            JdbcTest.statementTiming();
            JdbcTest.statementTiming();
            JdbcTest.statementTiming();
            s_cType = 3;
            JdbcTest.statementTiming();
            JdbcTest.statementTiming();
            JdbcTest.statementTiming();
            s_cType = 4;
            JdbcTest.statementTiming();
            JdbcTest.statementTiming();
            JdbcTest.statementTiming();
            s_fetchSize = 10;
            s_cType = 0;
            s_do_yield = false;
            JdbcTest.runTest();
            JdbcTest.runTest();
            s_do_yield = true;
            JdbcTest.runTest();
            JdbcTest.runTest();
            s_cType = 1;
            s_do_yield = false;
            JdbcTest.runTest();
            JdbcTest.runTest();
            s_do_yield = true;
            JdbcTest.runTest();
            JdbcTest.runTest();
            s_cType = 2;
            s_do_yield = false;
            JdbcTest.runTest();
            JdbcTest.runTest();
            s_do_yield = true;
            JdbcTest.runTest();
            JdbcTest.runTest();
            s_cType = 3;
            s_do_yield = false;
            JdbcTest.runTest();
            JdbcTest.runTest();
            s_do_yield = true;
            JdbcTest.runTest();
            JdbcTest.runTest();
            s_cType = 4;
            s_do_yield = false;
            JdbcTest.runTest();
            JdbcTest.runTest();
            s_do_yield = true;
            JdbcTest.runTest();
            JdbcTest.runTest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void runTest() throws Exception {
        Thread[] threadList = new Thread[10];
        s_conn = new Connection[10];
        if (s_cType == 0) {
            s_sconn = DriverManager.getConnection(CONNECTION, "adempiere", "adempiere");
        }
        int i = 0;
        while (i < 10) {
            if (s_cType == 2) {
                JdbcTest.s_conn[i] = DriverManager.getConnection(CONNECTION, "adempiere", "adempiere");
            }
            threadList[i] = new JdbcTest(i);
            threadList[i].start();
            ++i;
        }
        long start = System.currentTimeMillis();
        JdbcTest.setGreenLight();
        int i2 = 0;
        while (i2 < 10) {
            threadList[i2].join();
            ++i2;
        }
        if (s_sconn != null) {
            s_sconn.close();
        }
        s_sconn = null;
        i2 = 0;
        while (i2 < 10) {
            if (s_conn[i2] != null) {
                s_conn[i2].close();
            }
            JdbcTest.s_conn[i2] = null;
            ++i2;
        }
        long result = System.currentTimeMillis() - start;
        System.out.print(String.valueOf(C_INFO[s_cType]) + "Threads=" + 10 + " \tYield=" + s_do_yield + " \tms= " + result + " \teach= " + result / 10L);
        System.out.println();
    }

    private static void statementTiming() {
        try {
            long startConnection = System.currentTimeMillis();
            Connection conn = null;
            if (s_cType == 1) {
                conn = DriverManager.getConnection(CONNECTION, "adempiere", "adempiere");
            }
            if (s_cType == 3) {
                conn = s_ds.getConnection();
            }
            long startStatement = System.currentTimeMillis();
            Statement stmt = conn.createStatement();
            stmt.setFetchSize(s_fetchSize);
            long startQuery = System.currentTimeMillis();
            ResultSet rs = stmt.executeQuery(STATEMENT);
            long startRetrieve = System.currentTimeMillis();
            while (rs.next()) {
                rs.getString(1);
            }
            long endRetrieve = System.currentTimeMillis();
            rs.close();
            rs = null;
            long endQuery = System.currentTimeMillis();
            stmt.close();
            stmt = null;
            long endStatement = System.currentTimeMillis();
            conn.close();
            conn = null;
            long endConnection = System.currentTimeMillis();
            System.out.println(String.valueOf(C_INFO[s_cType]) + "Fetch=" + s_fetchSize + " \tConn=" + (startStatement - startConnection) + " \tStmt=" + (startQuery - startStatement) + " \tQuery=" + (startRetrieve - startQuery) + " \tRetrieve=" + (endRetrieve - startRetrieve) + " \tClRs=" + (endQuery - endRetrieve) + " \tClStmt=" + (endStatement - endQuery) + " \tClConn=" + (endConnection - endStatement) + " \t- Total=" + (endConnection - startConnection) + " \tStmt=" + (endStatement - startStatement) + " \tQuery=" + (endQuery - startQuery));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public JdbcTest(int id) {
        this.m_myId = id;
    }

    @Override
    public void run() {
        ResultSet rs = null;
        Statement stmt = null;
        try {
            while (!this.getGreenLight()) {
                JdbcTest.yield();
            }
            if (s_cType == 0) {
                stmt = s_sconn.createStatement();
            } else if (s_cType == 1) {
                JdbcTest.s_conn[this.m_myId] = DriverManager.getConnection(CONNECTION, "adempiere", "adempiere");
                stmt = s_conn[this.m_myId].createStatement();
            } else if (s_cType == 2) {
                stmt = s_conn[this.m_myId].createStatement();
            } else if (s_cType == 3) {
                JdbcTest.s_conn[this.m_myId] = s_ds.getConnection();
                stmt = s_conn[this.m_myId].createStatement();
            }
            stmt.setFetchSize(s_fetchSize);
            rs = stmt.executeQuery(STATEMENT);
            while (rs.next()) {
                if (!s_do_yield) continue;
                JdbcTest.yield();
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            if (s_cType != 0 && s_cType != 2) {
                s_conn[this.m_myId].close();
                JdbcTest.s_conn[this.m_myId] = null;
            }
        }
        catch (Exception e) {
            System.out.println("Thread " + this.m_myId + " got Exception: " + e);
            e.printStackTrace();
            return;
        }
    }

    static synchronized void setGreenLight() {
        greenLight = true;
    }

    synchronized boolean getGreenLight() {
        return greenLight;
    }
}

