/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs.xml;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.xml.PI;
import org.apache.ecs.xml.XML;

public class XMLDocument
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2777290564966686983L;
    private static final float DEFAULT_XML_VERSION = 1.0f;
    private String versionDecl;
    private Vector<Object> prolog = new Vector(2);
    private XML content;
    private String codeset = null;

    public XMLDocument() {
        this(1.0, true);
    }

    public XMLDocument(double version) {
        this(version, true);
    }

    public XMLDocument(double version, boolean standalone) {
        StringBuilder versionStr = new StringBuilder();
        versionStr.append("<?xml version=\"");
        versionStr.append(version);
        versionStr.append("\" standalone=\"");
        if (standalone) {
            versionStr.append("yes\"?>");
        } else {
            versionStr.append("no\"?>\n");
        }
        this.versionDecl = versionStr.toString();
    }

    public XMLDocument(double version, boolean standalone, String codeset) {
        this(version, standalone);
        this.setCodeset(codeset);
    }

    public void setCodeset(String codeset) {
        this.codeset = codeset;
    }

    public String getCodeset() {
        return this.codeset;
    }

    public XMLDocument addStylesheet(String href, String type) {
        PI pi = new PI();
        pi.setTarget("xml-stylesheet").addInstruction("href", href).addInstruction("type", type);
        this.prolog.addElement(pi);
        return this;
    }

    public XMLDocument addStylesheet(String href) {
        return this.addStylesheet(href, "text/xsl");
    }

    public XMLDocument addToProlog(ConcreteElement element) {
        this.prolog.addElement(element);
        return this;
    }

    public XMLDocument addElement(XML element) {
        if (this.content == null) {
            this.content = element;
        } else {
            this.content.addElement(element);
        }
        return this;
    }

    public void output(OutputStream out) {
        try {
            out.write(this.versionDecl.getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int i2 = 0;
        while (i2 < this.prolog.size()) {
            ConcreteElement e = (ConcreteElement)this.prolog.elementAt(i2);
            e.output(out);
            ++i2;
        }
        if (this.content != null) {
            this.content.output(out);
        }
    }

    public void output(PrintWriter out) {
        out.write(this.versionDecl);
        int i2 = 0;
        while (i2 < this.prolog.size()) {
            ConcreteElement e = (ConcreteElement)this.prolog.elementAt(i2);
            e.output(out);
            ++i2;
        }
        if (this.content != null) {
            this.content.output(out);
        }
    }

    public final String toString() {
        StringBuilder retVal = new StringBuilder();
        if (this.codeset != null) {
            int i2 = 0;
            while (i2 < this.prolog.size()) {
                ConcreteElement e = (ConcreteElement)this.prolog.elementAt(i2);
                retVal.append(String.valueOf(e.toString(this.getCodeset())) + "\n");
                ++i2;
            }
            if (this.content != null) {
                retVal.append(this.content.toString(this.getCodeset()));
            }
        } else {
            int i3 = 0;
            while (i3 < this.prolog.size()) {
                ConcreteElement e = (ConcreteElement)this.prolog.elementAt(i3);
                retVal.append(String.valueOf(e.toString()) + "\n");
                ++i3;
            }
            if (this.content != null) {
                retVal.append(this.content.toString());
            }
        }
        return String.valueOf(this.versionDecl) + retVal.toString();
    }

    public final String toString(String codeset) {
        StringBuilder retVal = new StringBuilder();
        int i2 = 0;
        while (i2 < this.prolog.size()) {
            ConcreteElement e = (ConcreteElement)this.prolog.elementAt(i2);
            retVal.append(String.valueOf(e.toString(this.getCodeset())) + "\n");
            ++i2;
        }
        if (this.content != null) {
            retVal.append(String.valueOf(this.content.toString(this.getCodeset())) + "\n");
        }
        return String.valueOf(this.versionDecl) + retVal.toString();
    }

    public Object clone() {
        return this.content.clone();
    }
}

