/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.CommonTranslationHandler;
import org.compiere.model.MMessage;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Message;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MessageElementHandler
extends AbstractElementHandler {
    private List<Integer> messages = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        MMessage mMessage = (MMessage)this.findPO(ctx, element);
        if (mMessage == null) {
            mMessage = new MMessage(ctx.ctx, 0, this.getTrxName(ctx));
        }
        PoFiller filler = new PoFiller(ctx, (PO)mMessage, element, (AbstractElementHandler)this);
        List excludes = this.defaultExcludeList("AD_Message");
        if (this.messages.contains(mMessage.getAD_Message_ID())) {
            element.skip = true;
            return;
        }
        List notfounds = filler.autoFill(excludes);
        if (notfounds.size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        element.recordId = mMessage.getAD_Message_ID();
        if (!mMessage.is_new()) {
            if (!mMessage.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Message", 109);
        String action = null;
        if (!mMessage.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Message", (PO)mMessage);
            action = "Update";
        } else {
            action = "New";
        }
        if (mMessage.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, mMessage.getValue(), mMessage.get_ID(), action);
            this.messages.add(mMessage.getAD_Message_ID());
            element.recordId = mMessage.getAD_Message_ID();
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, mMessage.getValue(), mMessage.get_ID(), action);
        throw new POSaveFailedException("Failed to save message " + mMessage.getValue());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        block4: {
            int AD_Message_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Message_ID");
            if (ctx.packOut.isExported("AD_Message_ID|" + AD_Message_ID)) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            X_AD_Message m_Message = new X_AD_Message(ctx.ctx, AD_Message_ID, null);
            if (!this.isPackOutElement(ctx, (PO)m_Message)) {
                return;
            }
            this.verifyPackOutRequirement((PO)m_Message);
            this.addTypeName(atts, "table");
            document.startElement("", "", "AD_Message", atts);
            this.createMessageBinding(ctx, document, m_Message);
            PackOut packOut = ctx.packOut;
            packOut.getCtx().ctx.put("Table_Name", "AD_Message");
            try {
                new CommonTranslationHandler().packOut(packOut, document, null, m_Message.get_ID());
            }
            catch (Exception e) {
                if (!this.log.isLoggable(Level.INFO)) break block4;
                this.log.info(e.toString());
            }
        }
        document.endElement("", "", "AD_Message");
    }

    private void createMessageBinding(PIPOContext ctx, TransformerHandler document, X_AD_Message m_Message) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Message);
        if (m_Message.getAD_Message_ID() <= 999999) {
            filler.add("AD_Message_ID", new AttributesImpl());
        }
        List excludes = this.defaultExcludeList("AD_Message");
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Message_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Message_ID");
    }
}

