### /filter/crop.py

import wx
from gui.imageimport import *

from obj.objImage  import objImage
from obj.objFilter import objFilter
from obj.objGrid   import grid

from getInput import *
from setOutput import *

### properties
### ["crop",box = (x1,y1,x2,y2)]

class get_properties_crop:
	def __init__(self,obj):
		if len(obj.properties) == 2:
			self.box = obj.properties[1]
		else:
			self.box = (0,0,1,1)

def crop(obj):
	if len(obj.datainput) < 1:
		obj.dataoutput = None
		return 

	p = get_properties_crop(obj)
	if   isinstance(obj.datainput[0], Image.Image):
		obj.dataoutput = obj.datainput[0].crop(p.box)
	elif isinstance(obj.datainput[0], grid):
		obj.dataoutput = obj.datainput[0].crop(p.box)
		obj.dataoutput.makePIL()
	else:
		obj.dataoutput = None
	
class cropUI:
	def __init__(self,panel,obj):
		# take properties
		self.obj = obj
		self.p = get_properties_crop(self.obj)
		self.panel = panel
		getInput(self.obj, self.panel.frame)
		
		if len(self.obj.datainput) < 1:
			self.panel.frame.Close(True)
		else:
			self.gui()
			
	def gui(self):
		d = 160
		# make pil_input_thumbnail picture and wxinput
		if   isinstance(self.obj.datainput[0], Image.Image):
			self.datainputh = self.obj.datainput[0].copy().resize((d,d))
		elif isinstance(self.obj.datainput[0], grid):
			self.datainputh = self.obj.datainput[0].pil.copy().resize((d,d))
		self.datainputh.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxinput = wx.EmptyImage(self.datainputh.size[0], self.datainputh.size[1])
		self.wxinput.SetData(self.datainputh.convert('RGB').tostring())
		
		# make dataoutput's copy
		if self.obj.dataoutput == None:
			if   isinstance(self.obj.datainput[0], Image.Image):
				self.obj.dataoutput = self.obj.datainput[0].copy().resize((d,d))
			elif isinstance(self.obj.datainput[0], grid):
				self.obj.dataoutput = self.obj.datainput[0].pil.copy().resize((d,d))
		
		# make pil_output_thumbnail picture and wxoutput
		
		if   isinstance(self.obj.dataoutput, Image.Image):
			self.dataoutputh = self.obj.dataoutput.copy().resize((d,d))
		elif isinstance(self.obj.dataoutput, grid):
			self.dataoutputh = self.obj.dataoutput.pil.copy().resize((d,d))
			
		self.dataoutputh.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxoutput = wx.EmptyImage(self.dataoutputh.size[0], self.dataoutputh.size[1])
		self.wxoutput.SetData(self.dataoutputh.convert('RGB').tostring())
		
		# make gui
		self.panel.frame.SetSize((386,300))
		
		TopSize = wx.BoxSizer()
		self.wxginput = wx.StaticBitmap(self.panel, -1, self.wxinput.ConvertToBitmap(),	\
					   (self.wxinput.GetWidth(), self.wxinput.GetHeight()))
		self.wxgoutput = wx.StaticBitmap(self.panel, -1, self.wxoutput.ConvertToBitmap(), \
					   (self.wxoutput.GetWidth(), self.wxoutput.GetHeight()))
		TopSize.Add(self.wxginput,0,wx.FIXED_MINSIZE | wx.BOTTOM, 10)
		TopSize.Add(wx.DefaultSize,1,wx.EXPAND)
		TopSize.Add(self.wxgoutput,0,wx.FIXED_MINSIZE | wx.ALIGN_RIGHT, 10)
		
		
		MiddleSize = wx.BoxSizer()
		self.LabelX1 = wx.StaticText(self.panel, -1," x1  ")
		self.TextX1 = wx.TextCtrl(self.panel, -1, "0", size = (64,wx.DefaultSize[1]))
		self.panel.Bind(wx.EVT_TEXT, self.OnTextX1, self.TextX1)
		self.LabelY1 = wx.StaticText(self.panel, -1," y1  ")
		self.TextY1 = wx.TextCtrl(self.panel, -1, "0", size = (64,wx.DefaultSize[1]))
		self.panel.Bind(wx.EVT_TEXT, self.OnTextX1, self.TextY1)
		self.LabelX2 = wx.StaticText(self.panel, -1," x2  ")
		self.TextX2 = wx.TextCtrl(self.panel, -1, "0", size = (64,wx.DefaultSize[1]))
		self.panel.Bind(wx.EVT_TEXT, self.OnTextX1, self.TextX2)
		self.LabelY2 = wx.StaticText(self.panel, -1," y2  ")
		self.TextY2 = wx.TextCtrl(self.panel, -1, "0", size = (64,wx.DefaultSize[1]))
		self.panel.Bind(wx.EVT_TEXT, self.OnTextX1, self.TextY2)
		
		MiddleSize.Add(self.LabelX1,0,wx.FIXED_MINSIZE , 10)
		MiddleSize.Add(self.TextX1,0,wx.FIXED_MINSIZE , 10)
		MiddleSize.Add(self.LabelY1,0,wx.FIXED_MINSIZE , 10)
		MiddleSize.Add(self.TextY1,0,wx.FIXED_MINSIZE , 10)
		MiddleSize.Add(self.LabelX2,0,wx.FIXED_MINSIZE , 10)
		MiddleSize.Add(self.TextX2,0,wx.FIXED_MINSIZE , 10)
		MiddleSize.Add(self.LabelY2,0,wx.FIXED_MINSIZE , 10)
		MiddleSize.Add(self.TextY2,0,wx.FIXED_MINSIZE , 10)
		MiddleSize.Add(wx.DefaultSize, 1, wx.EXPAND)
		
		ButtonRefresh = wx.Button(self.panel, -1, "Refresh")
		self.panel.Bind(wx.EVT_BUTTON, self.ImageRefresh, ButtonRefresh)
		
		BottomSize = wx.BoxSizer()
		ButtonClose = wx.Button(self.panel, -1, "Close")
		self.panel.Bind(wx.EVT_BUTTON, self.OnCloseMe, ButtonClose)
		
		BottomSize.Add(ButtonRefresh,0,wx.FIXED_MINSIZE , 10)
		BottomSize.Add(wx.DefaultSize, 1, wx.EXPAND)
		BottomSize.Add(ButtonClose,0,wx.FIXED_MINSIZE | wx.ALIGN_RIGHT, 10)
		
		MainSize = wx.BoxSizer(wx.VERTICAL)
		MainSize.Add(TopSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 10)
		MainSize.Add(MiddleSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 10)
		MainSize.Add(BottomSize, 0, wx.EXPAND | wx.ALL , 10)
		
		self.panel.SetSizer(MainSize)
		self.SetValueUI()
	def SetValueUI(self):
		self.TextX1.SetValue(str(self.p.box[0]))
		self.TextY1.SetValue(str(self.p.box[1]))
		self.TextX2.SetValue(str(self.p.box[2]))
		self.TextY2.SetValue(str(self.p.box[3]))
	def SetValueObj(self):
		self.p.box =\
			(int(self.TextX1.GetValue()), \
			 int(self.TextY1.GetValue()), \
			 int(self.TextX2.GetValue()), \
			 int(self.TextY2.GetValue()), \
			)
		self.obj.properties = ['crop', self.p.box]
	def OnTextX1(self, e):
		if self.TextX1.GetValue()!="":
			i = int(self.TextX1.GetValue())
			box = self.p.box
			box = (i, box[1],box[2],box[3])
			self.p.box = box
	def OnTextY1(self, e):
		if self.TextX1.GetValue()!="":
			i = int(self.TextX1.GetValue())
			box = self.p.box
			box = (box[0], i,box[2],box[3])
			self.p.box = box
	def OnTextX2(self, e):
		if self.TextX1.GetValue()!="":
			i = int(self.TextX1.GetValue())
			box = self.p.box
			box = (box[0], box[1],i, box[3])
			self.p.box = box
	def OnTextY2(self, e):
		if self.TextX1.GetValue()!="":
			i = int(self.TextX1.GetValue())
			box = self.p.box
			box = (box[0], box[1],box[2],i)
			self.p.box = box
	def ImageRefresh(self ,e = None):
		d = 160
		# make dataoutput with PIL function "crop"
		self.SetValueObj()
		self.dataoutput = crop(self.obj)
		
		# make pil_output_thumbnail picture and wxoutput
		if   isinstance(self.obj.datainput[0], Image.Image):
			self.dataoutputh = self.obj.dataoutput.copy().resize((d,d))
		elif isinstance(self.obj.datainput[0], grid):
			self.dataoutputh = self.obj.dataoutput.pil.copy().resize((d,d))
		self.dataoutputh.thumbnail((d,d),Image.ANTIALIAS)
			
		self.wxoutput = wx.EmptyImage(self.dataoutputh.size[0], self.dataoutputh.size[1])
		self.wxoutput.SetData(self.dataoutputh.convert('RGB').tostring())
		
		# refresh!
		self.wxgoutput.SetBitmap(self.wxoutput.ConvertToBitmap())
	def OnCloseMe(self,e):
		# make shape's bitmap
		self.obj.PreviewBitmap()
		setOutput(self.obj,self.panel.frame)
		# dismiss
		self.panel.frame.Close(True)
