### /filter/i2g.py

import wx
from gui.imageimport import *
from conv.pixel	import ImageThreshold

from obj.objImage  import objImage
from obj.objFilter import objFilter
from obj.objGrid   import grid
from gui.colorPanel import *

from getInput import *
from setOutput import *
### properties
### ["i2g",l(tuplet for music convert),s(for swap)]


def i2g(obj):
	# swap
	if len(obj.datainput) == 2:
		if len(obj.properties) == 3:
			if obj.properties[2] == 1:
				obj.datainput[0],obj.datainput[1] = \
					obj.datainput[1],obj.datainput[0]
	i2gconv(obj)
	
def i2gconv(obj):
	obj.dataoutput = grid()
	if len(obj.properties) == 3:
		l = obj.properties[1]
		s = obj.properties[2]
	else:
		l = (1,1)
		s = 0
		
	if len(obj.datainput) > 0:
		obj.properties = ["i2g",l,s]
		# 
		obj.dataoutput.l = l
		if   len(obj.datainput) == 2:
			obj.dataoutput.setData(obj.datainput[0],obj.datainput[1])
		elif len(obj.datainput) == 1:
			w = obj.datainput[0].size[0]
			h = obj.datainput[0].size[1]
			
			obj.dataoutput.setData(obj.datainput[0], Image.new('1', (w, h), 255))

class i2gUI:
	def __init__(self,panel,obj):
		# take properties
		self.obj = obj
		if len(self.obj.properties) > 1:
			self.l = self.obj.properties[1]
			self.l_old = self.l
		else:
			self.l = (1,1)
			self.l_old = (0,1) 		# impossible number makes change in OnCloseMe
		if len(self.obj.properties) > 2:
			self.s = self.obj.properties[2]
		else:
			self.s = 0
		
		self.panel = panel
		
		getInput(self.obj,self.panel.frame)
		
		if len(self.obj.datainput) < 1:
			self.panel.frame.Close(True)
		else:
			# make gui
			self.gui()
	def swap(self,e):
		if len(self.obj.datainput) > 1:
			if self.s == 1:
				self.s = 0
			else:
				self.s = 1
			
			self.obj.datainput[0],self.obj.datainput[1] = \
				self.obj.datainput[1],self.obj.datainput[0]
			self.ImageRefresh()
	def gui(self):	# make panel
		d = 160
		
		# make data_image_thumbnail picture and wxinput
		self.dataimageth = self.obj.datainput[0].copy()
		self.dataimageth.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wximageth = wx.EmptyImage(self.dataimageth.size[0], self.dataimageth.size[1])
		self.wximageth.SetData(self.dataimageth.convert('RGB').tostring())
		
		# make data_bond_thumbnail picture and wxinput
		if len(self.obj.datainput) > 1:
			self.databondth = \
				ImageThreshold(self.obj.datainput[1].copy()).resize \
					((self.dataimageth.size[0], self.dataimageth.size[1]))
			self.databondth.thumbnail((d,d),Image.ANTIALIAS)
		else:
			self.databondth = \
				Image.new('1',(self.dataimageth.size[0], self.dataimageth.size[1]),1)
			self.databondth.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxbondth = wx.EmptyImage(self.databondth.size[0], self.databondth.size[1])
		self.wxbondth.SetData(self.databondth.convert('RGB').tostring())
		
		# gui
		self.panel.frame.SetSize((386,250))
		
		TopSize = wx.BoxSizer()
		self.wxgimage = wx.StaticBitmap(self.panel, -1, self.wximageth.ConvertToBitmap(),	\
					   (self.wximageth.GetWidth(), self.wximageth.GetHeight()))
		self.wxgbond = wx.StaticBitmap(self.panel, -1, self.wxbondth.ConvertToBitmap(), \
					   (self.wxbondth.GetWidth(), self.wxbondth.GetHeight()))
		
		TopSize.Add(self.wxgimage,0,wx.EXPAND | wx.BOTTOM, 10)
		TopSize.Add((-1,d),1,wx.EXPAND | wx.BOTTOM, 10)
		TopSize.Add(self.wxgbond,0,wx.EXPAND | wx.ALIGN_RIGHT, 10)
		
		#---
		
		ButtonSwap = wx.Button(self.panel, -1, "Swap")
		self.panel.Bind(wx.EVT_BUTTON, self.swap, ButtonSwap)
		
		LabelL = wx.StaticText(self.panel,-1,"l = ")
		LabelL.Enable(False)
		self.TextA  = wx.TextCtrl(self.panel,  -1,str(self.l[0]),size=(30,-1))
		self.TextA.Enable(False)
		LabelS = wx.StaticText(self.panel,-1," / ")
		LabelS.Enable(False)
		self.TextB  = wx.TextCtrl(self.panel,  -1,str(self.l[1]),size=(30,-1))
		self.TextB.Enable(False)
		
		ButtonClose = wx.Button(self.panel, -1, "Close")
		self.panel.Bind(wx.EVT_BUTTON, self.OnCloseMe, ButtonClose)
		
		BottomSize = wx.BoxSizer()
		
		BottomSize.Add(LabelL,0,wx.FIXED_MINSIZE| wx.RIGHT,10)
		BottomSize.Add(self.TextA,0,wx.FIXED_MINSIZE| wx.RIGHT,3)
		BottomSize.Add(LabelS,0,wx.FIXED_MINSIZE| wx.RIGHT,3)
		BottomSize.Add(self.TextB,0,wx.FIXED_MINSIZE | wx.RIGHT,10)
		
		BottomSize.Add(ButtonSwap,0,wx.FIXED_MINSIZE | wx.RIGHT, 10)
		BottomSize.Add(ButtonClose,0,wx.FIXED_MINSIZE | wx.ALIGN_RIGHT, 10)
		
		#---
		self.MainSize = wx.BoxSizer(wx.VERTICAL)
		self.MainSize.Add(TopSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 10)
		self.MainSize.Add(BottomSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.BOTTOM , 10)
		
		self.panel.SetSizer(self.MainSize)
	def ImageRefresh(self):
		d = 160
		
		# make data_image_thumbnail picture and wxinput
		self.dataimageth = self.obj.datainput[0].copy()
		self.dataimageth.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wximageth = wx.EmptyImage(self.dataimageth.size[0], self.dataimageth.size[1])
		self.wximageth.SetData(self.dataimageth.convert('RGB').tostring())
		
		# make data_bond_thumbnail picture and wxinput
		self.databondth = \
			ImageThreshold(self.obj.datainput[1].copy()).resize \
				((self.dataimageth.size[0], self.dataimageth.size[1]))
		self.databondth.thumbnail((d,d),Image.ANTIALIAS)
		self.wxbondth = wx.EmptyImage(self.databondth.size[0], self.databondth.size[1])
		self.wxbondth.SetData(self.databondth.convert('RGB').tostring())
		
		# refresh!
		self.wxgimage.SetBitmap(self.wximageth.ConvertToBitmap())
		self.wxgbond.SetBitmap(self.wxbondth.ConvertToBitmap())
	def OnCloseMe(self,e):	
		# if there were some change, update value
		#if self.l_old <> self.l:
		a = int(self.TextA.GetValue())
		b = int(self.TextB.GetValue())
		
		if a < 1: a = 1
		if b < 1: b = 1
		self.l = (a,b)
		
		self.obj.properties = ["i2g",self.l,self.s]
			#self.obj.editcount = self.panel.frame.get_editcount()
			#name = str("i2g, " + str(self.degree))
			#objFilter._text(self.obj,name)
			
		### make data!
		i2gconv(self.obj)
		
		# make shape's bitmap
		#self.obj.dataoutput = self.obj.datainput[0]
		self.obj.PreviewBitmap()
		setOutput(self.obj,self.panel.frame)
		# dismiss
		self.panel.frame.Close(True)
