### /gui/viewPanel.py

import wx
from gui.imageimport import *
from conv.pixel	import ImageThreshold

from obj.objImage import objImage 
from obj.objFilter import objFilter
from obj.objGrid import grid

VP_EVT_CHANGE_COLOR = wx.NewEventType()
EVT_VP_CHANGE_COLOR = wx.PyEventBinder(VP_EVT_CHANGE_COLOR, 1)

class ViewPanelEvent(wx.PyCommandEvent):
	def __init__(self, evtType, id):
		wx.PyCommandEvent.__init__(self, evtType, id)
		self.color = None
		self.xy = None
	def SetColor(self, color):
		self.color = color
	def GetColor(self):
		return self.color
	def SetXY(self, xy):
		self.xy = xy
	def GetXY(self):
		return self.xy

def view_grid(grid):
	w = grid.w
	h = grid.h
	data = grid.pil.copy().convert('RGB')
	bond = ImageThreshold(grid.bond.copy()).resize((w,h))
	
	newpil = data.resize((2 * w, 2 * h))

	for i in range(w):
		for j in range(h):
			if bond.getpixel((i,j)) == 255:	# connected
				pass
			else:	# not connected
				newpil.putpixel((2 * i + 1, 2 * j),(255,255,255))
				newpil.putpixel((2 * i + 1, 2 * j + 1),(255,255,255))
	return newpil
class ViewPanel(wx.ScrolledWindow):
	def __init__(self, parent):
		wx.ScrolledWindow.__init__( \
			self, parent, -1, (0, 0), size = wx.DefaultSize, style = wx.SUNKEN_BORDER)
			
		self.obj = None
		self.pil = Image.new('RGB',(1,1), (255,255,255))
		self.OnPaintInit()
		
		self.gridOnOff = False
		
		self.Bind(wx.EVT_LEFT_DOWN, self.OnClick)
		self.Bind(wx.EVT_LEFT_UP, self.OnClick)
		self.Bind(wx.EVT_MOTION, self.OnMotion)
		self.Bind(wx.EVT_PAINT, self.OnPaint)
		
		self.SetScrollRate(20,20)
	def SetObj(self, data):
		if   isinstance(data, Image.Image):
			self.pil = data.copy().convert('RGB')
			self.gridOnOff = False
			self.OnPaintInit()
		elif isinstance(data, grid):
			self.pil = view_grid(data)
			self.rpil = data.pil.copy().convert('RGB')
			
			self.gridOnOff = True
			self.OnPaintInit()
	def OnPaint(self, e = None):
		image = wx.EmptyImage(self.pil.size[0], self.pil.size[1])
		image.SetData(self.pil.convert('RGB').tostring())
		bmp = image.ConvertToBitmap()
		
		dc = wx.PaintDC(self)
		self.PrepareDC(dc)
		
		dc.Clear()
		dc.BeginDrawing()
		dc.DrawBitmap(bmp, 0, 0, True)
		dc.EndDrawing()

		self.maxWidth = bmp.GetWidth()
		self.maxHeight = bmp.GetHeight()
		self.SetVirtualSize((self.maxWidth, self.maxHeight))
	def OnPaintInit(self, e = None):
		image = wx.EmptyImage(self.pil.size[0], self.pil.size[1])
		image.SetData(self.pil.convert('RGB').tostring())
		bmp = image.ConvertToBitmap()
		
		dc = wx.ClientDC(self)
		self.PrepareDC(dc)
		
		dc.Clear()
		dc.BeginDrawing()
		dc.DrawBitmap(bmp, 0, 0, True)
		dc.EndDrawing()

		self.maxWidth = bmp.GetWidth()
		self.maxHeight = bmp.GetHeight()
		self.SetVirtualSize((self.maxWidth, self.maxHeight))
	
	def OnClick(self, e = None):
		evt = ViewPanelEvent(VP_EVT_CHANGE_COLOR, self.GetId())
		
		pos = self.GetPos(e)
		if pos == None: 
			color = (0,0,0)
			pos = (-1, -1)
		else:
			if self.gridOnOff == True:
				color = self.rpil.getpixel((pos[0],pos[1]))				
			else:
				color = self.pil.getpixel((pos[0],pos[1]))
		evt.SetXY((pos[0], pos[1]))
		evt.SetColor(color)
		
		self.GetEventHandler().ProcessEvent(evt)
		if e <> None:
			e.Skip()
	
	def OnMotion(self, e):
		if e.Dragging():
			self.OnClick(e)
	
	def GetPos(self, e):
		xv, yv = self.GetViewStart()
		xd, yd = self.GetScrollPixelsPerUnit()
		
		x = e.GetX() + xv * xd
		y = e.GetY() + yv * yd
				
		if 0 <= x < self.pil.size[0]:
			if 0 <= y < self.pil.size[1]:
				if self.gridOnOff == True:
					x = int(x / 2)
					y = int(y / 2)
				return (x, y)
		return None
		