package net.reduls.igo.dictionary;

import java.io.IOException;
import java.util.List;

public final class Unknown {
    final CharCategory category;
    
    public Unknown(String dataDir) throws IOException {
	category = new CharCategory(dataDir);
    }

    public void search(String text, WordDic wdic, List<ViterbiNode> result) {
	final char ch = text.charAt(0);
	final CharCategory.Category ct = category.category(ch);
	
	if(result.isEmpty()==false && ct.invoke==false)
	    return;
	
	boolean b=true;
	final int limit = Math.min(text.length(), ct.length);
	int i=0;
	for(; i < limit; i++) { 
	    wdic.searchFromId(ct.id, i+1, result);
	    if(i+1!=limit &&
	       category.isCompatible(ch, text.charAt(i+1)) == false) {
		b=false;
		break;
	    }
	}
	
	if(ct.group && b && i < text.length()) {
	    for(; i < text.length(); i++)
		if(category.isCompatible(ch, text.charAt(i)) == false) {
		    wdic.searchFromId(ct.id, i, result);
		    return;
		}
	    wdic.searchFromId(ct.id, text.length(), result);
	}
    }
}