package net.reduls.igo.trie;

final class AutoArray<E> extends java.util.ArrayList<E> {
    public E get(int index, E defaultValue) {
	try {
	    return get(index);
	} catch(IndexOutOfBoundsException e) {
	    for(int i=size(); i <= index*2; i++)
		add(defaultValue);
	    return get(index);
	}
    }
    
    public E set(int index, E element, E defaultValue) {
	try {
	    return set(index,element);
	} catch(IndexOutOfBoundsException e) {
	    for(int i=size(); i <= index*2; i++)
		add(defaultValue);
	    return set(index,element);
	}
    }
}