/*
 * IIIMF-SKK, Japanese Language Engine for 
 *                        IIIMF (Internet/Intranet Input Method Framework)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: adddict.c,v 1.1.1.1 2002/04/06 02:23:31 famao Exp $ */

/* vi:set ts=4 sw=4: */


#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>
#include <X11/Xlib.h>
#include <X11/Xmd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>

#include "xaux_common.h"
#include "xaux_ext_common.h"
#include "skk_xaux.h"

#define SKK_AUX_DIR "/usr/lib/im/locale/ja/skk/xaux"

xaux_class_t xaux_class = {
	"org.kondara.skk.AddDictAux",1,
	NULL, (Window) 0, (Window) 0,
	(Atom) 0, (Atom) 0, (Atom) 0,
	{(Atom) 0,}, 0, {(Atom) 0, },
	0, NULL,
};

typedef struct _InputStatus {
	gint tag;
	gint pid;
}InputStatus;

static GtkWidget *window = NULL;
static xaux_class_t *xc_ = 0;
static GList *wait_process = NULL;
static int im_ = 0;
static int ic_ = 0;
/* static int wait_process = 0; */

static int adddict_x_error (Display *d, XErrorEvent *error);

void skk_aux_adddict_send_engine (gint int_count, gint *integers, gint str_count, gchar **strings);

static int
adddict_x_error (Display *d, XErrorEvent *error)
{
	if (error->error_code) {
		char buf[64];
		XGetErrorText (d, error->error_code, buf, 63);

		fprintf (stderr, "IIIMF-SKK (AddDictAux) **: %s\n serial %ld error_code %d request_code %d minor_code %d\n",
				buf,
				error->serial,
				error->error_code,
				error->request_code,
				error->minor_code);
	}
	return 0;
}

static void
input_func (gpointer data, gint source, GdkInputCondition condition)
{
	int pid;
	int status;
	GList *tmp_list;
	pid = GPOINTER_TO_INT (data);
	waitpid (pid, &status, 0);
	close (source);
	for ( tmp_list = wait_process ; tmp_list ; tmp_list = g_list_next (tmp_list)) {
		InputStatus *s = (InputStatus*)tmp_list->data;
		if (s->pid == pid) {
			gdk_input_remove (s->tag);
			wait_process = g_list_remove_link (wait_process, tmp_list);
			g_list_free_1 (tmp_list);
			g_free (s);
			break;
		}
	}
	return;
}

static void
parse_line_from_child (gchar *str)
{
	gchar **parse;
	gint i;
	gint actual = 0;
	gchar *send_string[2] = {NULL, NULL};
	gint send_status[2];
	if (!str)
		return;
	parse = g_strsplit  (str, "\n", strlen (str));
	for (i = 0; parse[i] && *parse[i] ; i++) {
		if (!strncmp (parse[i], "Result: ", 8)) {
			send_string[0] = g_strdup (parse[i] + 8);
			actual++;
		} else if (!strncmp (parse[i], "Annotation: ", 12)) {
			send_string[1] = g_strdup (parse[i] + 12);
			actual++;
		} else if (!strncmp (parse[i], "Type: ", 6)) {
			send_status[1] = atoi ((parse[i] + 6));
			actual++;
		}
	}
	g_strfreev (parse);
	if (actual != 3) {
		goto end;
	}
	send_status[0] = SKK_AUX_DICT_ADD;
	skk_aux_adddict_send_engine (2, send_status, 2, send_string);

end:
	for (i = 0; i < 2; i++) {
		if (send_string[i]) {
			g_free (send_string[i]);
		}
	}
	return;
}

static GdkFilterReturn
ext_event_handler (GdkXEvent *gdk_xevent, GdkEvent *event, gpointer user_data)
{
    XEvent *xevent;
    xevent = (XEvent *) gdk_xevent;
    if (xevent->type == ClientMessage) {
        xaux_ext_process_client_message(GDK_DISPLAY(), (XClientMessageEvent *) xevent);
        return GDK_FILTER_REMOVE;
    } 
    return GDK_FILTER_CONTINUE;
}

void
skk_aux_adddict_send_engine (gint int_count, gint *integers, gint str_count, gchar **strings)
{
    gint i; 
    aux_ext_data_t *aux_data;

    if (!im_ || !ic_ || !xc_)
        return;
    aux_data = (aux_ext_data_t *) g_new0 (aux_ext_data_t,1);
    aux_data->im = im_;
    aux_data->ic = ic_;
    aux_data->integer_count = int_count;
    aux_data->string_count = str_count;

    if (aux_data->integer_count) {
        aux_data->integer_list = (int *) g_new0 (int, aux_data->integer_count);
        for (i = 0; i < aux_data->integer_count; i++) {
            aux_data->integer_list[i] = integers[i];
        }
    }
    if (aux_data->string_count) {
        aux_data->string_list = (aux_ext_string_t *) g_new0 (aux_ext_string_t, aux_data->string_count)
;
        for (i = 0; i < aux_data->string_count; i++) {
            aux_ext_string_t *p = &aux_data->string_list[i];
            p->length = strlen (strings[i]);
            p->ptr = (guchar *) g_strdup (strings[i]);
        }
    }
    xaux_ext_SetValue (GDK_DISPLAY(), xc_, aux_data);

    if (aux_data->integer_list) {
        g_free (aux_data->integer_list);
    }
    if (aux_data->string_list) {
        for (i = 0; i < aux_data->string_count; i++) {
            aux_ext_string_t *p = &aux_data->string_list[i];
            if (p && p->ptr)
                g_free (p->ptr);
		}
		g_free (aux_data->string_list);
	}
	g_free (aux_data);
	return;
}

static void
reply_initialize (void)
{
	gint status[1];
	status[0] = SKK_AUX_DICT_OK;
	skk_aux_adddict_send_engine (1, status, 0, NULL);
	return;
}

Bool
xaux_ext_Done (xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	return True;
}

Bool
xaux_ext_Start (xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	return True;
}

static void
execute (gchar *str)
{
	int fds[2];
	FILE *fd;
	gchar *cmd;
	gchar buf[1024];
	gchar *tmp;
	gchar *result = NULL;
	pid_t pid;
	gint tag;
	InputStatus *status = NULL;
#if 0
	int status;
	int ret;
#endif

	if (!str)
		return;

	if ((pipe (fds) < 0)) {
		printf ("%s\n",g_strerror (errno));
		return;
	}
	pid = fork ();
	if (pid == 0) {
		close (fds[0]);
		cmd = g_strdup_printf ("%s%s %s", SKK_AUX_DIR, "/AddDictAuxHelper", str);
		/* remove event filter */
		gdk_window_remove_filter (window->window, ext_event_handler, NULL);
		fd = popen (cmd, "r");
		while (fgets (buf, 1024, fd)) {
			if (result) {
				tmp = g_strconcat (result, buf, NULL);
				g_free (result);
				result = tmp;
			} else {
				result = g_strdup (buf);
			}
		}
		pclose (fd);
		g_free (cmd);
		/* Not use exit(0) */
		if (!result) {
			_exit (0);
			return;
		}
		parse_line_from_child (result);
		g_free (result);
		_exit (0);
		return;
	} else if (pid > 0) {
		close (fds[1]);
		tag = gdk_input_add (fds[0], GDK_INPUT_READ, input_func, GINT_TO_POINTER (pid)); 
		status = g_new (InputStatus, 1);
		status->pid = pid;
		status->tag = tag;
		wait_process = g_list_append (wait_process, (gpointer)status);
		/* can't wait now. so increment wait_process */
#if 0
		wait_process++;
		while (TRUE) {
			GdkEvent *event;
			XEvent e;
			ret = waitpid (-1, &status, WNOHANG);
			if (ret > 0) {
				wait_process--;
				if (wait_process == 0)
					break;
			}
			/* Dirty hack */
			/* Block until an event received . */
			XPeekEvent (GDK_DISPLAY (), &e);
			event = gdk_event_get ();
			gdk_event_send_client_message (event, GDK_WINDOW_XWINDOW (window->window));
			gdk_event_free (event);
		
		}
#endif
	} 
	return;
}

Bool
xaux_ext_Draw (xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	gint i;
	im_ = aux_ext_data->im;
	ic_ = aux_ext_data->ic;
	xc_ = xc;

	for (i = 0; i < aux_ext_data->integer_count; i++) {
		switch (aux_ext_data->integer_list[i]) {
			case SKK_AUX_DICT_INIT:
				reply_initialize ();
				break;
			case SKK_AUX_DICT_ADD:
				execute (aux_ext_data->string_list[i].ptr);
				break;
			default:
				break;
		}
	}
	return TRUE;
}

int
main (int argc, char *argv[])
{
	/* GtkWidget *window; */
	setenv ("LC_ALL","ja_JP.eucJP",TRUE);
	gtk_set_locale ();
	gtk_init (&argc,&argv);
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize (window);
	gdk_window_add_filter (window->window, ext_event_handler, NULL);
	if (xaux_ext_init_classes (GDK_DISPLAY (),
				&xaux_class, GDK_WINDOW_XWINDOW (window->window)) == False) {
		exit (1);
	}
	/* Set Error Handler */
	XSetErrorHandler (adddict_x_error);
	gtk_main ();
	return 0;
}
