/*
 * IIIMF-SKK, Japanese Language Engine for 
 *                        IIIMF (Internet/Intranet Input Method Framework)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: adddicthelper.c,v 1.1.1.1 2002/04/06 02:23:31 famao Exp $ */

/* vi:set ts=4 sw=4: */


#include <X11/Xlib.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>
#include <stdlib.h>
#include <stdio.h>
#include "support.h"
#include "pixmaps/hira.xpm"

typedef enum {
	DICT_NORMAL = 0,
	DICT_BACKWARD,
}AddDictHelperResult;

static void
output_result (gchar *result, gchar *annotation, AddDictHelperResult type)
{
	printf ("Result: %s\n", result);
	printf ("Annotation: %s\n", annotation);
	printf ("Type: %d\n", type);
	return;
}

static gint
toplevel_delete (GtkWidget *widget, GdkEventAny *event, gpointer user_data)
{
	output_result ("", "", DICT_BACKWARD);
	gtk_main_quit ();
	return TRUE; /* not reached */
}

static gint
entry_key_press (GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	gchar *result;
#ifdef DEBUG_HELPER
	gchar *tmp;
	tmp = gtk_entry_get_text (GTK_ENTRY (widget));
	g_message ("tmp %s", tmp);
#endif
	if (event->keyval == GDK_Return) {
		result = gtk_entry_get_text (GTK_ENTRY (widget));
		if (!*result)
			return TRUE;
		output_result (result, "", DICT_NORMAL);
		gtk_main_quit ();
	}
	if (event->keyval == GDK_g) {
		if (event->state & GDK_CONTROL_MASK) { 
			output_result ("", "", DICT_BACKWARD);
			gtk_main_quit ();
		}
	}
	return TRUE;
}

static GtkWidget * 
pixmap_new (GtkWidget *parent) 
{   
    GdkColormap *colormap;
    GdkPixmap *gdkpixmap;
    GdkBitmap *mask;
    GtkWidget *pixmap;
    
    colormap = gtk_widget_get_colormap (parent);
    gdkpixmap = gdk_pixmap_colormap_create_from_xpm_d
        (NULL, colormap, &mask, NULL, hira_xpm);
    if (gdkpixmap == NULL)
        return NULL;
    pixmap = gtk_pixmap_new (gdkpixmap, mask);
    gdk_pixmap_unref (gdkpixmap);
    gdk_pixmap_unref (mask);
    return pixmap;
}   

static GtkWidget *
adddicthelper_new (void)
{
    GtkWidget *ret;
    GtkWidget *notebook;
    GtkWidget *frame;
    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkWidget *pixmap;
    GtkWidget *label;
    GtkWidget *sep;
    GtkWidget *entry;

    ret = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_position (GTK_WINDOW (ret), GTK_WIN_POS_CENTER);
#if 0
    gtk_widget_set_events (ret, GDK_CLIENT_EVENT);
    gtk_signal_connect (GTK_OBJECT (ret), "client_event",
            GTK_SIGNAL_FUNC (toplevel_client_event), NULL);
    gtk_widget_realize (ret);
#endif

    notebook = gtk_notebook_new ();
    gtk_container_add (GTK_CONTAINER (ret), notebook);

    frame = gtk_frame_new (NULL);
    gtk_container_add (GTK_CONTAINER (notebook), frame);
//  gtk_container_set_border_width (GTK_CONTAINER (frame), 5);

    gtk_frame_set_label_align (GTK_FRAME (frame), 0.5, 0.5);
    gtk_widget_show (frame);

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
    gtk_widget_show (vbox);
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
    gtk_widget_show (hbox);

    pixmap = pixmap_new (ret);
    gtk_box_pack_start (GTK_BOX (hbox), pixmap, FALSE, FALSE, 0);
    gtk_widget_show (pixmap);

    label = gtk_label_new ("FUGA");
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    gtk_object_set_data (GTK_OBJECT (ret), "direction_word", (gpointer) label);
    gtk_widget_show (label);
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

    sep = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (vbox), sep, TRUE, TRUE, 0);
    sep = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (vbox), sep, TRUE, TRUE, 0);

    entry = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (vbox), entry, TRUE, TRUE, 0);
    gtk_object_set_data (GTK_OBJECT (ret), "entry", (gpointer) entry);
#ifndef USE_GTK2
    gtk_signal_connect (GTK_OBJECT (entry), "key_press_event",
            GTK_SIGNAL_FUNC (entry_key_press), NULL);
#endif
	gtk_editable_set_editable (GTK_EDITABLE (entry), TRUE);
    gtk_widget_show (entry);
    label = gtk_button_new_with_label ("FUGA");
    gtk_widget_set_sensitive (label, FALSE);
    gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
            gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 0), label);
    gtk_widget_show (label);

    gtk_widget_show_all (notebook);

	gtk_signal_connect (GTK_OBJECT (ret), "delete_event",
			GTK_SIGNAL_FUNC (toplevel_delete), NULL);
	return ret;
}

int
main (int argc, char *argv[])
{
	GtkWidget *toplevel;
	GtkWidget *entry;
	GtkWidget *label;
	Window parent;
	int revert_to_r;
#ifdef USE_GTK2
	setenv ("LC_ALL", "ja_JP.eucJP", TRUE);
#else
	setenv ("LC_ALL", "ja_JP.eucJP", TRUE);
#endif
	gtk_set_locale ();
	gtk_init (&argc, &argv);
	if (argc != 2)
		return 1;
	toplevel = adddicthelper_new ();
	XGetInputFocus (GDK_DISPLAY (), &parent, &revert_to_r);
	entry = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (toplevel), "entry");
	label = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (toplevel), "direction_word");
	gtk_label_set_text (GTK_LABEL (label), argv[1]);
	gtk_widget_show (toplevel);
	XSetTransientForHint (GDK_DISPLAY (), GDK_WINDOW_XWINDOW (toplevel->window), parent);
	gtk_window_set_modal (GTK_WINDOW (toplevel), TRUE);
	gtk_widget_grab_focus (entry);
	gtk_main ();
	return 0;
}
