/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkconf.c,v 1.3 2002/04/09 21:10:40 famao Exp $ */

/* vi:set ts=4 sw=4: */


#include <glib.h>
#include <string.h>
#include "skkconf.h"

static void clear (SkkConf *conf);

static void
clear (SkkConf *conf)
{
	if (skkconf_latinstr (conf)) {
		g_free (skkconf_latinstr (conf));
		skkconf_latinstr (conf) = NULL;
	}
	if (skkconf_hirastr (conf)) {
		g_free (skkconf_hirastr (conf));
		skkconf_hirastr (conf) = NULL;
	}
	if (skkconf_katastr (conf)) {
		g_free (skkconf_katastr (conf));
		skkconf_katastr (conf) = NULL;
	}
	if (skkconf_jisx0208str (conf)) {
		g_free (skkconf_jisx0208str (conf));
		skkconf_jisx0208str (conf) = NULL;
	}
	return;
}

SkkConf*
skk_conf_new (void)
{
	SkkConf *ret;
	ret = g_new (SkkConf, 1);
	memset (ret, 0, sizeof (SkkConf));
	ret->skk_echo = TRUE;
	ret->skk_egg_like_newline = FALSE;
	ret->skk_delete_okuri_when_quit = FALSE;
	ret->skk_delete_implies_kakutei = TRUE;
	ret->skk_dabbrev_like_completion = FALSE;
	ret->skk_date_ad = FALSE;
	ret->skk_number_style = 1;
	ret->clear = clear;
	skk_conf_ref (ret);
	return ret;
}

void
skk_conf_destroy (SkkConf *conf)
{
	if (!conf)
		return;
	skk_conf_unref (conf);
	if (conf->ref_count > 0) {
		return;
	}
	skk_conf_clear (conf);
	g_free (conf);
}

void
skk_conf_clear (SkkConf *conf)
{
	if (!conf)
		return;
	if (conf->clear)
		conf->clear (conf);
	conf = NULL;
	return;
}

void
skk_conf_ref (SkkConf *conf)
{
	if (!conf)
		return;
	conf->ref_count++;
	return;
}

void
skk_conf_unref (SkkConf *conf)
{
	if (!conf)
		return;
	conf->ref_count--;
	return;
}

gboolean
skk_conf_get_egg_like_newline (SkkConf *conf)
{
	if (!conf)
		return FALSE;
	return conf->skk_egg_like_newline;
}

void
skk_conf_set_egg_like_newline (SkkConf *conf, gboolean state)
{
	if (!conf)
		return;
	conf->skk_egg_like_newline = state;
	return;
}

gboolean
skk_conf_get_echo (SkkConf *conf)
{
	if (!conf)
		return TRUE;
	return conf->skk_echo;
}

void
skk_conf_set_echo (SkkConf *conf, gboolean state)
{
	if (!conf)
		return;
	conf->skk_echo = state;
	return;
}

gboolean
skk_conf_get_delete_implies_kakutei (SkkConf *conf)
{
	if (!conf)
		return TRUE;
	return conf->skk_delete_implies_kakutei;
}

void
skk_conf_set_delete_implies_kakutei (SkkConf *conf, gboolean state)
{
	if (!conf)
		return;
	conf->skk_delete_implies_kakutei = state;
	return;
}

gboolean
skk_conf_get_delete_okuri_when_quit (SkkConf *conf)
{
	if (!conf)
		return FALSE;
	return conf->skk_delete_okuri_when_quit;
}

void
skk_conf_set_delete_okuri_when_quit (SkkConf *conf, gboolean state)
{
	if (!conf)
		return;
	conf->skk_delete_okuri_when_quit = state;
	return;
}

gboolean
skk_conf_get_dabbrev_like_completion (SkkConf *conf)
{
	if (!conf)
		return FALSE;
	return conf->skk_dabbrev_like_completion;
}

void
skk_conf_set_dabbrev_like_completion (SkkConf *conf, gboolean state)
{
	if (!conf)
		return;
	conf->skk_dabbrev_like_completion = state;
	return;
}

gboolean
skk_conf_get_date_ad (SkkConf *conf)
{
	if (!conf)
		return FALSE;
	return conf->skk_date_ad;
}

void
skk_conf_set_date_ad (SkkConf *conf, gboolean state)
{
	if (!conf)
		return;
	conf->skk_date_ad = state;
}

gint
skk_conf_get_number_style (SkkConf *conf)
{
	if (!conf)
		return 1;
	return conf->skk_number_style;
}

void
skk_conf_set_number_style (SkkConf *conf, gint style)
{
	if (!conf)
		return;
	if (style < 0 || style > 2)
		return;
	conf->skk_number_style = style;
}
