/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkconf.h,v 1.3 2002/04/09 21:10:40 famao Exp $ */

/* vi:set ts=4 sw=4: */


#ifndef HAVE_SKKCONF_H
#define HAVE_SKKCONF_H
#include <glib.h>

#define skkconf_latinstr(x) (x)->skk_latin_mode_string
#define skkconf_hirastr(x) (x)->skk_hirakana_mode_string
#define skkconf_katastr(x) (x)->skk_katakana_mode_string
#define skkconf_jisx0208str(x) (x)->skk_jisx0208_latin_mode_string

typedef struct _SkkConf SkkConf;

struct _SkkConf {
	gint ref_count;
	gint skk_number_style;
	gchar *skk_latin_mode_string;
	gchar *skk_hirakana_mode_string;
	gchar *skk_katakana_mode_string;
	gchar *skk_jisx0208_latin_mode_string;
	gboolean skk_echo;
	gboolean skk_egg_like_newline;
	gboolean skk_delete_implies_kakutei;
	gboolean skk_delete_okuri_when_quit;
	gboolean skk_dabbrev_like_completion;
	gboolean skk_date_ad;

	void (*clear) (SkkConf *conf);
};

SkkConf* skk_conf_new (void);
void skk_conf_destroy (SkkConf *conf);
void skk_conf_clear (SkkConf *conf);
void skk_conf_ref (SkkConf *conf);
void skk_conf_unref (SkkConf *conf);

/* egg_like_newline */
gboolean skk_conf_get_egg_like_newline (SkkConf *conf);
void skk_conf_set_egg_like_newline (SkkConf *conf, gboolean state);
/* echo */
gboolean skk_conf_get_echo (SkkConf *conf);
void skk_conf_set_echo (SkkConf *conf, gboolean state);
/* delete_implies_kakutei */
gboolean skk_conf_get_delete_implies_kakutei (SkkConf *conf);
void skk_conf_set_delete_implies_kakutei (SkkConf *conf, gboolean state);
/* delete_okuri_when_quit */
gboolean skk_conf_get_delete_okuri_when_quit (SkkConf *conf);
void skk_conf_set_delete_okuri_when_quit (SkkConf *conf, gboolean state);
/* dabbrev_like_completion */
gboolean skk_conf_get_dabbrev_like_completion (SkkConf *conf);
void skk_conf_set_dabbrev_like_completion (SkkConf *conf, gboolean state);
/* skk_date_ad */
gboolean skk_conf_get_date_ad (SkkConf *conf);
void skk_conf_set_date_ad (SkkConf *conf, gboolean state);
/* skk_number_style */
gint skk_conf_get_number_style (SkkConf *conf);
void skk_conf_set_number_style (SkkConf *conf, gint style);

#endif /* HAVE_SKKCONF_H */
