/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkconv_kana.h,v 1.1.1.1 2002/04/06 02:23:30 famao Exp $ */

/* vi:set ts=4 sw=4: */


#ifndef SKKCONV_KANA_H
#define SKKCONV_KANA_H
#include <glib.h>

/* This file is generated from skk.el (skk-rom-kana-base-rule-list) */

#define SKKCONV_BASE_RULE_ENCODING	"EUC-JP"

typedef enum {
	SKKCONV_TYPE_NONE = 0,
	SKKCONV_TYPE_NORMAL,
	SKKCONV_TYPE_FUNC,
	SKKCONV_TYPE_USER,
	SKKCONV_TYPE_USER_FUNC
}SkkConvRuleType;

struct _base_rule_list
{
	const gchar *key;
	const gchar *append;
	const gchar *kata;
	const gchar *hira;
	SkkConvRuleType type;
};

typedef struct _base_rule_list base_rule_list;

#define SKKCONV_BASE_RULE_SIZE ((sizeof (baselist))/(sizeof (baselist[0])))

extern base_rule_list baselist[];

gboolean skkconv_rule_init (void);
gchar   *skkconv_hiragana_to_katakana (const gchar *hiragana);
gchar   *skkconv_katakana_to_hiragana (const gchar *katakana);
gchar   *skkconv_get_hiragana (const gchar *key,gchar **append);
gchar   *skkconv_get_katakana (const gchar *key,gchar **append);
gchar	*skkconv_get_func (const gchar *key);
gint skkconv_is_exist (const gchar *key);
SkkConvRuleType skkconv_get_type (const gchar *key);

#endif /* SKKCONV_KANA_H */
