/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkdict.c,v 1.1.1.1 2002/04/06 02:23:30 famao Exp $ */

/* vi:set ts=4 sw=4: */


#include <glib.h>
#include "skkcomm.h"
#include "skkdict.h"
#include "skkdebug.h"

static SkkDict *global_dict = NULL;
static gboolean initialized = FALSE;

static SkkDict* skk_dict_new (void);

static void
clear (SkkDict *dict)
{
}

static SkkDict *
skk_dict_new (void)
{
	SkkDict *ret;
	ret = g_new (SkkDict,1);
	memset (ret,0,sizeof (SkkDict));
	ret->server_sock = -1;
	ret->clear = clear;
	return ret;
}

void
skk_dict_initialize (void)
{
	if (initialized) return;
	global_dict = skk_dict_new ();
	initialized = TRUE;
	return;
}

void
skk_dict_set_server_socket (gint socket)
{
	if (socket < 0) return;
	if (!initialized)
		skk_dict_initialize ();
	if (global_dict->server_sock < 0) {
		global_dict->server_sock = socket;
	}
	return;
}

GList*
skk_dict_query_string (const gchar *buf,const gchar *okuri,gint *found_num)
{
	GList *ret = NULL;
	gchar *query_str;
	gchar *query_result;
	gchar **list;
	gchar *list_count;
	gint index;
	gint recv_status;
	gint found;
	if (!buf)
		return NULL;
	if (!initialized)
		skk_dict_initialize ();
	/* connect */
	if (global_dict->server_sock < 0) {
		global_dict->server_sock = skk_comm_makesock ("localhost","skkserv");
	}
	if (okuri) {
		query_str = g_strdup_printf ("%s%c",buf,okuri[0]);
	} else {
		query_str = g_strdup (buf);
	}
	DEBUG_DO (printf ("skkdict.c : skk_dict_query_string query_str (%s)\n",query_str));
	skk_comm_send (global_dict->server_sock, SKKSERV_SEARCH,query_str);
	skk_comm_recv (global_dict->server_sock, &query_result, &recv_status);
	if (recv_status  == 4) {
		if (query_result)
			g_free (query_result);
		if (found_num) {
			*found_num = 0;
		}
		return NULL;
	}
	if (query_result) {
		list = g_strsplit (query_result,"/",strlen(query_result));
	} else {
		g_free (query_str);
		if (found_num) {
			*found_num = 0;
		}
		return NULL;
	}
	for (index = 0, list_count = list[0],found = 0;
			list_count;
			index++, list_count=list[index]){
		if (list_count && *list_count == '\0') {
			g_free (list_count);
			continue;
		}
		ret = g_list_append (ret,list_count);
		found++;
	}
	if (found_num)
		*found_num = found;
	g_free (query_result);
	g_free (query_str);
	return ret;
}

void
skk_dict_destroy (void)
{
	if (!initialized) return;
	if (global_dict->clear) {
		global_dict->clear (global_dict);
	}
	g_free (global_dict);
	global_dict = NULL;
	return;
}
