#ifndef HAVE_QUERY_IMPL_H
#define HAVE_QUERY_IMPL_H

#include <glib.h>

typedef struct _SkkQueryFunctionImpl SkkQueryFunctionImpl;

struct _SkkQueryFunctionImpl
{
	SkkQueryFunctionImpl * (*impl_new) (void);
	gboolean (*set_next) (SkkQueryFunctionImpl *impl);
	gboolean (*set_prev) (SkkQueryFunctionImpl *impl);
	gboolean (*set_nth) (SkkQueryFunctionImpl *impl);
	GList *  (*do_query) (SkkQueryFunctionImpl *impl, gchar *buf, gchar *okuri, gint *found_num);
	GList *  (*completion) (SkkQueryFunctionImpl *impl, gchar *buf);
	void     (*add) (SkkQueryFunctionImpl *impl);
	void     (*destroy) (SkkQueryFunctionImpl *impl);
	gchar *  (*get_info) (void);
	gint	 (*get_type) (void);
};

SkkQueryFunctionImpl *impl_init (void);

#endif
