/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.uno;

import com.sun.star.uno.ITypeDescription;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.TypeClass;
import java.util.HashMap;

public class Type {
    private static final String TYPE_NAME_VOID = "void";
    private static final String TYPE_NAME_BOOLEAN = "boolean";
    private static final String TYPE_NAME_BYTE = "byte";
    private static final String TYPE_NAME_SHORT = "short";
    private static final String TYPE_NAME_UNSIGNED_SHORT = "unsigned short";
    private static final String TYPE_NAME_LONG = "long";
    private static final String TYPE_NAME_UNSIGNED_LONG = "unsigned long";
    private static final String TYPE_NAME_HYPER = "hyper";
    private static final String TYPE_NAME_UNSIGNED_HYPER = "unsigned hyper";
    private static final String TYPE_NAME_FLOAT = "float";
    private static final String TYPE_NAME_DOUBLE = "double";
    private static final String TYPE_NAME_CHAR = "char";
    private static final String TYPE_NAME_STRING = "string";
    private static final String TYPE_NAME_TYPE = "type";
    private static final String TYPE_NAME_ANY = "any";
    private static final String[] __typeClassToTypeName;
    private static final HashMap __javaClassToTypeClass;
    public static final Type VOID;
    public static final Type CHAR;
    public static final Type BOOLEAN;
    public static final Type BYTE;
    public static final Type SHORT;
    public static final Type UNSIGNED_SHORT;
    public static final Type LONG;
    public static final Type UNSIGNED_LONG;
    public static final Type HYPER;
    public static final Type UNSIGNED_HYPER;
    public static final Type FLOAT;
    public static final Type DOUBLE;
    public static final Type STRING;
    public static final Type TYPE;
    public static final Type ANY;
    protected TypeClass _typeClass;
    protected String _typeName;
    protected Class _class;
    protected ITypeDescription _iTypeDescription;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Type() {
        this.init(null, Void.TYPE, false, false);
    }

    public Type(String string, TypeClass typeClass) {
        this._typeClass = typeClass;
        this._typeName = string;
    }

    public Type(Class clazz) {
        this.init(null, clazz, false, false);
    }

    public Type(Class clazz, boolean bl) {
        this.init(null, clazz, bl, false);
    }

    public Type(ITypeDescription iTypeDescription) {
        this._typeName = iTypeDescription.getTypeName();
        this._typeClass = iTypeDescription.getTypeClass();
        this._iTypeDescription = iTypeDescription;
    }

    public Type(String string) {
        int n;
        if (string.startsWith("[]")) {
            this._typeName = string;
            this._typeClass = TypeClass.SEQUENCE;
            return;
        }
        for (n = 0; n < __typeClassToTypeName.length; ++n) {
            if (!__typeClassToTypeName[n].equals(string)) continue;
            this._typeName = string;
            this._typeClass = TypeClass.fromInt(n);
            return;
        }
        n = string.indexOf(60);
        try {
            this.init(string, Class.forName(n < 0 ? string : string.substring(0, n)), false, n >= 0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.toString());
        }
    }

    public Type(TypeClass typeClass) {
        if (!Type.__isTypeClassPrimitive(typeClass)) {
            throw new IllegalArgumentException(typeClass + " is not primitive");
        }
        this._typeClass = typeClass;
        this._typeName = __typeClassToTypeName[typeClass.getValue()];
    }

    public TypeClass getTypeClass() {
        return this._typeClass;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public Class getZClass() {
        Class clazz;
        Type type = this;
        synchronized (type) {
            block3: {
                try {
                    if (this._class != null) break block3;
                    this._class = this.determineClass();
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            clazz = null;
        }
        clazz = this._class;
        return clazz;
    }

    public ITypeDescription getTypeDescription() {
        return this._iTypeDescription;
    }

    public void setTypeDescription(ITypeDescription iTypeDescription) {
        this._iTypeDescription = iTypeDescription;
    }

    public boolean isSupertypeOf(Type type) {
        if (this._typeClass != type._typeClass) {
            return false;
        }
        switch (this._typeClass.getValue()) {
            case 15: 
            case 20: {
                return this._typeName.equals(type._typeName);
            }
            case 17: {
                if (this._typeName.indexOf(60) >= 0 || type._typeName.indexOf(60) >= 0) {
                    return this._typeName.equals(type._typeName);
                }
            }
            case 19: 
            case 22: {
                Class clazz = this.getZClass();
                Class clazz2 = type.getZClass();
                return clazz != null && clazz2 != null && clazz.isAssignableFrom(clazz2);
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        return object instanceof Type && this._typeClass == ((Type)object)._typeClass && this._typeName.equals(((Type)object)._typeName);
    }

    public int hashCode() {
        return this._typeName.hashCode();
    }

    public String toString() {
        return "Type[" + this._typeName + "]";
    }

    private void init(String string, Class clazz, boolean bl, boolean bl2) {
        TypeClass[] typeClassArray = (TypeClass[])__javaClassToTypeClass.get(clazz);
        if (typeClassArray != null) {
            this._typeClass = typeClassArray[bl ? 1 : 0];
            this._typeName = this._typeClass == TypeClass.INTERFACE ? Type.class$("com.sun.star.uno.XInterface").getName() : __typeClassToTypeName[this._typeClass.getValue()];
        } else if (clazz.isArray()) {
            Type type = new Type(clazz.getComponentType(), bl);
            this._typeClass = type.getTypeClass() != TypeClass.UNKNOWN ? TypeClass.SEQUENCE : TypeClass.UNKNOWN;
            this._typeName = "[]" + type.getTypeName();
        } else if (Type.class$("com.sun.star.uno.Enum").isAssignableFrom(clazz)) {
            this._typeClass = clazz != Type.class$("com.sun.star.uno.Enum") ? TypeClass.ENUM : TypeClass.UNKNOWN;
            this._typeName = clazz.getName();
            this._class = clazz;
        } else if (Type.class$("java.lang.Throwable").isAssignableFrom(clazz)) {
            this._typeClass = Type.class$("com.sun.star.uno.Exception").isAssignableFrom(clazz) || Type.class$("com.sun.star.uno.RuntimeException").isAssignableFrom(clazz) ? TypeClass.EXCEPTION : TypeClass.UNKNOWN;
            this._typeName = clazz.getName();
            this._class = clazz;
        } else if (clazz.isInterface()) {
            this._typeClass = Type.class$("com.sun.star.uno.XInterface").isAssignableFrom(clazz) ? TypeClass.INTERFACE : TypeClass.UNKNOWN;
            this._typeName = clazz.getName();
            this._class = clazz;
        } else if (Type.class$("com.sun.star.uno.XInterface").isAssignableFrom(clazz)) {
            this._typeClass = TypeClass.INTERFACE;
            this._typeName = Type.class$("com.sun.star.uno.XInterface").getName();
            this._class = Type.class$("com.sun.star.uno.XInterface");
        } else {
            this._typeClass = TypeClass.STRUCT;
            this._typeName = string == null ? clazz.getName() : string;
            this._class = clazz;
        }
        if (bl2 && this._typeClass != TypeClass.STRUCT) {
            throw new IllegalArgumentException(clazz + " cannot have type arguments");
        }
    }

    private Class determineClass() {
        switch (this._typeClass.getValue()) {
            case 0: {
                if (this._typeName.equals(TYPE_NAME_VOID)) {
                    return Void.TYPE;
                }
                return null;
            }
            case 2: {
                if (this._typeName.equals(TYPE_NAME_BOOLEAN)) {
                    return Boolean.TYPE;
                }
                return null;
            }
            case 3: {
                if (this._typeName.equals(TYPE_NAME_BYTE)) {
                    return Byte.TYPE;
                }
                return null;
            }
            case 4: {
                if (this._typeName.equals(TYPE_NAME_SHORT)) {
                    return Short.TYPE;
                }
                return null;
            }
            case 5: {
                if (this._typeName.equals(TYPE_NAME_UNSIGNED_SHORT)) {
                    return Short.TYPE;
                }
                return null;
            }
            case 6: {
                if (this._typeName.equals(TYPE_NAME_LONG)) {
                    return Integer.TYPE;
                }
                return null;
            }
            case 7: {
                if (this._typeName.equals(TYPE_NAME_UNSIGNED_LONG)) {
                    return Integer.TYPE;
                }
                return null;
            }
            case 8: {
                if (this._typeName.equals(TYPE_NAME_HYPER)) {
                    return Long.TYPE;
                }
                return null;
            }
            case 9: {
                if (this._typeName.equals(TYPE_NAME_UNSIGNED_HYPER)) {
                    return Long.TYPE;
                }
                return null;
            }
            case 10: {
                if (this._typeName.equals(TYPE_NAME_FLOAT)) {
                    return Float.TYPE;
                }
                return null;
            }
            case 11: {
                if (this._typeName.equals(TYPE_NAME_DOUBLE)) {
                    return Double.TYPE;
                }
                return null;
            }
            case 1: {
                if (this._typeName.equals(TYPE_NAME_CHAR)) {
                    return Character.TYPE;
                }
                return null;
            }
            case 12: {
                if (this._typeName.equals(TYPE_NAME_STRING)) {
                    return Type.class$("java.lang.String");
                }
                return null;
            }
            case 13: {
                if (this._typeName.equals(TYPE_NAME_TYPE)) {
                    return Type.class$("com.sun.star.uno.Type");
                }
                return null;
            }
            case 14: {
                if (this._typeName.equals(TYPE_NAME_ANY)) {
                    return Type.class$("java.lang.Object");
                }
                return null;
            }
            case 20: {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (this._typeName.startsWith("[]", n)) {
                    stringBuffer.append('[');
                    n += "[]".length();
                }
                if (stringBuffer.length() == 0) {
                    return null;
                }
                String string = this._typeName.substring(n);
                if (string.equals(TYPE_NAME_VOID)) {
                    stringBuffer.append('V');
                } else if (string.equals(TYPE_NAME_BOOLEAN)) {
                    stringBuffer.append('Z');
                } else if (string.equals(TYPE_NAME_BYTE)) {
                    stringBuffer.append('B');
                } else if (string.equals(TYPE_NAME_SHORT) || string.equals(TYPE_NAME_UNSIGNED_SHORT)) {
                    stringBuffer.append('S');
                } else if (string.equals(TYPE_NAME_LONG) || string.equals(TYPE_NAME_UNSIGNED_LONG)) {
                    stringBuffer.append('I');
                } else if (string.equals(TYPE_NAME_HYPER) || string.equals(TYPE_NAME_UNSIGNED_HYPER)) {
                    stringBuffer.append('J');
                } else if (string.equals(TYPE_NAME_FLOAT)) {
                    stringBuffer.append('F');
                } else if (string.equals(TYPE_NAME_DOUBLE)) {
                    stringBuffer.append('D');
                } else if (string.equals(TYPE_NAME_CHAR)) {
                    stringBuffer.append('C');
                } else if (string.equals(TYPE_NAME_STRING)) {
                    stringBuffer.append("Ljava.lang.String;");
                } else if (string.equals(TYPE_NAME_TYPE)) {
                    stringBuffer.append("Lcom.sun.star.uno.Type;");
                } else if (string.equals(TYPE_NAME_ANY)) {
                    stringBuffer.append("Ljava.lang.Object;");
                } else {
                    Class<?> clazz;
                    int n2 = string.indexOf(60);
                    if (n2 >= 0) {
                        string = string.substring(0, n2);
                    }
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return null;
                    }
                    if (n2 < 0 && new Type(clazz).getTypeClass() == TypeClass.UNKNOWN) {
                        return null;
                    }
                    stringBuffer.append('L');
                    stringBuffer.append(string);
                    stringBuffer.append(';');
                }
                try {
                    return Class.forName(stringBuffer.toString());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
            case 15: 
            case 19: 
            case 22: {
                Class<?> clazz;
                try {
                    clazz = Class.forName(this._typeName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                if (new Type(clazz).equals(this)) {
                    return clazz;
                }
                return null;
            }
            case 17: {
                Class<?> clazz;
                int n = this._typeName.indexOf(60);
                try {
                    clazz = Class.forName(n < 0 ? this._typeName : this._typeName.substring(0, n));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                if (n >= 0 || new Type(clazz).equals(this)) {
                    return clazz;
                }
                return null;
            }
        }
        return null;
    }

    private static boolean __isTypeClassPrimitive(TypeClass typeClass) {
        return typeClass.getValue() < __typeClassToTypeName.length;
    }

    static {
        TYPE_NAME_VOID = TYPE_NAME_VOID;
        TYPE_NAME_BOOLEAN = TYPE_NAME_BOOLEAN;
        TYPE_NAME_BYTE = TYPE_NAME_BYTE;
        TYPE_NAME_SHORT = TYPE_NAME_SHORT;
        TYPE_NAME_UNSIGNED_SHORT = TYPE_NAME_UNSIGNED_SHORT;
        TYPE_NAME_LONG = TYPE_NAME_LONG;
        TYPE_NAME_UNSIGNED_LONG = TYPE_NAME_UNSIGNED_LONG;
        TYPE_NAME_HYPER = TYPE_NAME_HYPER;
        TYPE_NAME_UNSIGNED_HYPER = TYPE_NAME_UNSIGNED_HYPER;
        TYPE_NAME_FLOAT = TYPE_NAME_FLOAT;
        TYPE_NAME_DOUBLE = TYPE_NAME_DOUBLE;
        TYPE_NAME_CHAR = TYPE_NAME_CHAR;
        TYPE_NAME_STRING = TYPE_NAME_STRING;
        TYPE_NAME_TYPE = TYPE_NAME_TYPE;
        TYPE_NAME_ANY = TYPE_NAME_ANY;
        __typeClassToTypeName = new String[]{TYPE_NAME_VOID, TYPE_NAME_CHAR, TYPE_NAME_BOOLEAN, TYPE_NAME_BYTE, TYPE_NAME_SHORT, TYPE_NAME_UNSIGNED_SHORT, TYPE_NAME_LONG, TYPE_NAME_UNSIGNED_LONG, TYPE_NAME_HYPER, TYPE_NAME_UNSIGNED_HYPER, TYPE_NAME_FLOAT, TYPE_NAME_DOUBLE, TYPE_NAME_STRING, TYPE_NAME_TYPE, TYPE_NAME_ANY};
        __javaClassToTypeClass = new HashMap();
        __javaClassToTypeClass.put(Void.TYPE, new TypeClass[]{TypeClass.VOID, TypeClass.VOID});
        __javaClassToTypeClass.put(Type.class$("java.lang.Void"), new TypeClass[]{TypeClass.VOID, TypeClass.VOID});
        __javaClassToTypeClass.put(Boolean.TYPE, new TypeClass[]{TypeClass.BOOLEAN, TypeClass.BOOLEAN});
        __javaClassToTypeClass.put(Type.class$("java.lang.Boolean"), new TypeClass[]{TypeClass.BOOLEAN, TypeClass.BOOLEAN});
        __javaClassToTypeClass.put(Byte.TYPE, new TypeClass[]{TypeClass.BYTE, TypeClass.BYTE});
        __javaClassToTypeClass.put(Type.class$("java.lang.Byte"), new TypeClass[]{TypeClass.BYTE, TypeClass.BYTE});
        __javaClassToTypeClass.put(Short.TYPE, new TypeClass[]{TypeClass.SHORT, TypeClass.UNSIGNED_SHORT});
        __javaClassToTypeClass.put(Type.class$("java.lang.Short"), new TypeClass[]{TypeClass.SHORT, TypeClass.UNSIGNED_SHORT});
        __javaClassToTypeClass.put(Integer.TYPE, new TypeClass[]{TypeClass.LONG, TypeClass.UNSIGNED_LONG});
        __javaClassToTypeClass.put(Type.class$("java.lang.Integer"), new TypeClass[]{TypeClass.LONG, TypeClass.UNSIGNED_LONG});
        __javaClassToTypeClass.put(Long.TYPE, new TypeClass[]{TypeClass.HYPER, TypeClass.UNSIGNED_HYPER});
        __javaClassToTypeClass.put(Type.class$("java.lang.Long"), new TypeClass[]{TypeClass.HYPER, TypeClass.UNSIGNED_HYPER});
        __javaClassToTypeClass.put(Float.TYPE, new TypeClass[]{TypeClass.FLOAT, TypeClass.FLOAT});
        __javaClassToTypeClass.put(Type.class$("java.lang.Float"), new TypeClass[]{TypeClass.FLOAT, TypeClass.FLOAT});
        __javaClassToTypeClass.put(Double.TYPE, new TypeClass[]{TypeClass.DOUBLE, TypeClass.DOUBLE});
        __javaClassToTypeClass.put(Type.class$("java.lang.Double"), new TypeClass[]{TypeClass.DOUBLE, TypeClass.DOUBLE});
        __javaClassToTypeClass.put(Character.TYPE, new TypeClass[]{TypeClass.CHAR, TypeClass.CHAR});
        __javaClassToTypeClass.put(Type.class$("java.lang.Character"), new TypeClass[]{TypeClass.CHAR, TypeClass.CHAR});
        __javaClassToTypeClass.put(Type.class$("java.lang.String"), new TypeClass[]{TypeClass.STRING, TypeClass.STRING});
        __javaClassToTypeClass.put(Type.class$("com.sun.star.uno.Type"), new TypeClass[]{TypeClass.TYPE, TypeClass.TYPE});
        __javaClassToTypeClass.put(Type.class$("com.sun.star.uno.Any"), new TypeClass[]{TypeClass.ANY, TypeClass.ANY});
        __javaClassToTypeClass.put(Type.class$("java.lang.Object"), new TypeClass[]{TypeClass.ANY, TypeClass.INTERFACE});
        VOID = new Type(Void.TYPE);
        CHAR = new Type(Character.TYPE);
        BOOLEAN = new Type(Boolean.TYPE);
        BYTE = new Type(Byte.TYPE);
        SHORT = new Type(Short.TYPE);
        UNSIGNED_SHORT = new Type(TYPE_NAME_UNSIGNED_SHORT, TypeClass.UNSIGNED_SHORT);
        LONG = new Type(Integer.TYPE);
        UNSIGNED_LONG = new Type(TYPE_NAME_UNSIGNED_LONG, TypeClass.UNSIGNED_LONG);
        HYPER = new Type(Long.TYPE);
        UNSIGNED_HYPER = new Type(TYPE_NAME_UNSIGNED_HYPER, TypeClass.UNSIGNED_HYPER);
        FLOAT = new Type(Float.TYPE);
        DOUBLE = new Type(Double.TYPE);
        STRING = new Type(Type.class$("java.lang.String"));
        TYPE = new Type(Type.class$("com.sun.star.uno.Type"));
        ANY = new Type(Type.class$("com.sun.star.uno.Any"));
    }
}

